/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentCiImportAction
extends WmiMathMLImportAction {
    private static final String TYPE = "type";
    private static final String FUNCTION = "function";
    private String type = "";

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
        return WmiMathFactory.createMathIdentifierToken(doc, "", context);
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.type = source.getValue(TYPE) != null ? source.getValue(TYPE) : "";
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathMLImportParser mathmlParser = (WmiMathMLImportParser)parser;
        WmiModel active = mathmlParser.getActiveModel();
        if (active instanceof WmiInlineMathModel) {
            try {
                WmiMathModel newActive = (WmiMathModel)((WmiInlineMathModel)active).getChild(0);
                ((WmiInlineMathModel)active).removeChild(newActive);
                active = newActive;
                mathmlParser.setActiveModel(active);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        if (active instanceof WmiMathModel) {
            WmiMathAttributeSet attrs = (WmiMathAttributeSet)active.getAttributes();
            attrs.addAttribute("Typesetting:-msemantics", this.type);
            active.setAttributes(attrs);
        }
        mathmlParser.pushApplyFunction(active);
        super.endAction(parser, inputSource);
    }
}

