/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentCnImportAction
extends WmiMathMLImportAction {
    private static final String TYPE = "type";
    private static final String BASE = "base";
    private String type = "";
    private int base = 0;

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
        return WmiMathFactory.createMathNumericToken(doc, "", context);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel doc = parser.getDocument();
        WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
        WmiModel active = ((WmiMathMLImportParser)parser).getActiveModel();
        WmiCompositeModel parent = active.getParent();
        try {
            if (this.type.equals("integer") && this.base >= 2) {
                WmiSubscriptModel sub = new WmiSubscriptModel(doc);
                sub.replaceChild(active, 0);
                sub.replaceChild(WmiMathFactory.createMathNumericToken(doc, String.valueOf(this.base), context), 1);
                sub.setParent(parent);
                sub.addAttribute("Typesetting:-msemantics", "integer");
                ((WmiMathMLImportParser)parser).setActiveModel(sub);
            } else if (this.type.equals("rational")) {
                String value = ((WmiNumericModel)active).getText().trim();
                String num = value.substring(0, value.indexOf(" ")).trim();
                String denom = value.substring(value.indexOf(" ") + 1).trim();
                WmiMathTokenModel numerator = WmiMathFactory.createMathNumericToken(doc, num, context);
                WmiMathTokenModel denominator = WmiMathFactory.createMathNumericToken(doc, denom, context);
                WmiMathModel rational = WmiNumericModel.WmiRationalBuilder.createInlineFraction(doc, numerator, denominator, context);
                rational.setParent(parent);
                rational.addAttribute("Typesetting:-msemantics", "rational");
                ((WmiMathMLImportParser)parser).setActiveModel(rational);
            } else if (this.type.equals("complex-polar")) {
                WmiInlineMathModel row = new WmiInlineMathModel(doc);
                WmiMathTokenModel polar = WmiMathFactory.createMathIdentifierToken(doc, "polar", context);
                WmiMathTokenModel applyF = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
                String value = ((WmiNumericModel)active).getText().trim();
                String firstParam = value.substring(0, value.indexOf(" ")).trim();
                String secondParam = value.substring(value.indexOf(" ") + 1).trim();
                WmiMathTokenModel first = WmiMathFactory.createMathNumericToken(doc, firstParam, context);
                WmiMathTokenModel second = WmiMathFactory.createMathNumericToken(doc, secondParam, context);
                WmiModel[] children = new WmiModel[]{first, second};
                WmiMathFencedModel fence = new WmiMathFencedModel(doc, children, context);
                row.appendChild(polar);
                row.appendChild(applyF);
                row.appendChild(fence);
                row.setParent(parent);
                row.addAttribute("Typesetting:-msemantics", "complex-polar");
                ((WmiMathMLImportParser)parser).setActiveModel(row);
            } else if (this.type.equals("complex-cartesian")) {
                WmiInlineMathModel row = new WmiInlineMathModel(doc);
                WmiMathTokenModel plus = WmiMathFactory.createMathOperatorToken(doc, "&plus;", context);
                WmiMathTokenModel invTimes = WmiMathFactory.createMathOperatorToken(doc, "&InvisibleTimes;", context);
                String value = ((WmiNumericModel)active).getText().trim();
                int spaceIndex = value.indexOf(" ") > -1 ? value.indexOf(" ") : 0;
                String firstParam = value.substring(0, spaceIndex).trim();
                String secondParam = value.substring(spaceIndex + 1).trim();
                WmiMathTokenModel first = WmiMathFactory.createMathNumericToken(doc, firstParam, context);
                WmiMathTokenModel second = WmiMathFactory.createMathNumericToken(doc, secondParam, context);
                WmiInlineMathModel mult = new WmiInlineMathModel(doc);
                WmiMathTokenModel imaginaryI = WmiMathFactory.createMathIdentifierToken(doc, "&ImaginaryI;", context);
                mult.appendChild(second);
                mult.appendChild(invTimes);
                mult.appendChild(imaginaryI);
                row.appendChild(first);
                row.appendChild(plus);
                row.appendChild(mult);
                row.setParent(parent);
                row.addAttribute("Typesetting:-msemantics", "complex-cartesian");
                ((WmiMathMLImportParser)parser).setActiveModel(row);
            } else if (this.type.equals("constant")) {
                active.addAttribute("Typesetting:-msemantics", "constant");
            }
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        super.endAction(parser, inputSource);
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String baseString;
        this.type = "";
        this.base = 0;
        String typeString = source.getValue(TYPE);
        if (typeString != null) {
            this.type = typeString;
        }
        if ((baseString = source.getValue(BASE)) != null) {
            this.base = Integer.parseInt(baseString);
        }
    }
}

