/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentDeclareImportAction
extends WmiMathMLImportAction {
    public static final String TYPE = "type";
    public static final String NARGS = "nargs";
    public static final String OCCURENCE = "occurence";
    private String type;
    private int nargs;
    private String occurence;
    private WmiMathMLImportParser.WmiMathMLDeclaration declaration;

    @Override
    public void beginAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.declaration = new WmiMathMLImportParser.WmiMathMLDeclaration();
        this.processAttributes(parser, (Attributes)inputSource, null);
        super.beginAction(parser, inputSource);
    }

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiInlineMathModel m = new WmiInlineMathModel(doc);
        try {
            m.addAttribute("Typesetting:-msemantics", "declare");
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return m;
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel active = (WmiInlineMathModel)((WmiMathMLImportParser)parser).getActiveModel();
        this.declaration.setType(this.type);
        this.declaration.setNargs(this.nargs);
        this.declaration.setOccurence(this.occurence);
        this.declaration.setDefinition((WmiInlineMathModel)active.getChild(1));
        String name = ((WmiIdentifierModel)active.getChild(0)).getText();
        ((WmiMathMLImportParser)parser).addDeclaration(name, this.declaration);
        super.endAction(parser, inputSource);
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String occurenceString;
        String nargsString;
        String typeString = source.getValue(TYPE);
        if (typeString != null) {
            this.type = typeString;
        }
        if ((nargsString = source.getValue(NARGS)) != null) {
            this.nargs = Integer.parseInt(nargsString);
        }
        if ((occurenceString = source.getValue(OCCURENCE)) != null) {
            this.occurence = occurenceString;
        }
    }
}

