/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentListImportAction
extends WmiMathMLImportAction {
    private static final String ORDER = "order";
    private static final String NUMERIC = "numeric";
    private static final String LEXICOGRAPHIC = "lexicographic";
    private String order = "";

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathFencedModel m = null;
        try {
            WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
            m = new WmiMathFencedModel(doc, new WmiModel[0], context);
            m.addAttribute("Typesetting:-msemantics", "list");
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return m;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String orderString = source.getValue(ORDER);
        if (orderString != null) {
            this.order = orderString;
        }
        if (this.order.equals(NUMERIC)) {
            model.addAttribute("Typesetting:-msemantics", "list-numeric");
        } else if (this.order.equals(LEXICOGRAPHIC)) {
            model.addAttribute("Typesetting:-msemantics", "list-lexicographic");
        } else {
            model.addAttribute("Typesetting:-msemantics", "list");
        }
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ((WmiMathMLImportParser)parser).updateListModel();
        super.endAction(parser, inputSource);
    }
}

