/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMfracImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
        return new WmiFractionModel(doc, context);
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String bevelled;
        String numeratorAlignment;
        String denominatorAlignment;
        super.processAttributes(parser, source, model);
        WmiFractionModel.WmiFractionAttributeSet charAttr = (WmiFractionModel.WmiFractionAttributeSet)model.getAttributes();
        String lineThickness = source.getValue("linethickness");
        if (lineThickness != null) {
            charAttr.addAttribute("linethickness", lineThickness);
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.LINETHICKNESS_FLAG);
        }
        if ((denominatorAlignment = source.getValue("denomalign")) != null) {
            charAttr.addAttribute("denomalign", denominatorAlignment);
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.DENOMALIGN_FLAG);
        }
        if ((numeratorAlignment = source.getValue("numalign")) != null) {
            charAttr.addAttribute("numalign", numeratorAlignment);
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.NUMALIGN_FLAG);
        }
        if ((bevelled = source.getValue("bevelled")) != null) {
            charAttr.addAttribute("bevelled", bevelled);
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.BEVELLED_FLAG);
        }
        model.setAttributes(charAttr);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            try {
                ((WmiMathMLImportParser)parser).updateFractionModel();
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
            }
            super.endAction(parser, inputSource);
        }
    }
}

