/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMpaddedImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathPaddedModel m = null;
        try {
            try {
                WmiModelLock.writeLock(doc, true);
                m = new WmiMathPaddedModel(doc);
                m.addChild(new WmiInlineMathModel(doc), 0);
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
                WmiModelLock.writeUnlock(doc);
            }
            catch (WmiNoWriteAccessException nwae) {
                WmiErrorLog.log(nwae);
                WmiModelLock.writeUnlock(doc);
            }
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return m;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String lspace;
        String depth;
        String height;
        super.processAttributes(parser, source, model);
        WmiMathPaddedModel.WmiMathPaddedAttributeSet charAttr = (WmiMathPaddedModel.WmiMathPaddedAttributeSet)model.getAttributes();
        String width = source.getValue("width");
        if (width != null) {
            charAttr.addAttribute("width", width);
        }
        if ((height = source.getValue("height")) != null) {
            charAttr.addAttribute("height", height);
        }
        if ((depth = source.getValue("depth")) != null) {
            charAttr.addAttribute("depth", depth);
        }
        if ((lspace = source.getValue("lspace")) != null) {
            charAttr.addAttribute("lspace", lspace);
        }
        model.setAttributes(charAttr);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            try {
                ((WmiMathMLImportParser)parser).updatePaddedModel();
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
            }
            super.endAction(parser, inputSource);
        }
    }
}

