/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMphantomImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathPhantomModel m = null;
        try {
            try {
                WmiModelLock.writeLock(doc, true);
                m = new WmiMathPhantomModel(doc);
                m.addChild(new WmiInlineMathModel(doc), 0);
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
                WmiModelLock.writeUnlock(doc);
            }
            catch (WmiNoWriteAccessException nwae) {
                WmiErrorLog.log(nwae);
                WmiModelLock.writeUnlock(doc);
            }
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return m;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super.processAttributes(parser, source, model);
        WmiMathPhantomModel.WmiMathPhantomAttributeSet charAttr = (WmiMathPhantomModel.WmiMathPhantomAttributeSet)model.getAttributes();
        String constraint = source.getValue("constraints");
        if (constraint != null) {
            charAttr.addAttribute("constraints", constraint);
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.CONSTRAINTS_FLAG);
        }
        model.setAttributes(charAttr);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            try {
                ((WmiMathMLImportParser)parser).updatePhantomModel();
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
            }
            super.endAction(parser, inputSource);
        }
    }
}

