/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMrowImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiInlineMathModel m = null;
        try {
            WmiModelLock.writeLock(doc, true);
            m = new WmiInlineMathModel(doc);
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return m;
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            ((WmiMathMLImportParser)parser).updateRowModel();
            super.endAction(parser, inputSource);
        }
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super.processAttributes(parser, source, model);
        WmiMathAttributeSet charAttr = (WmiMathAttributeSet)model.getAttributes();
        String semantics = source.getValue("Typesetting:-msemantics");
        if (semantics != null) {
            charAttr.addAttribute("Typesetting:-msemantics", semantics);
        }
        model.addAttributes(charAttr);
        if (WmiModelLock.updateLock(model, true)) {
            try {
                try {
                    model.update(null);
                }
                catch (WmiNoUpdateAccessException nuae) {
                    WmiErrorLog.log(nuae);
                    WmiModelLock.updateUnlock(model);
                }
            }
            finally {
                WmiModelLock.updateUnlock(model);
            }
        }
    }
}

