/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import java.awt.Color;
import org.xml.sax.Attributes;

public abstract class WmiMathMLTokenImportAction
extends WmiMathMLImportAction {
    @Override
    public abstract WmiModel createModel(WmiMathDocumentModel var1);

    public static Color parseColor(String colorString, Color defaultColor) {
        Color color;
        block9: {
            color = null;
            if (!colorString.startsWith("#")) {
                try {
                    String colorValue = WmiMathAttributeSet.getColour(colorString.toLowerCase());
                    if (!colorValue.equals("")) {
                        color = Color.decode(colorValue);
                        break block9;
                    }
                    color = defaultColor;
                }
                catch (NumberFormatException nfe) {
                    color = defaultColor;
                }
            } else {
                try {
                    if (colorString.length() == 4) {
                        String fullColorString = String.valueOf(colorString.substring(1, 2)) + "0" + colorString.substring(2, 3) + "0" + colorString.substring(3, 4) + "0";
                        color = Color.decode("0x" + fullColorString);
                    } else {
                        color = Color.decode("0x" + colorString.substring(1));
                    }
                }
                catch (NumberFormatException nfe) {
                    color = defaultColor;
                }
            }
        }
        return color;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super.processAttributes(parser, source, model);
        WmiAttributeSet attributes = model.getAttributes();
        WmiMathAttributeSet charAttr = null;
        if (attributes instanceof WmiMathAttributeSet) {
            charAttr = (WmiMathAttributeSet)attributes;
        }
        if (charAttr != null) {
            String fontFamily;
            String mathvariant;
            String mathsize;
            String mathbackground;
            String mathcolor = source.getValue("mathcolor");
            if (mathcolor == null) {
                mathcolor = source.getValue("color");
            }
            if (mathcolor != null) {
                mathcolor = mathcolor.toLowerCase();
                Color color = WmiMathMLTokenImportAction.parseColor(mathcolor, Color.BLACK);
                charAttr.setForeground(color.getRGB());
                if (model instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)model).setModifiedFlag(1);
                }
            }
            if ((mathbackground = source.getValue("mathbackground")) != null) {
                mathbackground = mathbackground.toLowerCase();
                Color color = WmiMathMLTokenImportAction.parseColor(mathbackground, Color.WHITE);
                charAttr.setBackground(color.getRGB());
                charAttr.setExtendedStyle(32);
                if (model instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)model).setModifiedFlag(2);
                }
            }
            if ((mathsize = source.getValue("mathsize")) == null) {
                mathsize = source.getValue("fontsize");
            }
            if (mathsize != null) {
                try {
                    mathsize = mathsize.toLowerCase();
                    charAttr.setSize(Integer.parseInt(mathsize));
                    if (model instanceof WmiAbstractMathTokenModel) {
                        ((WmiAbstractMathTokenModel)model).setModifiedFlag(4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((mathvariant = source.getValue("mathvariant")) == null) {
                boolean isItalic;
                String weight = source.getValue("fontweight");
                String style = source.getValue("fontstyle");
                boolean isBold = weight != null && weight.equals("bold") ? true : charAttr.isBold();
                boolean bl = isItalic = style != null && style.equals("italic") ? true : charAttr.isItalic();
                if (isBold) {
                    mathvariant = isItalic ? "bold-italic" : "bold";
                } else if (isItalic) {
                    mathvariant = "italic";
                }
            }
            if (mathvariant != null) {
                int extendedStyle = charAttr.getExtendedStyle();
                charAttr.setExtendedStyle(extendedStyle & 0xFFFFFFFD);
                charAttr.addAttribute("mathvariant", mathvariant.toLowerCase());
                if (model instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)model).setModifiedFlag(8);
                }
            }
            if ((fontFamily = source.getValue("fontfamily")) != null) {
                charAttr.addAttribute("fontfamily", fontFamily);
                if (model instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)model).setModifiedFlag(16);
                }
            }
            model.setAttributes(charAttr);
        }
    }
}

