/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.io.IOException;

public class WmiMathMLNumericExportAction
extends WmiMathMLExportAction {
    private static final String NUMERIC_PUNCTUATION_PATTERN = "[,\\.\\-\\+]";
    private static final String SCIENTIFIC_NOTATION_PATTERN = "[0-9]+e[\\+\\-" + WmiMathEntityNameMapper.getUnicodeCharacter("minus") + "]?[0-9]+";

    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        WmiNumericModel numeric = (WmiNumericModel)model;
        formatter.writeBinary("<mn");
        try {
            formatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)numeric.getAttributes())));
            formatter.writeBinary(">");
            String contents = numeric.getTokenContents();
            int i = 0;
            while (i < contents.length()) {
                char c = contents.charAt(i);
                if (!Character.toString(c).matches(NUMERIC_PUNCTUATION_PATTERN) && !contents.matches(SCIENTIFIC_NOTATION_PATTERN) && WmiMathEntityNameMapper.getEntityName(c) != null) {
                    formatter.writeBinary("&" + WmiMathEntityNameMapper.getEntityName(c) + ";");
                } else {
                    formatter.writeBinary(String.valueOf(c));
                }
                ++i;
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("</mn>");
    }
}

