/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import java.io.IOException;

public class WmiMathMLRowExportAction
extends WmiMathMLExportAction {
    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        if (this.doExport(model)) {
            formatter.writeBinary("<mrow>");
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        if (this.doExport(model)) {
            formatter.writeBinary("</mrow>");
        }
    }

    private boolean doExport(WmiModel model) {
        WmiInlineMathModel inline = (WmiInlineMathModel)model;
        boolean export = true;
        try {
            if (inline.getChildCount() == 1 && inline.getChild(0).getTag() == WmiModelTag.MATH_ROW || inline.getChildCount() == 3 && WmiModelUtil.isEmptyIdentifierModel(inline.getChild(0)) && inline.getChild(1).getTag() == WmiModelTag.MATH_ROW && WmiModelUtil.isEmptyIdentifierModel(inline.getChild(2))) {
                export = false;
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return export;
    }
}

