/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import java.io.IOException;
import java.util.HashMap;

public class WmiMathMLTransferExportAction
extends WmiMathMLExportAction {
    private static HashMap tagMap = new HashMap();

    static {
        tagMap.put(WmiModelTag.MATH, "math");
        tagMap.put(WmiModelTag.MATH_IDENTIFIER, "mi");
        tagMap.put(WmiModelTag.MATH_NUMERIC, "mn");
        tagMap.put(WmiModelTag.MATH_OPERATOR, "mo");
        tagMap.put(WmiModelTag.MATH_TEXT, "mtext");
        tagMap.put(WmiModelTag.MATH_SPACE, "mspace");
        tagMap.put(WmiModelTag.MATH_STRING, "mstring");
        tagMap.put(WmiModelTag.MATH_GLYPH, "mglyph");
        tagMap.put(WmiModelTag.MATH_ROW, "mrow");
        tagMap.put(WmiModelTag.MATH_ENCLOSE, "menclose");
        tagMap.put(WmiModelTag.MATH_FRAC, "mfrac");
        tagMap.put(WmiModelTag.MATH_SQUARE_ROOT, "msqrt");
        tagMap.put(WmiModelTag.MATH_NROOT, "mroot");
        tagMap.put(WmiModelTag.MATH_STYLE, "mstyle");
        tagMap.put(WmiModelTag.MATH_ERROR, "merror");
        tagMap.put(WmiModelTag.MATH_PADDED, "mpadded");
        tagMap.put(WmiModelTag.MATH_PHANTOM, "mphantom");
        tagMap.put(WmiModelTag.MATH_FENCED, "mfenced");
        tagMap.put(WmiModelTag.MATH_SUBSCRIPT, "msub");
        tagMap.put(WmiModelTag.MATH_SUPERSCRIPT, "msup");
        tagMap.put(WmiModelTag.MATH_SUB_SUP, "msubsup");
        tagMap.put(WmiModelTag.MATH_UNDER, "munder");
        tagMap.put(WmiModelTag.MATH_OVER, "mover");
        tagMap.put(WmiModelTag.MATH_UNDER_OVER, "munderover");
        tagMap.put(WmiModelTag.MATH_MULTISCRIPTS, "mmultiscripts");
        tagMap.put(WmiModelTag.MATH_PRESCRIPTS, "mprescripts");
        tagMap.put(WmiModelTag.MATH_NONE, "mnone");
        tagMap.put(WmiModelTag.MATH_TABLE, "mtable");
        tagMap.put(WmiModelTag.MATH_TABLE_ROW, "mtr");
        tagMap.put(WmiModelTag.MATH_TABLE_LABELED_ROW, "mlabeledtr");
        tagMap.put(WmiModelTag.MATH_TABLE_CELL, "mtd");
        tagMap.put(WmiModelTag.MATH_ALIGN_GROUP, "maligngroup");
        tagMap.put(WmiModelTag.MATH_ALIGN_MARK, "malignmark");
        tagMap.put(WmiModelTag.MATH_ACTION, "maction");
    }

    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        try {
            String tag = (String)tagMap.get(model.getTag());
            formatter.writeBinary("<" + tag);
            formatter.writeText(this.exportAttributes(model.getAttributes().getAttributeNames(), (WmiAbstractArrayAttributeSet)model.getAttributes()));
            formatter.writeBinary(">");
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        String tag = (String)tagMap.get(model.getTag());
        formatter.writeBinary("</" + tag + ">");
    }
}

