/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import java.io.IOException;
import java.util.Enumeration;

public class WmiXMLBlockExportAction
implements WmiExportAction {
    protected WmiAttributeSet getAttributes(WmiModel model) throws WmiNoReadAccessException {
        return model.getAttributesForRead();
    }

    protected String[] getRelevantAttributeKeys() {
        return null;
    }

    protected String getTagText(WmiModel model) throws WmiNoReadAccessException {
        WmiModelTag tag = model.getTag();
        return tag == null ? null : tag.toString();
    }

    protected void processAttributes(WmiAttributeSet attrSet, WmiExportFormatter formatter) throws WmiNoReadAccessException, IOException {
        String[] attrRestrict = this.getRelevantAttributeKeys();
        if (attrRestrict == null) {
            Enumeration names = attrSet.getAttributeNames();
            while (names.hasMoreElements()) {
                Object key = names.nextElement();
                formatter.writeAttribute(key, attrSet.getAttribute(key));
            }
        } else {
            int a = 0;
            while (a < attrRestrict.length) {
                String key = attrRestrict[a];
                Object value = attrSet.getAttribute(key);
                if (value != null) {
                    formatter.writeAttribute(key, value);
                }
                ++a;
            }
        }
    }

    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws WmiNoReadAccessException, IOException {
        if (formatter != null && model != null) {
            formatter.openCompositeModel(model.getTag());
            formatter.writeBinary("<");
            formatter.writeBinary(this.getTagText(model));
            WmiAttributeSet attrSet = this.getAttributes(model);
            if (attrSet != null && attrSet.getAttributeCount() > 0) {
                this.processAttributes(attrSet, formatter);
            }
            formatter.writeBinary(">");
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws WmiNoReadAccessException, IOException {
        if (formatter != null && model != null) {
            formatter.closeCompositeModel(model.getTag());
            formatter.writeBinary("</");
            formatter.writeBinary(this.getTagText(model));
            formatter.writeBinary(">");
        }
    }

    @Override
    public boolean processChildModels() {
        return true;
    }
}

