/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiModelException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.xml.WmiXMLImportParser;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WmiXMLModelBuilder
implements ContentHandler {
    protected WmiXMLImportParser importParser;
    protected StringBuffer textBuffer = new StringBuffer();
    protected Stack openElements = new Stack();

    public WmiXMLModelBuilder(WmiXMLImportParser importParser) {
        this.importParser = importParser;
    }

    protected void flushCharacterBuffer() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (this.textBuffer.length() > 0) {
            try {
                if (this.importParser != null) {
                    this.importParser.defineTextContent(this.textBuffer.toString());
                }
            }
            finally {
                this.textBuffer = new StringBuffer();
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0 && !this.openElements.isEmpty()) {
            Object currentElement = this.openElements.peek();
            if (this.importParser != null && this.importParser.getParseAction(currentElement.toString()) != null) {
                this.textBuffer.append(ch, start, length);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flushCharacterBuffer();
            if (this.importParser != null) {
                this.importParser.closeRootModel();
            }
            this.openElements.clear();
        }
        catch (WmiModelException writeE) {
            throw new SAXException(writeE);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            WmiImportAction action;
            this.flushCharacterBuffer();
            if (this.importParser != null && (action = this.importParser.getParseAction(qName)) != null) {
                action.endAction(this.importParser, qName);
            }
            if (!this.openElements.isEmpty()) {
                this.openElements.pop();
            }
        }
        catch (WmiModelException readE) {
            throw new SAXException(readE);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.textBuffer.setLength(0);
        this.openElements.clear();
        if (this.importParser != null) {
            this.importParser.openRootModel();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.flushCharacterBuffer();
            if (this.importParser != null) {
                WmiImportAction action = this.importParser.getParseAction(qName);
                if (action == null) {
                    this.importParser.reportUnrecognizedTag(qName, atts);
                } else {
                    action.beginAction(this.importParser, atts);
                }
            }
            this.openElements.push(qName);
        }
        catch (WmiModelException readE) {
            throw new SAXException(readE);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

