/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiModelNoSuchChildException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCandidateModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public abstract class WmiAbstractArrayCandidateModel
extends WmiAbstractArrayCompositeModel
implements WmiCandidateModel,
Cloneable {
    public static final float DEFAULT_CONFIDENCE = 1.0f;
    private static final boolean STRICT_CHILD_CHECKING = false;
    private CandidateComparator comparator = new CandidateComparator();
    private boolean sorted = true;
    private WmiModel selected = null;
    private HashMap confidences = new HashMap();

    protected WmiAbstractArrayCandidateModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    protected WmiAbstractArrayCandidateModel(WmiMathDocumentModel doc, WmiModel[] model) throws WmiInvalidModelInitializationException {
        super(doc, model);
        this.sorted = false;
    }

    @Override
    public void addChild(WmiModel model, float confidence) throws WmiNoWriteAccessException {
        this.setConfidence(model, confidence);
        super.appendChild(model);
        this.sorted = false;
    }

    @Override
    public void changeConfidence(WmiModel candidate, float newConfidence) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        this.verifyWriteLock();
        this.verifyModelInChildren(candidate);
        this.setConfidence(candidate, newConfidence);
        this.sorted = false;
    }

    @Override
    public WmiModel getBestCandidate() throws WmiNoReadAccessException {
        this.verifyReadLock();
        if (this.selected != null) {
            return this.selected;
        }
        this.verifyChildrenSorted();
        return this.getChild(0);
    }

    @Override
    public float getConfidence(WmiModel child) throws WmiNoReadAccessException, WmiModelNoSuchChildException {
        this.verifyModelInChildren(child);
        this.verifyReadLock();
        Object o = this.confidences.get(child);
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        return 0.0f;
    }

    @Override
    public WmiCandidateModel merge(WmiCandidateModel other) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCandidateModel newModel = null;
        try {
            newModel = (WmiCandidateModel)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("error: subclasses of WmiAbstractArrayCandidateModel must be Cloneable in order to merge");
        }
        try {
            int i = 0;
            while (i < other.getChildCount()) {
                WmiModel child = other.getChild(i);
                newModel.addChild(child, other.getConfidence(child));
                ++i;
            }
        }
        catch (WmiModelNoSuchChildException mnsce) {
            WmiErrorLog.log(mnsce);
        }
        return newModel;
    }

    @Override
    public void removeChildrenBelowConfidence(float minConfidenceToKeep) throws WmiNoWriteAccessException {
        try {
            this.verifyWriteLock();
            this.verifyChildrenSorted();
            int minimumRankToKeep = -1;
            int i = 0;
            while (i < this.getChildCount()) {
                float confidence = this.getConfidence(this.getChild(i));
                if (confidence < minConfidenceToKeep) {
                    minimumRankToKeep = i - 1;
                    break;
                }
                ++i;
            }
            this.removeChildrenBelowRank(minimumRankToKeep);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiModelNoSuchChildException mnsce) {
            WmiErrorLog.log(mnsce);
        }
    }

    @Override
    public void removeChildrenBelowRank(int minimumRankToKeep) throws WmiNoWriteAccessException {
        try {
            this.verifyWriteLock();
            this.verifyChildrenSorted();
            int childCount = this.getChildCount();
            if (minimumRankToKeep >= 0 && minimumRankToKeep < childCount) {
                this.replaceChildren(new WmiModel[0], minimumRankToKeep + 1, childCount - (minimumRankToKeep + 1));
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiModelIndexOutOfBoundsException mioobe) {
            WmiErrorLog.log(mioobe);
        }
    }

    @Override
    public void replaceChild(WmiModel model, float confidence, WmiModel toBeReplaced) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        try {
            this.verifyWriteLock();
            this.verifyModelInChildren(toBeReplaced);
            int index = this.indexOf(toBeReplaced);
            this.setConfidence(model, confidence);
            this.replaceChild(model, index);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiModelIndexOutOfBoundsException mioobe) {
            throw new WmiModelNoSuchChildException(this, toBeReplaced);
        }
    }

    @Override
    public void selectCandidate(WmiModel candidate) throws WmiNoWriteAccessException, WmiModelNoSuchChildException {
        this.verifyWriteLock();
        if (candidate != null) {
            this.verifyModelInChildren(candidate);
        }
        this.selected = candidate;
    }

    @Override
    public void selectCandidate(int index) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyWriteLock();
            this.selected = this.getChild(index);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void replaceChildren(WmiModel[] replacement, int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        block8: {
            this.sorted = false;
            try {
                boolean selectedIsInReplacement = false;
                if (replacement != null) {
                    int i = 0;
                    while (i < replacement.length) {
                        Object o;
                        if (replacement[i] != null && !((o = this.confidences.get(replacement[i])) instanceof Float)) {
                            this.setConfidence(replacement[i], 1.0f);
                        }
                        if (this.selected != null && replacement[i] == this.selected) {
                            selectedIsInReplacement = true;
                        }
                        ++i;
                    }
                }
                if (span <= 0 || this.selected == null || selectedIsInReplacement) break block8;
                this.verifyChildrenSorted();
                int upper = Math.min(first + span, this.getChildCount() - 1);
                int i = first;
                while (i < upper) {
                    if (this.getChild(i) == this.selected) {
                        this.selected = null;
                        break;
                    }
                    ++i;
                }
            }
            catch (WmiNoReadAccessException nrae) {
                WmiErrorLog.log(nrae);
            }
        }
        super.replaceChildren(replacement, first, span);
    }

    @Override
    public WmiModel getChild(int index) throws WmiNoReadAccessException {
        this.verifyChildrenSorted();
        return super.getChild(index);
    }

    @Override
    public void groupChildren(WmiCompositeModel groupModel, int offset, int numChildren) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        this.groupChildren(groupModel, 1.0f, offset, numChildren);
    }

    public void groupChildren(WmiCompositeModel groupModel, float groupModelConfidence, int offset, int numChildren) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        this.setConfidence(groupModel, groupModelConfidence);
        super.groupChildren(groupModel, offset, numChildren);
    }

    @Override
    public int indexOf(WmiModel child) throws WmiNoReadAccessException {
        this.verifyChildrenSorted();
        return super.indexOf(child);
    }

    @Override
    public void promoteChild(int offset) throws WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        super.promoteChild(offset);
    }

    @Override
    public void removeChild(int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        super.removeChild(position);
    }

    @Override
    public void removeChildren(int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        super.removeChildren(first, span);
    }

    @Override
    public void replaceChild(WmiModel model, int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        super.replaceChild(model, position);
    }

    @Override
    public void splitChild(int offset, int childOffset) throws WmiNoWriteAccessException {
        try {
            this.verifyChildrenSorted();
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        super.splitChild(offset, childOffset);
    }

    protected void verifyChildrenSorted() throws WmiNoReadAccessException {
        if (!this.sorted) {
            this.sortChildren();
        }
    }

    protected void sortChildren() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiModel[] kids = this.getChildren();
        Arrays.sort(kids, this.comparator);
        this.sorted = true;
    }

    protected void setConfidence(WmiModel model, float confidence) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.confidences.put(model, new Float(confidence));
    }

    protected void verifyModelInChildren(WmiModel model) throws WmiModelNoSuchChildException {
    }

    /*
     * Exception decompiling
     */
    public Object clone() throws CloneNotSupportedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        return null;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    private class CandidateComparator
    implements Comparator {
        private CandidateComparator() {
        }

        public int compare(Object a, Object b) {
            float fB;
            float fA;
            block9: {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null && b instanceof WmiModel) {
                    return 1;
                }
                if (b == null && a instanceof WmiModel) {
                    return -1;
                }
                if (!(a instanceof WmiModel) || !(b instanceof WmiModel)) {
                    throw new RuntimeException("trying to compare something that isn't a WmiModel:" + a + " and " + b);
                }
                fA = WmiAbstractArrayCandidateModel.this.getConfidence((WmiModel)a);
                fB = WmiAbstractArrayCandidateModel.this.getConfidence((WmiModel)b);
                if (fA != fB) break block9;
                return 0;
            }
            try {
                if (fA > fB) {
                    return -1;
                }
                return 1;
            }
            catch (WmiNoReadAccessException nrae) {
                throw new RuntimeException("caught a WmiNoReadAccessException during comparison");
            }
            catch (WmiModelNoSuchChildException mnsce) {
                throw new RuntimeException("caught a WmiModelNoSuchChildException during comparison");
            }
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CandidateComparator;
        }
    }
}

