/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import java.util.Arrays;

public abstract class WmiAbstractArrayCompositeModel
extends WmiAbstractModel
implements WmiCompositeModel {
    protected static final float DEFAULT_ARRAY_GROWTH_FACTOR = 1.5f;
    protected WmiModel[] children = null;
    protected int length = 0;

    protected WmiAbstractArrayCompositeModel() {
    }

    protected WmiAbstractArrayCompositeModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    protected WmiAbstractArrayCompositeModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc);
        this.children = children;
        this.length = children.length;
        try {
            int i = 0;
            while (i < this.length) {
                children[i].setParent(this);
                ++i;
            }
        }
        catch (WmiNoWriteAccessException e) {
            throw new WmiInvalidModelInitializationException(this);
        }
    }

    @Override
    public boolean hasChildren() throws WmiNoReadAccessException {
        return this.getChildCount() > 0;
    }

    @Override
    public int getChildCount() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.usePending() && this.pending instanceof WmiAbstractArrayCompositeModel ? ((WmiAbstractArrayCompositeModel)this.pending).length : this.length;
    }

    @Override
    public void addChild(WmiModel model, int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] add = new WmiModel[]{model};
        this.replaceChildren(add, position, 0);
    }

    @Override
    public void addChildren(WmiModel[] insertions, int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(insertions, position, 0);
    }

    @Override
    public void appendChild(WmiModel model) throws WmiNoWriteAccessException {
        WmiModel[] add = new WmiModel[]{model};
        try {
            int position = this.getChildCount();
            this.replaceChildren(add, position, 0);
        }
        catch (WmiNoReadAccessException readE) {
            readE.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException boundsE) {
            boundsE.printStackTrace();
        }
    }

    public void appendChildren(WmiModel[] models) throws WmiNoWriteAccessException {
        try {
            int position = this.getChildCount();
            this.replaceChildren(models, position, 0);
        }
        catch (WmiNoReadAccessException readE) {
            readE.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException boundsE) {
            boundsE.printStackTrace();
        }
    }

    @Override
    public void removeChild(WmiModel model) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int index = -1;
        try {
            index = this.indexOf(model);
        }
        catch (WmiNoReadAccessException e) {
            throw new WmiNoWriteAccessException(this);
        }
        if (index >= 0) {
            this.replaceChildren(null, index, 1);
        }
    }

    @Override
    public void removeChild(int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(null, position, 1);
    }

    @Override
    public void removeChildren(int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceChildren(null, first, span);
    }

    @Override
    public void replaceChild(WmiModel model, int position) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] add = new WmiModel[]{model};
        this.replaceChildren(add, position, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceChildren(WmiModel[] replacement, int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (!(this.pending instanceof WmiAbstractArrayCompositeModel)) throw new WmiNoWriteAccessException(this);
        WmiAbstractArrayCompositeModel model = (WmiAbstractArrayCompositeModel)this.pending;
        if (first < 0 || first > model.length) {
            throw new WmiModelIndexOutOfBoundsException(this, first);
        }
        if (span < 0) {
            throw new WmiModelIndexOutOfBoundsException(this, span);
        }
        int limit = model.length;
        if (first + span > limit) {
            throw new WmiModelIndexOutOfBoundsException(this, first + span);
        }
        int newLength = model.length - span;
        int shift = -span;
        if (replacement != null) {
            newLength += replacement.length;
            shift += replacement.length;
        }
        if (newLength < 0) throw new WmiModelIndexOutOfBoundsException(this, newLength);
        model.ensureCapacity(newLength, this);
        if (shift > 0) {
            System.arraycopy(model.children, first, model.children, first + shift, model.length - first);
        } else if (shift < 0) {
            System.arraycopy(model.children, first - shift, model.children, first, model.length - first + shift);
            Arrays.fill(model.children, model.length + shift, model.length, null);
        }
        if (replacement != null) {
            System.arraycopy(replacement, 0, model.children, first, replacement.length);
            if (this.isTree()) {
                int i = 0;
                while (i < replacement.length) {
                    if (replacement[i] != null) {
                        replacement[i].setParent(this);
                    }
                    ++i;
                }
            }
        }
        model.length = newLength;
    }

    public void replaceChildren(WmiModel[] replacement) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        try {
            this.replaceChildren(replacement, 0, this.getChildCount());
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void groupChildren(WmiCompositeModel groupModel, int offset, int numChildren) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (offset < 0 || offset > this.length) {
            throw new WmiModelIndexOutOfBoundsException(this, offset);
        }
        if (numChildren < 0 || numChildren + offset > this.length) {
            throw new WmiModelIndexOutOfBoundsException(this, numChildren);
        }
        if (numChildren > 0) {
            WmiModel[] kids = new WmiModel[numChildren];
            try {
                int k = offset;
                while (k < offset + numChildren) {
                    kids[k - offset] = this.getChild(k);
                    ++k;
                }
                groupModel.addChildren(kids, groupModel.getChildCount());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                // empty catch block
            }
        }
        WmiModel[] newModels = new WmiModel[]{groupModel};
        this.replaceChildren(newModels, offset, numChildren);
    }

    @Override
    public void splitChild(int offset, int childOffset) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
    }

    @Override
    public void splitModel(int index) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        int parentIndex;
        WmiCompositeModel myParent = this.getParent();
        if (myParent != null && (parentIndex = myParent.indexOf(this)) >= 0) {
            try {
                WmiAbstractArrayCompositeModel sibling = (WmiAbstractArrayCompositeModel)this.clone();
                sibling.children = null;
                sibling.length = 0;
                sibling.pending = sibling;
                sibling.attributes = this.getAttributes();
                int childCount = this.getChildCount();
                int size = childCount - index;
                if (size > 0) {
                    WmiModel[] copyChildren = new WmiModel[size];
                    int i = 0;
                    while (i < size) {
                        copyChildren[i] = this.getChild(index + i);
                        ++i;
                    }
                    this.removeChildren(index, size);
                    sibling.addChildren(copyChildren, 0);
                }
                myParent.addChild(sibling, parentIndex + 1);
            }
            catch (CloneNotSupportedException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    @Override
    public void promoteChild(int offset) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
    }

    @Override
    public int indexOf(WmiModel child) throws WmiNoReadAccessException {
        int index = -1;
        WmiModel[] array = this.getChildren();
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                if (array[i] == child) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    @Override
    public int indexOfInTraversalOrder(WmiModel child) throws WmiNoReadAccessException {
        return this.indexOf(child);
    }

    @Override
    public WmiModel getChild(int index) throws WmiNoReadAccessException {
        WmiModel child = null;
        WmiModel[] array = this.getChildren();
        if (array != null && index >= 0 && index < array.length) {
            child = array[index];
        }
        return child;
    }

    @Override
    public WmiModel getChildInTraversalOrder(int index) throws WmiNoReadAccessException {
        return this.getChild(index);
    }

    @Override
    public WmiModel getFirstChildWithTag(WmiModelTag tag) throws WmiNoReadAccessException {
        WmiModel[] array = this.getChildren();
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i].getTag() == tag) {
                    return array[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        if (this.pending instanceof WmiAbstractArrayCompositeModel) {
            WmiAbstractArrayCompositeModel model = (WmiAbstractArrayCompositeModel)this.pending;
            WmiUndoableCompositeModelEdit edit = null;
            if (undoName != null) {
                edit = (WmiUndoableCompositeModelEdit)this.createUndoableEdit();
                edit.setPreupdateProperties();
            }
            if (this.children != model.children) {
                if (model.children != null && model.children.length > model.length) {
                    this.children = new WmiModel[model.length];
                    System.arraycopy(model.children, 0, this.children, 0, model.length);
                } else {
                    this.children = model.children;
                }
            }
            this.length = model.length;
            if (this.pending.parent != this.parent) {
                this.parent = this.pending.parent;
            }
            if (this.pending.attributes != this.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.prepareForEditCommit();
            if (edit != null) {
                edit.setPostupdateProperties();
                WmiUndoManager undoManager = this.getDocument().getUndoManager();
                undoManager.addEdit(edit);
            }
            int i = 0;
            while (i < this.length) {
                WmiModel child = this.children[i];
                if (child != null) {
                    child.update(undoName);
                }
                ++i;
            }
        }
        this.pending = null;
    }

    public void prepareForEditCommit() throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
    }

    @Override
    public WmiUndoableEdit createUndoableEdit() {
        return new WmiUndoableCompositeModelEdit(this);
    }

    @Override
    public void release() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    this.children[i].release();
                    this.children[i] = null;
                }
                ++i;
            }
            this.children = null;
        }
        this.length = 0;
    }

    @Override
    public boolean isTree() {
        return true;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    protected WmiModel[] getChildren() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiModel[] array = this.usePending() && this.pending instanceof WmiAbstractArrayCompositeModel ? ((WmiAbstractArrayCompositeModel)this.pending).children : this.children;
        return array;
    }

    protected void ensureCapacity(int minSize, WmiAbstractArrayCompositeModel source) {
        if (this.children != null) {
            if (source != null && source.children == this.children) {
                WmiModel[] cloneArray = new WmiModel[this.children.length];
                System.arraycopy(this.children, 0, cloneArray, 0, this.children.length);
                this.children = cloneArray;
            }
            if (minSize > this.children.length) {
                int newSize = (int)((float)this.children.length * this.growthFactor()) + 1;
                if (newSize < minSize) {
                    newSize = minSize;
                }
                WmiModel[] newArray = new WmiModel[newSize];
                System.arraycopy(this.children, 0, newArray, 0, this.children.length);
                this.children = newArray;
            }
        } else {
            this.children = new WmiModel[minSize];
        }
    }

    protected float growthFactor() {
        return 1.5f;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        return null;
    }

    protected static class WmiUndoableCompositeModelEdit
    implements WmiUndoableEdit {
        protected WmiAbstractArrayCompositeModel model;
        protected WmiModel[] oldChildren = null;
        private WmiModel[] newChildren = null;
        private int oldLength = 0;
        private int newLength = 0;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;

        protected WmiUndoableCompositeModelEdit(WmiAbstractArrayCompositeModel model) {
            this.model = model;
        }

        protected void setPreupdateProperties() {
            this.oldChildren = this.model.children;
            this.oldLength = this.model.length;
            this.oldParent = this.model.parent;
            this.oldAttributes = this.model.attributes;
        }

        protected void setPostupdateProperties() {
            this.newChildren = this.model.children;
            this.newLength = this.model.length;
            this.newParent = this.model.parent;
            this.newAttributes = this.model.attributes;
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            if (this.model.pending != null) {
                WmiErrorLog.log(new Exception("undo on a model with a pending edit: model =  " + this.model));
            }
            this.applyPreupdateValues();
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        protected void applyPreupdateValues() throws WmiNoUpdateAccessException {
            this.model.length = this.oldLength;
            this.model.children = this.oldChildren;
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.pending = null;
        }

        protected void applyPostupdateValues() throws WmiNoUpdateAccessException {
            this.model.length = this.newLength;
            this.model.children = this.newChildren;
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.pending = null;
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            if (this.model.pending != null) {
                WmiErrorLog.log(new Exception("redo on a model with a pending edit: model =  " + this.model));
            }
            this.applyPostupdateValues();
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        public WmiAbstractArrayCompositeModel getModel() {
            return this.model;
        }

        public boolean containsAttributeEdit() {
            return this.oldAttributes != this.newAttributes;
        }
    }
}

