/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public abstract class WmiAbstractModel
implements WmiModel,
Cloneable {
    private static boolean enableDiagnostic = false;
    protected WmiCompositeModel parent = null;
    protected WmiAbstractModel pending = null;
    protected WmiMathDocumentModel document = null;
    protected WmiAttributeSet attributes = null;
    private WmiModelObserver observer;

    protected WmiAbstractModel() {
    }

    protected WmiAbstractModel(WmiMathDocumentModel doc) {
        this.document = doc;
        this.pending = this;
        this.attributes = this.createCompatibleAttributeSet();
    }

    public static void scanForPendingModel(WmiModel model) throws WmiNoReadAccessException {
        if (model instanceof WmiAbstractModel && ((WmiAbstractModel)model).pending != null) {
            WmiErrorLog.log(new Exception("found model with pending update: " + model));
        }
        if (model instanceof WmiCompositeModel) {
            WmiCompositeModel comp = (WmiCompositeModel)model;
            int size = comp.getChildCount();
            int i = 0;
            while (i < size) {
                WmiAbstractModel.scanForPendingModel(comp.getChild(i));
                ++i;
            }
        }
    }

    @Override
    public void addObserver(WmiModelObserver obs) {
        if (this.observer == null) {
            this.observer = obs;
            obs.setNextObserver(null);
        } else if (!this.containsObserver(obs)) {
            obs.setNextObserver(this.observer);
            this.observer = obs;
        }
    }

    public boolean containsObserver(WmiModelObserver obs) {
        boolean found = false;
        WmiModelObserver candidate = this.observer;
        while (candidate != null) {
            if (candidate == obs) {
                found = true;
                break;
            }
            candidate = candidate.getNextObserver();
        }
        return found;
    }

    @Override
    public void releaseObserver(WmiModelObserver obs) {
        if (this.observer == obs) {
            this.observer = obs.getNextObserver();
        } else {
            WmiModelObserver candidate = this.observer;
            while (candidate != null) {
                WmiModelObserver next = candidate.getNextObserver();
                if (next == obs) {
                    next = next.getNextObserver();
                    candidate.setNextObserver(next);
                    break;
                }
                candidate = candidate.getNextObserver();
            }
        }
    }

    @Override
    public WmiModelObserver getObserver() {
        return this.observer;
    }

    @Override
    public void addAttribute(Object key, Object value) throws WmiNoWriteAccessException {
        this.prepareForAttributeAddition();
        this.pending.attributes.addAttribute(key, value);
    }

    @Override
    public void addAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        this.prepareForAttributeAddition();
        this.pending.attributes.addAttributes(set);
    }

    protected void prepareForAttributeAddition() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending != null) {
            if (this.pending.attributes == null) {
                this.pending.attributes = this.createCompatibleAttributeSet();
            } else if (this.pending.attributes == this.attributes) {
                this.pending.attributes = this.attributes.copyAttributes();
            }
        } else {
            throw new WmiNoWriteAccessException(this);
        }
    }

    @Override
    public WmiAttributeSet getAttributes() throws WmiNoReadAccessException {
        this.verifyReadLock();
        boolean writeAccess = WmiModelLock.ownsWriteLock(this);
        WmiAttributeSet currentAttr = writeAccess && this.pending != null ? this.pending.attributes : this.attributes;
        WmiAttributeSet copyAttr = null;
        if (currentAttr == null && writeAccess) {
            try {
                this.createPendingModel();
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
            if (this.pending != null) {
                if (this.pending.attributes == null) {
                    this.pending.attributes = this.createCompatibleAttributeSet();
                }
                currentAttr = this.pending.attributes;
            }
        }
        if (currentAttr != null) {
            copyAttr = currentAttr.copyAttributes();
        }
        return copyAttr;
    }

    @Override
    public WmiAttributeSet getAttributesForRead() throws WmiNoReadAccessException {
        WmiAttributeSet readAttributes = this.attributes;
        this.verifyReadLock();
        if (this.usePending() && this.pending.attributes != null) {
            readAttributes = this.pending.attributes;
        }
        return readAttributes;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending != null) {
            this.pending.attributes = this.createCompatibleAttributeSet();
            this.pending.attributes.addAttributes(set);
        }
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        if (this.pending != null) {
            WmiAbstractModelEdit edit = null;
            if (undoName != null) {
                this.getDocument().getUndoManager();
                edit = (WmiAbstractModelEdit)this.createUndoableEdit();
                edit.setPreupdateProperties(this.parent, this.attributes);
            }
            if (this.parent != this.pending.parent) {
                this.parent = this.pending.parent;
            }
            if (this.attributes != this.pending.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.pending = null;
            if (edit != null) {
                edit.setPostupdateProperties(this.parent, this.attributes);
                WmiUndoManager undoManager = this.getDocument().getUndoManager();
                undoManager.addEdit(edit);
            }
        }
    }

    @Override
    public void revert() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.pending = null;
    }

    public WmiUndoableEdit createUndoableEdit() {
        return new WmiAbstractModelEdit(this);
    }

    @Override
    public void release() throws WmiNoWriteAccessException {
        this.parent = null;
        this.pending = null;
        this.document = null;
        this.attributes = null;
    }

    @Override
    public WmiCompositeModel getParent() throws WmiNoReadAccessException {
        this.verifyReadLock();
        WmiCompositeModel model = this.usePending() ? this.pending.parent : this.parent;
        return model;
    }

    @Override
    public void setParent(WmiCompositeModel model) throws WmiNoWriteAccessException {
        if (this.parent == null && this.pending == null) {
            this.parent = model;
        } else {
            this.verifyWriteLock();
            this.createPendingModel();
            if (this.pending == null) {
                throw new WmiNoWriteAccessException(this);
            }
            this.pending.parent = model;
        }
    }

    @Override
    public WmiMathDocumentModel getDocument() {
        return this.document;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return true;
    }

    @Override
    public boolean isSubselectable() {
        return this.isCrossBoundarySubselectable();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    protected final void verifyUpdateLock() throws WmiNoUpdateAccessException {
        if (enableDiagnostic && !WmiModelLock.hasLock(this, 2)) {
            throw new WmiNoUpdateAccessException(this);
        }
    }

    protected final void verifyWriteLock() throws WmiNoWriteAccessException {
        if (enableDiagnostic && this.pending != this && !WmiModelLock.ownsWriteLock(this)) {
            throw new WmiNoWriteAccessException(this);
        }
    }

    protected final void verifyReadLock() throws WmiNoReadAccessException {
        if (enableDiagnostic && this.pending != this) {
            boolean hasWriteLock = WmiModelLock.ownsWriteLock(this);
            boolean hasReadLock = false;
            if (!hasWriteLock) {
                hasReadLock = WmiModelLock.hasLock(this, 0);
            }
            if (!hasWriteLock && !hasReadLock) {
                throw new WmiNoReadAccessException(this);
            }
        }
    }

    protected final boolean usePending() {
        return this.pending != null && WmiModelLock.ownsWriteLock(this);
    }

    protected void createPendingModel() throws WmiNoWriteAccessException {
        if (this.pending == null) {
            boolean success = false;
            WmiMathDocumentModel doc = this.getDocument();
            if (doc != null) {
                doc.markDirty(this);
            }
            try {
                Object obj = this.clone();
                if (obj instanceof WmiAbstractModel) {
                    this.pending = (WmiAbstractModel)obj;
                    success = true;
                }
            }
            catch (CloneNotSupportedException e) {
                WmiErrorLog.log(e);
            }
            if (!success) {
                throw new WmiNoWriteAccessException(this);
            }
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiGenericAttributeSet();
    }

    public String toString() {
        WmiModelTag tag = this.getTag();
        return tag == null ? this.getClass().getName() : tag.toString();
    }

    @Override
    public boolean isDeletionBoundary() throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public int kerningPoints() throws WmiNoReadAccessException {
        return 0;
    }

    protected static class WmiAbstractModelEdit
    implements WmiUndoableEdit {
        private WmiAbstractModel model;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;

        protected WmiAbstractModelEdit(WmiAbstractModel model) {
            this.model = model;
        }

        protected void setPreupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes) {
            this.oldParent = parent;
            this.oldAttributes = attributes;
        }

        protected void setPostupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes) {
            this.newParent = parent;
            this.newAttributes = attributes;
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        public WmiModel getModel() {
            return this.model;
        }

        public boolean containsAttributeEdit() {
            return this.oldAttributes != this.newAttributes;
        }
    }
}

