/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;

public class WmiFontAttributeSet
extends WmiAbstractArrayAttributeSet
implements WmiStyleAttributeSet {
    public static final String ENCODING_SHIFT_JIS = "shift_JIS";
    public static final String ENCODING_ISO8859_1 = "ISO8859-1";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";
    public static final String UNDERLINE = "underline";
    public static final String SUPERSCRIPT = "superscript";
    public static final String SUBSCRIPT = "subscript";
    public static final String OPAQUE = "opaque";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String FAMILY = "family";
    public static final String SIZE = "size";
    public static final String EXECUTABLE = "executable";
    public static final String READ_ONLY = "readonly";
    public static final String COMPOSED = "composed";
    public static final String CONVERTED = "converted";
    public static final String IM_SELECTED = "imselected";
    public static final String PLACEHOLDER = "placeholder";
    public static final String SELECTION_PLACEHOLDER = "selection-placeholder";
    public static final String STYLE_NAME = "font_style_name";
    public static final String SET_PROPERTY = "true";
    public static final String RESET_PROPERTY = "false";
    public static final int PLAIN_STYLE = 0;
    public static final int BOLD_STYLE = 1;
    public static final int ITALIC_STYLE = 2;
    public static final int UNDERLINE_STYLE = 4;
    public static final int SUBSCRIPT_STYLE = 8;
    public static final int SUPERSCRIPT_STYLE = 16;
    public static final int OPAQUE_STYLE = 32;
    public static final int EXECUTABLE_STYLE = 64;
    public static final int READ_ONLY_STYLE = 128;
    public static final int COMPOSED_STYLE = 256;
    public static final int CONVERTED_STYLE = 512;
    public static final int IM_SELECTED_STYLE = 1024;
    public static final int PLACEHOLDER_STYLE = 2048;
    public static final int SELECTION_PLACEHOLDER_STYLE = 4096;
    protected static final String[] ATTRIBUTE_KEY_SET = new String[]{"family", "size", "bold", "italic", "underline", "subscript", "superscript", "opaque", "foreground", "background", "executable", "readonly", "composed", "converted", "imselected", "placeholder", "selection-placeholder", "font_style_name"};
    public static final String DEFAULT_FAMILY = WmiFontAttributeSet.getDefaultStyleFontFamily();
    public static final int DEFAULT_SIZE = 12;
    public static final int DEFAULT_STYLE = 0;
    public static final int DEFAULT_FOREGROUND = 0;
    public static final int DEFAULT_BACKGROUND = 0xFFFFFF;
    public static final WmiAttributeKey BOLD_KEY = new FontStyleBitKey("bold", 1);
    public static final WmiAttributeKey ITALIC_KEY = new FontStyleBitKey("italic", 2);
    public static final WmiAttributeKey UNDERLINE_KEY = new FontStyleBitKey("underline", 4);
    public static final WmiAttributeKey SUBSCRIPT_KEY = new FontStyleBitKey("subscript", 8);
    public static final WmiAttributeKey SUPERSCRIPT_KEY = new FontStyleBitKey("superscript", 16);
    public static final WmiAttributeKey OPAQUE_KEY = new FontStyleBitKey("opaque", 32);
    public static final WmiAttributeKey EXECUTABLE_KEY = new FontStyleBitKey("executable", 64);
    public static final WmiAttributeKey READ_ONLY_KEY = new FontStyleBitKey("readonly", 128);
    public static final WmiAttributeKey COMPOSED_KEY = new FontStyleBitKey("composed", 256);
    public static final WmiAttributeKey CONVERTED_KEY = new FontStyleBitKey("converted", 512);
    public static final WmiAttributeKey IM_SELECTED_KEY = new FontStyleBitKey("imselected", 1024);
    public static final WmiAttributeKey PLACEHOLDER_KEY = new FontStyleBitKey("placeholder", 2048);
    public static final WmiAttributeKey SELECTION_PLACEHOLDER_KEY = new FontStyleBitKey("selection-placeholder", 4096);
    public static final WmiAttributeKey FOREGROUND_KEY = new FontForegroundKey();
    public static final WmiAttributeKey BACKGROUND_KEY = new FontBackgroundKey();
    public static final WmiAttributeKey STYLE_KEY = new FontStyleKey();
    public static final WmiAttributeKey FAMILY_KEY = new FontFamilyKey();
    public static final WmiAttributeKey SIZE_KEY = new FontSizeKey();
    public static final WmiAttributeKey[] ATTRIBUTE_KEYS = new WmiAttributeKey[]{FAMILY_KEY, SIZE_KEY, BOLD_KEY, ITALIC_KEY, UNDERLINE_KEY, SUBSCRIPT_KEY, SUPERSCRIPT_KEY, FOREGROUND_KEY, BACKGROUND_KEY, OPAQUE_KEY, EXECUTABLE_KEY, READ_ONLY_KEY, COMPOSED_KEY, CONVERTED_KEY, IM_SELECTED_KEY, PLACEHOLDER_KEY, SELECTION_PLACEHOLDER_KEY, STYLE_KEY};
    public static final WmiFontAttributeSet DEFAULT_FONT_ATTRIBUTES = new WmiFontAttributeSet();
    private static HashMap keymap = null;
    private static HashMap cache = new HashMap();
    private String fontStyleName = null;
    private String family = DEFAULT_FAMILY;
    private int size = 12;
    private int foreground = 0;
    private int background = 0xFFFFFF;
    private int extendedStyle = 0;
    private String foregroundString = null;
    private String backgroundString = null;

    private static String getDefaultStyleFontFamily() {
        String family = "Times New Roman";
        Locale locale = RuntimeLocale.getEncodingLocale();
        if (RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE)) {
            family = WmiFontAttributeSet.getDefaultJapaneseSansSerifFont();
        }
        return family;
    }

    private static String getDefaultJapaneseSansSerifFont() {
        String fontName = null;
        fontName = RuntimePlatform.isMac() ? (RuntimePlatform.getMacOSVersion() <= 3 ? "Osaka" : "Hiragino Kaku Gothic Pro") : "MS Gothic";
        return fontName;
    }

    public WmiFontAttributeSet() {
    }

    public WmiFontAttributeSet(String styleName) {
        this.fontStyleName = styleName;
    }

    public WmiFontAttributeSet(WmiFontAttributeSet source) {
        this.copyFontAttributes(source);
    }

    public void copyFontAttributes(WmiFontAttributeSet source) {
        this.fontStyleName = source.getFontStyleName();
        this.family = source.getFamily();
        this.size = source.getSize();
        this.foreground = source.getForeground();
        this.foregroundString = null;
        this.background = source.getBackground();
        this.backgroundString = null;
        this.extendedStyle = source.getExtendedStyle();
    }

    @Override
    public void addAttributes(WmiAttributeSet set) {
        if (set instanceof WmiFontAttributeSet) {
            this.copyFontAttributes((WmiFontAttributeSet)set);
        } else {
            super.addAttributes(set);
        }
    }

    public int getExtendedStyle() {
        return this.extendedStyle;
    }

    public String getFontStyleName() {
        return this.fontStyleName;
    }

    @Override
    public String getStyleName() {
        return this.fontStyleName;
    }

    public void setFontStyleName(String style) {
        this.fontStyleName = style;
    }

    public boolean hasStyle(int style) {
        return (this.extendedStyle & style) != 0;
    }

    public void setStyle(int style, boolean state) {
        if (state && (style == 8 || style == 16)) {
            this.extendedStyle &= 0xFFFFFFE7;
        }
        this.extendedStyle = state ? (this.extendedStyle |= style) : (this.extendedStyle &= ~style);
    }

    public boolean isBold() {
        return this.hasStyle(1);
    }

    public boolean isExecutable() {
        return this.hasStyle(64);
    }

    public boolean isItalic() {
        return this.hasStyle(2);
    }

    public boolean isOpaque() {
        return this.hasStyle(32);
    }

    public boolean isReadOnly() {
        return this.hasStyle(128);
    }

    public boolean isSubscript() {
        return this.hasStyle(8);
    }

    public boolean isSuperscript() {
        return this.hasStyle(16);
    }

    public boolean isUnderlined() {
        return this.hasStyle(4);
    }

    public boolean isComposed() {
        return this.hasStyle(256);
    }

    public boolean isConverted() {
        return this.hasStyle(512);
    }

    public boolean isInputMethodSelected() {
        return this.hasStyle(1024);
    }

    public boolean isInputMethodText() {
        return this.hasStyle(1792);
    }

    public void setColor(int foreground, int background, boolean opaque) {
        this.setForeground(foreground);
        this.setBackground(background);
        this.setStyle(32, opaque);
    }

    public void setExtendedStyle(int styleID) {
        this.extendedStyle = styleID;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFont(String family, int size) {
        this.family = family;
        this.size = size;
    }

    public void setNamedFontStyle(String name, WmiMathDocumentModel doc) throws WmiNoReadAccessException {
        WmiFontAttributeSet defSet;
        this.setFontStyleName(name);
        if (name != null && doc != null && (defSet = doc.getFontStyle(name)) != null) {
            this.addAttributes(defSet);
        }
    }

    public int getBackground() {
        return this.background;
    }

    public String getBackgroundColorString() {
        if (this.backgroundString == null) {
            this.backgroundString = WmiColorAttributeKey.createRGBStringFromColorIndex(this.background);
        }
        return this.backgroundString;
    }

    public void setBackground(int color) {
        this.background = color;
        this.backgroundString = null;
    }

    public int getForeground() {
        return this.foreground;
    }

    public String getForegroundColorString() {
        if (this.foregroundString == null) {
            this.foregroundString = WmiColorAttributeKey.createRGBStringFromColorIndex(this.foreground);
        }
        return this.foregroundString;
    }

    public void setForeground(int color) {
        this.foreground = color;
        this.foregroundString = null;
    }

    public void debugPrint() {
    }

    public boolean isCompatibleEditAttributeSet(WmiFontAttributeSet other) {
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof WmiFontAttributeSet) {
            WmiFontAttributeSet attributes = (WmiFontAttributeSet)obj;
            if (this.size == attributes.size && this.foreground == attributes.foreground && this.background == attributes.background && this.extendedStyle == attributes.extendedStyle) {
                equals = true;
                if (this.fontStyleName != null) {
                    equals = this.fontStyleName.equals(attributes.fontStyleName);
                } else {
                    boolean bl = equals = attributes.fontStyleName == null;
                }
                if (equals && this.family != null) {
                    equals = this.family.equals(attributes.family);
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        int code = this.extendedStyle * 29;
        if (this.fontStyleName != null) {
            code ^= this.fontStyleName.hashCode();
        }
        if (this.family != null) {
            code ^= this.family.hashCode();
        }
        code ^= this.background * 3;
        code ^= this.foreground * 5;
        return code ^= this.size * 17;
    }

    @Override
    protected HashMap getKeyMap() {
        return keymap;
    }

    @Override
    public WmiAttributeKey[] getKeys() {
        return ATTRIBUTE_KEYS;
    }

    @Override
    protected void setKeyMap(HashMap map) {
        keymap = map;
    }

    @Override
    public HashMap getCache() {
        return cache;
    }

    public String exportAsMStyleTag() {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<mstyle ");
        tagBuffer.append("fontfamily = '" + this.family + "' ");
        tagBuffer.append("mathsize = '" + this.size + "' ");
        tagBuffer.append("mathcolor = '#" + WmiColorAttributeKey.createRGBHexStringFromColor(new Color(this.foreground)) + "' ");
        tagBuffer.append("mathbackground = '#" + WmiColorAttributeKey.createRGBHexStringFromColor(new Color(this.background)) + "' ");
        String variant = "";
        if (this.isBold()) {
            variant = this.isItalic() ? "bold-italic" : BOLD;
        } else if (this.isItalic()) {
            variant = ITALIC;
        }
        if (!variant.equals("")) {
            tagBuffer.append("mathvariant = '" + variant + "'");
        }
        tagBuffer.append(">");
        return tagBuffer.toString();
    }

    public static class FontBackgroundKey
    extends WmiColorAttributeKey {
        protected FontBackgroundKey() {
            super(WmiFontAttributeSet.BACKGROUND, 0xFFFFFF);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getBackgroundColorString();
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getBackground();
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int value) {
            ((WmiFontAttributeSet)set).setBackground(value);
        }
    }

    public static class FontFamilyKey
    extends WmiStringAttributeKey {
        protected FontFamilyKey() {
            super(WmiFontAttributeSet.FAMILY, DEFAULT_FAMILY);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getFamily();
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String value) {
            ((WmiFontAttributeSet)set).setFamily(value);
        }
    }

    public static class FontForegroundKey
    extends WmiColorAttributeKey {
        protected FontForegroundKey() {
            super(WmiFontAttributeSet.FOREGROUND, 0);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getForegroundColorString();
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getForeground();
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int value) {
            ((WmiFontAttributeSet)set).setForeground(value);
        }
    }

    public static class FontSizeKey
    extends WmiIntAttributeKey {
        public FontSizeKey() {
            super(WmiFontAttributeSet.SIZE, 12);
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getSize();
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int value) {
            ((WmiFontAttributeSet)set).setSize(value);
        }
    }

    public static class FontStyleBitKey
    extends WmiBooleanAttributeKey {
        private int styleBit;

        public FontStyleBitKey(String name, int styleBit) {
            super(name, false);
            this.styleBit = styleBit;
        }

        @Override
        public boolean getBooleanValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).hasStyle(this.styleBit);
        }

        @Override
        public void setBooleanValue(WmiAttributeSet set, boolean value) {
            ((WmiFontAttributeSet)set).setStyle(this.styleBit, value);
        }
    }

    public static class FontStyleKey
    extends WmiStringAttributeKey {
        protected FontStyleKey() {
            super(WmiFontAttributeSet.STYLE_NAME, null);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFontAttributeSet)set).getFontStyleName();
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String value) {
            ((WmiFontAttributeSet)set).setFontStyleName(value);
        }
    }
}

