/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractMappedAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class WmiLayoutAttributeSet
extends WmiAbstractMappedAttributeSet
implements WmiStyleAttributeSet {
    public static final String ALIGNMENT = "alignment";
    public static final String ALIGNMENT_LEFT = "left";
    public static final String ALIGNMENT_RIGHT = "right";
    public static final String ALIGNMENT_CENTRED = "centred";
    public static final String ALIGNMENT_JUSTIFY = "justify";
    public static final String LIST = "bullet";
    public static final String BULLETSUFFIX = "bulletsuffix";
    public static final String INITIAL_LIST_VALUE = "initial";
    public static final int INITIAL_LIST_MAX_VALUE = 254;
    public static final String LIST_NONE = "none";
    public static final String LIST_DOT = "dot";
    public static final String LIST_DASH = "dash";
    public static final String LIST_INDENT = "indent";
    public static final String LIST_NUMERIC = "numeric";
    public static final String LIST_ALPHABETIC = "alphabetic";
    public static final String LIST_UPPER_ALPHABETIC = "ALPHABETIC";
    public static final String LIST_ROMAN = "roman";
    public static final String LIST_UPPER_ROMAN = "ROMAN";
    public static final String FIRST_INDENT = "firstindent";
    public static final String LEFT_MARGIN = "leftmargin";
    public static final String RIGHT_MARGIN = "rightmargin";
    public static final String LINESPACING = "linespacing";
    public static final String SPACE_ABOVE = "spaceabove";
    public static final String SPACE_BELOW = "spacebelow";
    public static final String LINEBREAK = "linebreak";
    public static final String LINEBREAK_SPACE = "space";
    public static final String LINEBREAK_ANY = "any";
    public static final String LINEBREAK_NEWLINE = "newline";
    public static final String PAGEBREAK_BEFORE = "pagebreak-before";
    public static final String STYLE_NAME = "layout_style_name";
    public static final String SET_PROPERTY = "true";
    public static final String UNSET_PROPERTY = "false";
    public static final String BULLET_DOT_TEXT = "\u2022 ";
    public static final String BULLET_DASH_TEXT = "\u2013 ";
    public static final String BULLET_INDENT_TEXT = "  ";
    public static final String[] NUMBERED_LISTS = new String[]{"numeric", "alphabetic", "ALPHABETIC", "roman", "ROMAN"};
    private static final int JUSTIFY_STYLE = 3;
    private static final int LIST_STYLE = 60;
    private static final int LINEBREAK_STYLE = 192;
    private static final int LIST_INITIAL_VALUE_STYLE = 261120;
    private static final int LIST_INITIAL_VALUE_STYLE_FIRST_VALUE = 1024;
    private static final String[] ATTRIBUTE_KEY_SET = new String[]{"alignment", "bullet", "firstindent", "leftmargin", "rightmargin", "linespacing", "spaceabove", "spacebelow", "linebreak", "pagebreak-before", "initial", "bulletsuffix"};
    private static final String[] NAMED_ATTRIBUTE_KEY_SET = new String[]{"alignment", "bullet", "firstindent", "leftmargin", "rightmargin", "linespacing", "spaceabove", "spacebelow", "linebreak", "pagebreak-before", "layout_style_name", "initial", "bulletsuffix"};
    private static final String[] ALIGNMENT_SET = new String[]{"left", "right", "centred", "justify"};
    private static final String[] LIST_SET = new String[]{"none", "dot", "dash", "indent", "numeric", "alphabetic", "ALPHABETIC", "roman", "ROMAN"};
    private static final String[] LINEBREAK_SET = new String[]{"space", "any", "newline"};
    private static HashMap attributeMapper = null;
    private String styleName = null;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int firstIndent = 0;
    private float linespacing = 0.0f;
    private boolean pagebreakBefore = false;
    private int extendedStyle = 0;
    private String bulletSuffix = "";

    public WmiLayoutAttributeSet() {
        this(null);
    }

    public WmiLayoutAttributeSet(String styleName) {
        this.styleName = styleName;
    }

    public static void initAttributeMapper() {
        attributeMapper = new HashMap();
        attributeMapper.put(ALIGNMENT, new WmiLayoutBitAttributeMapper(ALIGNMENT_SET, 3));
        attributeMapper.put(LIST, new WmiLayoutBitAttributeMapper(LIST_SET, 60));
        attributeMapper.put(FIRST_INDENT, new WmiFirstIndentMapper());
        attributeMapper.put(LINESPACING, new WmiLinespacingMapper());
        attributeMapper.put(LEFT_MARGIN, new WmiLeftMarginMapper());
        attributeMapper.put(RIGHT_MARGIN, new WmiRightMarginMapper());
        attributeMapper.put(SPACE_ABOVE, new WmiTopMarginMapper());
        attributeMapper.put(SPACE_BELOW, new WmiBottomMarginMapper());
        attributeMapper.put(LINEBREAK, new WmiLayoutBitAttributeMapper(LINEBREAK_SET, 192));
        attributeMapper.put(PAGEBREAK_BEFORE, new WmiPagebreakMapper());
        attributeMapper.put(INITIAL_LIST_VALUE, new WmiInitialListValueMapper(261120, 1024));
        attributeMapper.put(BULLETSUFFIX, new WmiBulletSuffixMapper());
    }

    public String getBulletText(int itemNumber) {
        Object setting;
        String text = null;
        HashMap map = this.getAttributeMapperMap();
        WmiAbstractMappedAttributeSet.WmiAttributeMapper mapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)map.get(LIST);
        WmiBulletSuffixMapper bulletSuffixMapper = (WmiBulletSuffixMapper)attributeMapper.get(BULLETSUFFIX);
        String bulletSuffix = (String)bulletSuffixMapper.getAttribute(this);
        if (mapper != null && (setting = mapper.getAttribute(this)) != null) {
            if (setting.equals(LIST_DOT)) {
                text = BULLET_DOT_TEXT;
            } else if (setting.equals(LIST_DASH)) {
                text = BULLET_DASH_TEXT;
            } else if (setting.equals(LIST_INDENT)) {
                text = BULLET_INDENT_TEXT;
            } else if (setting.equals(LIST_NUMERIC)) {
                text = String.valueOf(Integer.toString(itemNumber)) + bulletSuffix + " ";
            } else if (setting.equals(LIST_ALPHABETIC)) {
                text = String.valueOf(WmiLayoutAttributeSet.getLetters(itemNumber)) + bulletSuffix + " ";
            } else if (setting.equals(LIST_UPPER_ALPHABETIC)) {
                text = String.valueOf(WmiLayoutAttributeSet.getLetters(itemNumber).toUpperCase()) + bulletSuffix + " ";
            } else if (setting.equals(LIST_ROMAN)) {
                text = String.valueOf(WmiLayoutAttributeSet.getRoman(itemNumber)) + bulletSuffix + " ";
            } else if (setting.equals(LIST_UPPER_ROMAN)) {
                text = String.valueOf(WmiLayoutAttributeSet.getRoman(itemNumber).toUpperCase()) + bulletSuffix + " ";
            }
        }
        return text;
    }

    private static String getLetters(int number) {
        StringBuffer buff = new StringBuffer();
        while (number > 0) {
            int digit = number % 26;
            if (digit == 0) {
                digit = 26;
            }
            buff.insert(0, (char)(97 + digit - 1));
            number -= digit;
            number /= 26;
        }
        return buff.toString();
    }

    private static String getRoman(int number) {
        StringBuffer buff = new StringBuffer();
        while (number >= 1000) {
            buff.append('m');
            number -= 1000;
        }
        if (number >= 900) {
            buff.append("cm");
            number -= 900;
        }
        if (number >= 500) {
            buff.append('d');
            number -= 500;
        }
        if (number >= 400) {
            buff.append("cd");
            number -= 400;
        }
        while (number >= 100) {
            buff.append('c');
            number -= 100;
        }
        if (number >= 90) {
            buff.append("xc");
            number -= 90;
        }
        if (number >= 50) {
            buff.append("l");
            number -= 50;
        }
        if (number >= 40) {
            buff.append("xl");
            number -= 40;
        }
        while (number >= 10) {
            buff.append('x');
            number -= 10;
        }
        if (number == 9) {
            buff.append("ix");
            number -= 9;
        }
        if (number >= 5) {
            buff.append('v');
            number -= 5;
        }
        if (number >= 4) {
            buff.append("iv");
            number -= 4;
        }
        while (number >= 1) {
            buff.append('i');
            --number;
        }
        return buff.toString();
    }

    public int getInitialListValue() {
        Object value;
        int answer = 0;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper mapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(INITIAL_LIST_VALUE);
        if (mapper != null && (value = mapper.getAttribute(this)) instanceof Integer) {
            answer = (Integer)value;
        }
        return answer;
    }

    public Object getListType() {
        Object type = null;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper mapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(LIST);
        if (mapper != null) {
            type = mapper.getAttribute(this);
        }
        return type;
    }

    public int getIndent() {
        return this.firstIndent;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    public void setIndent(int indent) {
        this.firstIndent = indent;
    }

    public void setMargins(int left, int right, int top, int bottom) {
        this.leftMargin = left;
        this.rightMargin = right;
        this.topMargin = top;
        this.bottomMargin = bottom;
    }

    public void setNamedLayoutStyle(String name, WmiMathDocumentModel doc) throws WmiNoReadAccessException {
        WmiLayoutAttributeSet defSet;
        this.setLayoutStyleName(name);
        if (name != null && doc != null && (defSet = doc.getLayoutStyle(name)) != null) {
            this.addAttributes(defSet);
        }
    }

    public void setLayoutStyleName(String name) {
        this.styleName = name;
    }

    @Override
    protected synchronized HashMap getAttributeMapperMap() {
        if (attributeMapper == null) {
            WmiLayoutAttributeSet.initAttributeMapper();
        }
        return attributeMapper;
    }

    @Override
    public void addAttribute(Object key, Object value) {
        if (key.equals(STYLE_NAME)) {
            this.setLayoutStyleName(value != null ? value.toString() : null);
        } else {
            super.addAttribute(key, value);
        }
    }

    @Override
    public WmiAttributeSet copyAttributes() {
        WmiLayoutAttributeSet copy = new WmiLayoutAttributeSet(this.getStyleName());
        copy.setIndent(this.getIndent());
        copy.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
        copy.extendedStyle = this.extendedStyle;
        copy.linespacing = this.linespacing;
        copy.pagebreakBefore = this.pagebreakBefore;
        copy.bulletSuffix = this.bulletSuffix;
        return copy;
    }

    @Override
    public Object getAttribute(Object key) {
        Object value = null;
        value = key.equals(STYLE_NAME) ? this.styleName : super.getAttribute(key);
        return value;
    }

    @Override
    public int getAttributeCount() {
        return this.styleName == null ? ATTRIBUTE_KEY_SET.length : NAMED_ATTRIBUTE_KEY_SET.length;
    }

    @Override
    public Enumeration getAttributeNames() {
        return new WmiLayoutAttributeEnumeration(this.styleName == null ? ATTRIBUTE_KEY_SET : NAMED_ATTRIBUTE_KEY_SET);
    }

    public boolean isNumberedList() {
        Object setting;
        boolean answer = false;
        WmiAbstractMappedAttributeSet.WmiAttributeMapper mapper = (WmiAbstractMappedAttributeSet.WmiAttributeMapper)attributeMapper.get(LIST);
        if (mapper != null && (setting = mapper.getAttribute(this)) != null) {
            int i = 0;
            while (i < NUMBERED_LISTS.length && !answer) {
                answer = setting.equals(NUMBERED_LISTS[i]);
                ++i;
            }
        }
        return answer;
    }

    static /* synthetic */ String[] access$18() {
        return ATTRIBUTE_KEY_SET;
    }

    protected static class WmiBottomMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiBottomMarginMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            ((WmiLayoutAttributeSet)set).bottomMargin = value;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).bottomMargin;
        }
    }

    protected static class WmiBulletSuffixMapper
    extends WmiAbstractMappedAttributeSet.WmiStringAttributeMapper {
        protected WmiBulletSuffixMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, String value) {
            ((WmiLayoutAttributeSet)set).bulletSuffix = value;
        }

        @Override
        public String fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).bulletSuffix;
        }
    }

    protected static class WmiFirstIndentMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiFirstIndentMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            ((WmiLayoutAttributeSet)set).firstIndent = value;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).firstIndent;
        }
    }

    protected static class WmiInitialListValueMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        int mask;
        int first;

        public WmiInitialListValueMapper(int bitMask, int firstValue) {
            this.mask = bitMask;
            this.first = firstValue;
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            if (value > 254) {
                value = 254;
            } else if (value < 0) {
                value = 255;
            }
            int style = ((WmiLayoutAttributeSet)set).extendedStyle;
            ((WmiLayoutAttributeSet)set).extendedStyle = style - (style & this.mask) | value * this.first;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            int value = (((WmiLayoutAttributeSet)set).extendedStyle & this.mask) / this.first;
            if (value > 254) {
                value = -1;
            }
            return value;
        }
    }

    public static class WmiLayoutAttributeEnumeration
    implements Enumeration {
        private int index = 0;
        private String[] keys = WmiLayoutAttributeSet.access$18();

        public WmiLayoutAttributeEnumeration(String[] keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasMoreElements() {
            return this.keys != null && this.index < this.keys.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.keys[this.index++];
        }
    }

    protected static class WmiLayoutBitAttributeMapper
    implements WmiAbstractMappedAttributeSet.WmiAttributeMapper {
        private Object[] values;
        private int groupBits;
        private int[] setBit;

        protected WmiLayoutBitAttributeMapper(Object[] values, int groupBits) {
            this.values = values;
            this.groupBits = groupBits;
            int temp = groupBits;
            int lowBit = 0;
            while ((temp & 1) == 0) {
                temp >>= 1;
                ++lowBit;
            }
            this.setBit = new int[values.length];
            int i = 0;
            while (i < values.length) {
                this.setBit[i] = i << lowBit;
                ++i;
            }
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            WmiLayoutAttributeSet layout = (WmiLayoutAttributeSet)set;
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    WmiLayoutAttributeSet wmiLayoutAttributeSet = layout;
                    wmiLayoutAttributeSet.extendedStyle = wmiLayoutAttributeSet.extendedStyle & ~this.groupBits;
                    WmiLayoutAttributeSet wmiLayoutAttributeSet2 = layout;
                    wmiLayoutAttributeSet2.extendedStyle = wmiLayoutAttributeSet2.extendedStyle | this.setBit[i];
                    break;
                }
                ++i;
            }
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            Object value = null;
            int targetValue = ((WmiLayoutAttributeSet)set).extendedStyle & this.groupBits;
            int i = 0;
            while (i < this.setBit.length) {
                if (targetValue == this.setBit[i]) {
                    value = this.values[i];
                    break;
                }
                ++i;
            }
            return value;
        }
    }

    protected static class WmiLeftMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiLeftMarginMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            ((WmiLayoutAttributeSet)set).leftMargin = value;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).leftMargin;
        }
    }

    protected static class WmiLinespacingMapper
    implements WmiAbstractMappedAttributeSet.WmiAttributeMapper {
        protected WmiLinespacingMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            float fValue = 0.0f;
            if (value instanceof Float) {
                fValue = ((Float)value).floatValue();
            } else if (value != null) {
                try {
                    fValue = Float.parseFloat(value.toString());
                }
                catch (NumberFormatException numE) {
                    WmiErrorLog.log(numE);
                }
            }
            ((WmiLayoutAttributeSet)set).linespacing = fValue;
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            float value = ((WmiLayoutAttributeSet)set).linespacing;
            return new Float(value);
        }
    }

    protected static class WmiPagebreakMapper
    extends WmiAbstractMappedAttributeSet.WmiStringBoolAttributeMapper {
        protected WmiPagebreakMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, String value) {
            ((WmiLayoutAttributeSet)set).pagebreakBefore = Boolean.valueOf(value);
        }

        @Override
        public String fetch(WmiAttributeSet set) {
            return String.valueOf(((WmiLayoutAttributeSet)set).pagebreakBefore);
        }
    }

    protected static class WmiRightMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiRightMarginMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            ((WmiLayoutAttributeSet)set).rightMargin = value;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).rightMargin;
        }
    }

    protected static class WmiTopMarginMapper
    extends WmiAbstractMappedAttributeSet.WmiIntAttributeMapper {
        protected WmiTopMarginMapper() {
        }

        @Override
        public void store(WmiAttributeSet set, int value) {
            ((WmiLayoutAttributeSet)set).topMargin = value;
        }

        @Override
        public int fetch(WmiAttributeSet set) {
            return ((WmiLayoutAttributeSet)set).topMargin;
        }
    }
}

