/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import java.util.HashSet;

public class WmiMathDocumentHierarchyValidator {
    private static final int DEFAULT_TABLE_SIZE = 150;
    private int tableSize;
    private boolean[][] dataTable;
    private boolean[] postDeleteMergePermission;
    private HashSet wrapperTypes = new HashSet();

    public WmiMathDocumentHierarchyValidator() {
        this.addLinks();
        this.addPostDeleteMergePermissions();
    }

    protected int getDefaultTableSize() {
        return 150;
    }

    protected void addLinks() {
        int numtags = this.getDefaultTableSize();
        this.dataTable = new boolean[numtags][];
        int i = 0;
        while (i < numtags) {
            this.dataTable[i] = new boolean[numtags];
            ++i;
        }
        this.tableSize = numtags;
        this.addLink(WmiModelTag.DOCUMENT, WmiModelTag.PARAGRAPH);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.TEXT);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.PLOT);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.MATH);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.METATAG_WRAPPER);
        this.addLink(WmiModelTag.METATAG_WRAPPER, WmiModelTag.TEXT);
        this.addMathLinks(WmiModelTag.MATH);
        this.addMathLinks(WmiModelTag.MATH_FRAC);
        this.addMathLinks(WmiModelTag.MATH_NROOT);
        this.addMathLinks(WmiModelTag.MATH_OVER);
        this.addMathLinks(WmiModelTag.MATH_ROW);
        this.addMathLinks(WmiModelTag.MATH_SQUARE_ROOT);
        this.addMathLinks(WmiModelTag.MATH_SUB_SUP);
        this.addMathLinks(WmiModelTag.MATH_SUBSCRIPT);
        this.addMathLinks(WmiModelTag.MATH_SUPERSCRIPT);
        this.addMathLinks(WmiModelTag.MATH_TABLE_CELL);
        this.addMathLinks(WmiModelTag.MATH_UNDER);
        this.addMathLinks(WmiModelTag.MATH_UNDER_OVER);
        this.addMathLinks(WmiModelTag.MATH_FENCED);
        this.addMathLinks(WmiModelTag.MATH_STYLE);
        this.addLink(WmiModelTag.MATH_TABLE, WmiModelTag.MATH_TABLE_ROW);
        this.addLink(WmiModelTag.MATH_TABLE_ROW, WmiModelTag.MATH_TABLE_CELL);
        this.addWrapperType(WmiModelTag.METATAG_WRAPPER);
    }

    protected void addPostDeleteMergePermissions() {
        int numtags = this.getDefaultTableSize();
        this.postDeleteMergePermission = new boolean[numtags];
        this.addPostDeletePermission(WmiModelTag.TEXT);
        this.addPostDeletePermission(WmiModelTag.PARAGRAPH);
    }

    protected void addPostDeletePermission(WmiModelTag tag) {
        this.postDeleteMergePermission[tag.getID()] = true;
    }

    public boolean hasPostDeletePermission(WmiModelTag tag) {
        return this.postDeleteMergePermission[tag.getID()];
    }

    protected void addMathLinks(WmiModelTag parent) {
        this.addLink(parent, WmiModelTag.MATH_ACTION);
        this.addLink(parent, WmiModelTag.MATH_FENCED);
        this.addLink(parent, WmiModelTag.MATH_FRAC);
        this.addLink(parent, WmiModelTag.MATH_IDENTIFIER);
        this.addLink(parent, WmiModelTag.MATH_NROOT);
        this.addLink(parent, WmiModelTag.MATH_NUMERIC);
        this.addLink(parent, WmiModelTag.MATH_OPERATOR);
        this.addLink(parent, WmiModelTag.MATH_OVER);
        this.addLink(parent, WmiModelTag.MATH_ROW);
        this.addLink(parent, WmiModelTag.MATH_SPACE);
        this.addLink(parent, WmiModelTag.MATH_SQUARE_ROOT);
        this.addLink(parent, WmiModelTag.MATH_STRING);
        this.addLink(parent, WmiModelTag.MATH_STYLE);
        this.addLink(parent, WmiModelTag.MATH_SUB_SUP);
        this.addLink(parent, WmiModelTag.MATH_SUBSCRIPT);
        this.addLink(parent, WmiModelTag.MATH_SUBSCRIPT);
        this.addLink(parent, WmiModelTag.MATH_SUPERSCRIPT);
        this.addLink(parent, WmiModelTag.MATH_TABLE);
        this.addLink(parent, WmiModelTag.MATH_TEXT);
        this.addLink(parent, WmiModelTag.MATH_UNDER);
        this.addLink(parent, WmiModelTag.MATH_UNDER_OVER);
    }

    protected void addLink(WmiModelTag parent, WmiModelTag child) {
        int parentID = parent.getID();
        int childID = child.getID();
        if (parentID < this.tableSize && childID < this.tableSize) {
            this.dataTable[parentID][childID] = true;
        }
    }

    protected void addWrapperType(WmiModelTag wrapperTag) {
        this.wrapperTypes.add(wrapperTag);
    }

    public boolean isValid(WmiModelTag parent, WmiModelTag child) {
        boolean valid = false;
        int parentID = parent.getID();
        int childID = child.getID();
        if (parentID < this.tableSize && childID < this.tableSize) {
            valid = this.dataTable[parentID][childID];
        }
        return valid;
    }

    public boolean isValid(WmiModel parent, WmiModel[] children) throws WmiNoReadAccessException {
        boolean valid = true;
        WmiModelTag parentTag = parent.getTag();
        int i = 0;
        while (i < children.length) {
            WmiModelTag childTag = children[i].getTag();
            if (this.wrapperTypes.contains(childTag)) {
                WmiCompositeModel compChild = (WmiCompositeModel)children[i];
                int j = 0;
                while (j < compChild.getChildCount()) {
                    if (!this.isValid(parentTag, compChild.getChild(j).getTag())) {
                        valid = false;
                        break;
                    }
                    ++j;
                }
            } else if (!this.isValid(parentTag, childTag)) {
                valid = false;
                break;
            }
            ++i;
        }
        return valid;
    }
}

