/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.controller.edit.WmiCustomDeleteHandler;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelListener;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelWriter;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class WmiMathDocumentModel
extends WmiAbstractArrayCompositeModel {
    public static final int UPDATE_NOTIFY = 0;
    public static final int UPDATE_NOTIFY_COMPLETE = 1;
    public static final int UPDATE_NOTIFY_BEGIN = 2;
    public static final int CREATE_EDIT_NOTIFY = 3;
    public static final int END_EDIT_NOTIFY = 4;
    public static final int RELEASE_EDIT_NOTIFY = 5;
    public static final int UNDO_NOTIFY = 6;
    public static final int REDO_NOTIFY = 7;
    public static final int POSITION_NOTIFY = 8;
    public static final int DEFAULT_ZOOM = 133;
    public static final int FONT_STYLE = 0;
    public static final int LAYOUT_STYLE = 1;
    public static final int DRAWING_STYLE = 2;
    public static final int STYLE_COUNT = 3;
    private static final WmiMathDocumentHierarchyValidator DEFAULT_HIERARCHY_VALIDATOR = new WmiMathDocumentHierarchyValidator();
    private WmiFontAttributeSet activeEditAttributes = new WmiActiveEditAtttributeSet();
    private boolean readOnly = false;
    private HashSet dirtyModels = new HashSet();
    private ArrayList listeners = new ArrayList();
    private HashMap[] styles = null;
    private WmiUndoManager undoManager = new WmiUndoManager(this);
    private WmiModelLock modelLock = null;
    private WmiInputLock inputLock = null;
    private boolean documentChangedSinceSave = false;
    private boolean documentChangedSinceAutosave = false;
    private WmiMetadataManager metadataManager = new WmiMetadataManager(this);
    private boolean processMath = true;
    private String lastExcelFile = null;

    public static void copyStyles(WmiMathDocumentModel source, WmiMathDocumentModel destination) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int families = source.getStyleFamilyCount();
        int f = 0;
        while (f < families) {
            Iterator it = source.getStyleNames(f);
            while (it.hasNext()) {
                destination.setStyle(f, source.getStyle(f, (String)it.next()));
            }
            ++f;
        }
    }

    public WmiMathDocumentModel() {
        this.modelLock = new WmiModelLock(this);
        this.inputLock = new WmiInputLock(this);
        int numStyleFamilies = this.getStyleFamilyCount();
        this.styles = new HashMap[numStyleFamilies];
        int i = 0;
        while (i < numStyleFamilies) {
            this.styles[i] = new HashMap();
            ++i;
        }
    }

    @Override
    public void release() throws WmiNoWriteAccessException {
        super.release();
        this.activeEditAttributes = null;
        if (this.dirtyModels != null) {
            this.dirtyModels.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.styles != null) {
            int i = 0;
            while (i < this.styles.length) {
                this.styles[i].clear();
                ++i;
            }
            this.styles = null;
        }
        this.undoManager = null;
        this.metadataManager = null;
        this.modelLock.disable();
        this.inputLock.disable();
    }

    public void debugPrintLight(WmiModelPathInterval selection) {
        if (WmiModelLock.readLock(this, true)) {
            try {
                try {
                    WmiModelWriter reporter = new WmiModelWriter(System.out);
                    reporter.setProcessStyleTable(false);
                    reporter.report(this, false, selection);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiModelLock.readUnlock(this);
                }
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
        }
    }

    public void debugPrintVerbose(WmiModelPathInterval selection) {
        if (WmiModelLock.readLock(this, true)) {
            try {
                try {
                    WmiModelWriter reporter = new WmiModelWriter(System.out);
                    reporter.setProcessStyleTable(false);
                    reporter.setMaximumAttributeLength(100);
                    reporter.report(this, true, selection);
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiModelLock.readUnlock(this);
                }
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
        }
    }

    protected int getStyleFamilyCount() {
        return 3;
    }

    public WmiFontAttributeSet getActiveEditAttributes() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.activeEditAttributes;
    }

    public WmiStyleAttributeSet getStyle(int styleFamily, String name) throws WmiNoReadAccessException {
        WmiAttributeSet spec;
        this.verifyReadLock();
        WmiStyleAttributeSet style = null;
        if (name != null && (spec = (WmiAttributeSet)this.styles[styleFamily].get(name)) != null) {
            style = (WmiStyleAttributeSet)spec.copyAttributes();
        }
        return style;
    }

    public Iterator getStyleNames(int styleFamily) throws WmiNoReadAccessException {
        this.verifyReadLock();
        return this.styles[styleFamily].keySet().iterator();
    }

    public WmiFontAttributeSet getFontStyle(String name) throws WmiNoReadAccessException {
        return (WmiFontAttributeSet)this.getStyle(0, name);
    }

    public Iterator getFontStyleNames() throws WmiNoReadAccessException {
        return this.getStyleNames(0);
    }

    public WmiLayoutAttributeSet getLayoutStyle(String name) throws WmiNoReadAccessException {
        return (WmiLayoutAttributeSet)this.getStyle(1, name);
    }

    public Iterator getLayoutStyleNames() throws WmiNoReadAccessException {
        return this.getStyleNames(1);
    }

    public int getZoomFactor() throws WmiNoReadAccessException {
        return 133;
    }

    public boolean isHidden(String key) throws WmiNoReadAccessException {
        return false;
    }

    public boolean isHidden(WmiModel model) throws WmiNoReadAccessException {
        return this.isHidden(model, true);
    }

    public boolean isHidden(WmiModel model, boolean checkLocal) throws WmiNoReadAccessException {
        return false;
    }

    public boolean isMutableModel(WmiModel model) throws WmiNoReadAccessException {
        boolean isMutable = true;
        if (model.getDocument() != this) {
            throw new IllegalArgumentException("Model not a child of this model.");
        }
        WmiAttributeSet attr = model.getAttributesForRead();
        if (attr != null) {
            boolean bl = isMutable = !"true".equals(attr.getAttribute("readonly"));
        }
        if (isMutable) {
            isMutable = !this.isReadOnly();
        }
        return isMutable;
    }

    public WmiCustomDeleteHandler getCustomDeleteHandler() {
        return null;
    }

    public boolean documentHasChangedSinceSave() {
        return this.documentChangedSinceSave;
    }

    public boolean documentHasChangedSinceAutosave() {
        return this.documentChangedSinceAutosave;
    }

    public void setDocumentChanged() {
        this.documentChangedSinceSave = true;
        this.documentChangedSinceAutosave = true;
    }

    public void documentSaved() {
        this.documentChangedSinceSave = false;
    }

    public void documentAutosaved() {
        this.documentChangedSinceAutosave = false;
    }

    public String getLastExcelFile() {
        return this.lastExcelFile;
    }

    public void setLastExcelFile(String lastExcelFile) {
        this.lastExcelFile = lastExcelFile;
    }

    public void resetStyleFamily(int family) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.styles[family].clear();
    }

    public void removeStyle(int family, Object name) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (name != null) {
            this.styles[family].remove(name);
        }
    }

    public void setStyle(int family, WmiStyleAttributeSet attrs) throws WmiNoWriteAccessException {
        String styleName;
        this.verifyWriteLock();
        if (attrs != null && (styleName = attrs.getStyleName()) != null) {
            this.styles[family].put(styleName, attrs);
        }
    }

    public void setFontStyle(WmiFontAttributeSet attrs) throws WmiNoWriteAccessException {
        this.setStyle(0, attrs);
    }

    public void setLayoutStyle(WmiLayoutAttributeSet attrs) throws WmiNoWriteAccessException {
        this.setStyle(1, attrs);
    }

    public WmiModelLock getLock() {
        return this.modelLock;
    }

    public WmiInputLock getInputLock() {
        return this.inputLock;
    }

    public WmiMathDocumentHierarchyValidator getModelHierarchyValidator() {
        return DEFAULT_HIERARCHY_VALIDATOR;
    }

    public void setProcessMathForDotm(boolean state) {
        this.processMath = state;
    }

    public boolean getProcessMathforDotm() {
        return this.processMath;
    }

    @Override
    public WmiMathDocumentModel getDocument() {
        return this;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.DOCUMENT;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    public boolean isDeletionBoundary() {
        return true;
    }

    public void markDirty(WmiModel model) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.dirtyModels.add(model);
    }

    public void markClean(WmiModel model) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.dirtyModels.remove(model);
    }

    public boolean isDirty() throws WmiNoReadAccessException {
        this.verifyReadLock();
        return !this.dirtyModels.isEmpty();
    }

    /*
     * Loose catch block
     */
    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        block24: {
            boolean rootUpdate = false;
            try {
                this.verifyWriteLock();
                boolean resetEdit = false;
                WmiCompositeUndoableEdit edit = null;
                if (this.undoManager != null) {
                    edit = this.undoManager.getActiveEdit();
                    if (undoName == null) {
                        if (edit != null) {
                            undoName = edit.getName();
                        }
                    } else if (edit == null) {
                        edit = this.undoManager.beginEdit(undoName);
                        resetEdit = true;
                    }
                }
                this.notifyModelListeners(this, 2);
                if (WmiModelLock.updateLock(this, true)) {
                    Object[] models = this.dirtyModels.toArray();
                    int size = models.length;
                    if (size > 0) {
                        this.setDocumentChanged();
                        if (edit == null) {
                            this.undoManager.flush();
                        }
                    }
                    int i = 0;
                    while (i < size) {
                        WmiModel model = (WmiModel)models[i];
                        if (model != this && model != null) {
                            model.update(undoName);
                            this.notifyModelListeners(model, 0);
                        } else {
                            rootUpdate = true;
                        }
                        ++i;
                    }
                    this.dirtyModels.clear();
                    if (rootUpdate) {
                        super.update(undoName);
                        this.notifyModelListeners(this, 0);
                    }
                    if (resetEdit) {
                        this.undoManager.endEdit();
                    }
                }
            }
            catch (WmiNoWriteAccessException wae) {
                WmiErrorLog.log(wae);
                WmiModelLock.updateUnlock(this);
                break block24;
            }
            catch (WmiNoReadAccessException rae) {
                WmiErrorLog.log(rae);
                break block24;
            }
            catch (NullPointerException npe) {
                WmiErrorLog.log(npe);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                WmiModelLock.updateUnlock(this);
                break block24;
            }
            {
                finally {
                    WmiModelLock.updateUnlock(this);
                }
            }
            WmiModelLock.updateUnlock(this);
        }
        try {
            this.notifyModelListeners(this, 1);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    public void revertPendingUpdates() throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        if (this.dirtyModels.size() > 0) {
            for (WmiModel model : this.dirtyModels) {
                model.revert();
            }
            this.dirtyModels.clear();
        }
    }

    public void addModelListener(WmiModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(WmiModelListener listener) {
        this.listeners.remove(listener);
    }

    public void positionUpdateNotification(WmiModel source, int offset, boolean showMarker) throws WmiNoReadAccessException {
        for (WmiModelListener listener : this.listeners) {
            listener.positionUpdateNotify(source, offset, showMarker);
        }
    }

    public void notifyModelListeners(Object source, int notificationType) throws WmiNoReadAccessException {
        for (WmiModelListener listener : this.listeners) {
            switch (notificationType) {
                case 0: {
                    listener.updateNotify((WmiModel)source);
                    break;
                }
                case 1: {
                    listener.updateCompleteNotify((WmiModel)source);
                    break;
                }
                case 2: {
                    listener.updateBeginNotify((WmiModel)source);
                    break;
                }
                case 3: {
                    listener.createEditNotify((WmiUndoableEdit)source);
                    break;
                }
                case 4: {
                    listener.endEditNotify((WmiUndoableEdit)source);
                    break;
                }
                case 5: {
                    listener.releaseEditNotify((WmiUndoableEdit)source);
                    break;
                }
                case 6: {
                    listener.undoNotify((WmiUndoableEdit)source);
                    break;
                }
                case 7: {
                    listener.redoNotify((WmiUndoableEdit)source);
                    break;
                }
                default: {
                    WmiErrorLog.log(new Exception("Invalid notification"));
                }
            }
        }
    }

    public WmiUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void startUndoableEdit(String name) {
        this.undoManager.beginEdit(name);
    }

    public void endUndoableEdit() {
        this.undoManager.endEdit();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isExecutable() {
        return !this.isReadOnly();
    }

    public void setExecutable(boolean executable) {
        throw new UnsupportedOperationException("Cannot set executability status for an instance of WmiMathDocumentModel.  Default implmentation of isExecutable returns !isReadOnly.  To set executable on WmiMathDocumentModel, call setReadOnly(!newIsExecutable).  If executable property and read-only property need to be divergent, you need to work with a subclass of WmiMathDocumentModel.");
    }

    public WmiMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public void refreshSemantics(WmiModel model) throws WmiNoReadAccessException {
        WmiModel editParentForSemantics = model;
        if (!(editParentForSemantics instanceof WmiMathModel) && editParentForSemantics.getParent() != null && editParentForSemantics.getParent() instanceof WmiMathModel) {
            editParentForSemantics = editParentForSemantics.getParent();
        }
        while (editParentForSemantics instanceof WmiMathModel) {
            ((WmiMathModel)editParentForSemantics).setSemantics(null);
            editParentForSemantics = editParentForSemantics.getParent();
        }
    }

    public class WmiActiveEditAtttributeSet
    extends WmiMathAttributeSet {
        @Override
        public HashMap getCache() {
            return null;
        }

        @Override
        public WmiAbstractArrayAttributeSet pack() {
            return this;
        }

        @Override
        public void addAttributes(WmiAttributeSet addSet) {
            super.addAttributes(addSet);
            this.setSemantics(null);
        }
    }
}

