/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericWrapperModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetadataContainer;
import com.maplesoft.mathdoc.model.WmiMetatagAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiSectionModelInterface;
import com.maplesoft.mathdoc.model.WmiTextContainingModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;

public class WmiMetatagWrapperModel
extends WmiGenericWrapperModel
implements WmiTextContainingModel {
    public static WmiMetatagWrapperModel createWrapper(WmiMathDocumentModel doc, WmiModelPath begin, WmiModelPath end, WmiMetadataContainer tag) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMetatagWrapperModel wrapper = new WmiMetatagWrapperModel(doc);
        wrapper.setMetatagId(tag.getId());
        return WmiMetatagWrapperModel.populateWrapper(doc, begin, end, tag, wrapper);
    }

    protected static WmiMetatagWrapperModel populateWrapper(WmiMathDocumentModel doc, WmiModelPath begin, WmiModelPath end, WmiMetadataContainer tag, WmiMetatagWrapperModel wrapper) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition endPos;
        WmiModel parentCandidate;
        WmiModelPosition beginPos = begin.getModelPosition(doc);
        WmiModel beginModel = beginPos.getModel();
        if (beginModel instanceof WmiSectionModelInterface && beginPos.getOffset() == 0) {
            WmiCompositeModel beginParent = beginModel.getParent();
            beginPos = new WmiModelPosition(beginParent, beginParent.indexOf(beginModel));
        }
        if ((parentCandidate = WmiModelUtil.commonParent(beginPos, endPos = end.getModelPosition(doc))) == beginPos.getModel() && parentCandidate == endPos.getModel()) {
            parentCandidate = parentCandidate.getParent();
        }
        WmiCompositeModel parentModel = parentCandidate instanceof WmiCompositeModel ? (WmiCompositeModel)parentCandidate : parentCandidate.getParent();
        int startIndex = parentModel.indexOf(beginPos.getModel());
        int endIndex = parentModel.indexOf(endPos.getModel());
        boolean isMathWrapper = false;
        if (startIndex < 0 || endIndex < 0) {
            if (beginPos.getModel() == endPos.getModel() && beginPos.getModel() instanceof WmiMathWrapperModel) {
                isMathWrapper = true;
                WmiCompositeModel grandparentModel = parentModel.getParent();
                if (grandparentModel != null) {
                    startIndex = grandparentModel.indexOf(parentModel);
                    wrapper.addChild(parentModel, wrapper.getChildCount());
                    grandparentModel.removeChild(startIndex);
                    parentModel = grandparentModel;
                }
            } else {
                beginModel = beginPos.getModel();
                WmiModel endModel = endPos.getModel();
                startIndex = parentModel == beginModel ? beginPos.getOffset() : WmiModelUtil.ancestorIndexOf(parentModel, beginModel);
                if (endModel == parentModel) {
                    endIndex = endPos.getOffset();
                } else {
                    int n = endIndex = endModel == parentModel && endIndex == -1 ? -1 : WmiModelUtil.ancestorIndexOf(parentModel, endModel);
                }
            }
        }
        if (!isMathWrapper) {
            if (endIndex == -1) {
                endIndex = parentModel.getChildCount() - 1;
            }
            int i = startIndex;
            while (i <= endIndex) {
                wrapper.addChild(parentModel.getChild(i), wrapper.getChildCount());
                ++i;
            }
            parentModel.removeChildren(startIndex, endIndex - startIndex + 1);
        }
        int i = 0;
        while (i < wrapper.getChildCount()) {
            WmiMetatagWrapperModel.dropChildMetatagWrappers(wrapper.getChild(i));
            ++i;
        }
        parentModel.addChild(wrapper, startIndex);
        return wrapper;
    }

    protected static void dropChildMetatagWrappers(WmiModel parent) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (parent instanceof WmiMetatagWrapperModel) {
            WmiMetatagWrapperModel.removeWrapper((WmiMetatagWrapperModel)parent);
        } else {
            WmiModel foundWrapper = WmiModelUtil.findFirstDescendantOfTag(parent, WmiModelTag.METATAG_WRAPPER);
            while (foundWrapper != null) {
                WmiMetatagWrapperModel.removeWrapper((WmiMetatagWrapperModel)foundWrapper);
                foundWrapper = WmiModelUtil.findFirstDescendantOfTag(parent, WmiModelTag.METATAG_WRAPPER);
            }
        }
    }

    public WmiMetatagWrapperModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    public void setMetatagId(String id) throws WmiNoWriteAccessException {
        this.addAttribute("tag_id", id);
    }

    public String getMetatagId() throws WmiNoReadAccessException {
        String id = "<invalid>";
        WmiAttributeSet attr = this.getAttributesForRead();
        if (attr != null) {
            id = attr.getAttribute("tag_id").toString();
        }
        return id;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.METATAG_WRAPPER;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMetatagAttributeSet();
    }

    @Override
    public void getAllText(StringBuffer buffer) throws WmiNoReadAccessException {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] instanceof WmiTextContainingModel) {
                ((WmiTextContainingModel)((Object)this.children[i])).getAllText(buffer);
            }
            ++i;
        }
    }

    @Override
    public String getAllText() throws WmiNoReadAccessException {
        StringBuffer buff = new StringBuffer();
        this.getAllText(buff);
        return buff.toString();
    }

    @Override
    public int getLength() throws WmiNoReadAccessException {
        int length = 0;
        int t = 0;
        while (t < this.getChildCount()) {
            WmiModel child = this.getChild(t);
            if (child instanceof WmiTextContainingModel) {
                length += ((WmiTextContainingModel)((Object)child)).getLength();
            }
            ++t;
        }
        return length;
    }

    @Override
    public WmiModelPosition getModelPosition(int offset, boolean before) throws WmiNoReadAccessException {
        int nKids = this.getChildCount();
        int charCount = 0;
        WmiModelPosition position = null;
        int k = 0;
        while (k < nKids) {
            WmiTextContainingModel textChild;
            int length;
            WmiModel child = this.getChild(k);
            if (child instanceof WmiTextContainingModel && (length = (textChild = (WmiTextContainingModel)((Object)child)).getLength()) > 0) {
                if (!before && charCount == offset) {
                    position = textChild.getModelPosition(0, before);
                    break;
                }
                if (before && charCount + length == offset) {
                    position = textChild.getModelPosition(length, before);
                    break;
                }
                if (offset - charCount < length) {
                    position = textChild.getModelPosition(offset - charCount, before);
                    break;
                }
                charCount += length;
            }
            ++k;
        }
        return position;
    }
}

