/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.util.WmiAncestorPath;

public class WmiModelPath
extends WmiAncestorPath
implements Comparable {
    public WmiModelPath() {
    }

    public WmiModelPath(WmiModelPath reference) {
        super(reference);
    }

    public WmiModelPath(WmiCompositeModel root, WmiModel reference) throws WmiNoReadAccessException {
        WmiCompositeModel parent = reference.getParent();
        while (parent != null && reference != root) {
            int index = parent.indexOf(reference);
            if (index >= 0) {
                this.push(index);
            }
            reference = parent;
            parent = reference.getParent();
        }
        int i = 0;
        int j = this.length - 1;
        int temp = -1;
        while (i < j) {
            temp = this.path[i];
            this.path[i] = this.path[j];
            this.path[j] = temp;
            ++i;
            --j;
        }
    }

    public WmiModelPath(WmiModel reference) throws WmiNoReadAccessException {
        this(null, reference);
    }

    public WmiModelPath(WmiModelPosition position) throws WmiNoReadAccessException {
        this(position.getModel());
        int offset = position.getOffset();
        this.push(offset);
    }

    public static WmiModelPath commonParent(WmiModelPath firstPath, WmiModelPath secondPath) {
        WmiModelPath parent = new WmiModelPath();
        if (firstPath != null && secondPath != null) {
            WmiModelPath first = (WmiModelPath)firstPath.clone();
            WmiModelPath second = (WmiModelPath)secondPath.clone();
            while (first.depth() > second.depth()) {
                first.pop();
            }
            while (second.depth() > first.depth()) {
                second.pop();
            }
            int idx = 0;
            while (idx < first.depth()) {
                if (first.peek(idx) != second.peek(idx)) break;
                parent.push(first.peek(idx));
                ++idx;
            }
        }
        return parent;
    }

    public WmiModelPosition getModelPosition(WmiCompositeModel root) throws WmiNoReadAccessException {
        WmiModel model = root;
        int offset = 0;
        int size = this.depth();
        int i = 0;
        while (i < size) {
            WmiModel candidate;
            int index = this.peek(i);
            if (index < 0) {
                offset = index;
                break;
            }
            if (model instanceof WmiCompositeModel) {
                candidate = model.getChild(index);
                if (candidate == null) {
                    offset = index;
                    break;
                }
            } else {
                offset = index;
                break;
            }
            model = candidate;
            ++i;
        }
        return new WmiModelPosition(model, offset);
    }

    public WmiModelPosition getModelPosition(WmiMathDocumentModel doc) throws WmiNoReadAccessException {
        return this.getModelPosition((WmiCompositeModel)doc);
    }

    public Object clone() {
        return new WmiModelPath(this);
    }
}

