/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiGenericCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.util.SearchAlgorithms;
import com.maplesoft.util.WmiSearchException;
import com.maplesoft.util.WmiSearchVisitor;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class WmiModelUtil {
    private static ModelUtilChildOperation defaultChildOp = new ModelUtilChildOperation();
    private static ModelUtilTraversalOrderedChildOperation traversalChildOp = new ModelUtilTraversalOrderedChildOperation();
    private static ModelUtilParentOperation parentOp = new ModelUtilParentOperation();
    private static WmiExportFormatter formatter = null;
    private static WmiImportParser parser = null;

    public static void copyStyleMap(WmiMathDocumentModel doc, int styleFamily, HashMap destination) throws WmiNoReadAccessException {
        Iterator names = doc.getStyleNames(styleFamily);
        while (names.hasNext()) {
            Object name = names.next();
            destination.put(name, doc.getStyle(styleFamily, name.toString()));
        }
    }

    public static WmiModelPath createPathToModel(WmiModelPosition position, WmiModelTag[] tags, boolean toStart) throws WmiNoReadAccessException {
        return new WmiModelPath(WmiModelUtil.expandModelPosition(position, tags, toStart));
    }

    public static WmiModelPosition expandModelPosition(WmiModelPosition position, WmiModelTag[] tags, boolean expandingStart) throws WmiNoReadAccessException {
        WmiModel model = position.getModel();
        WmiModelTag tag = model.getTag();
        WmiModel foundModel = null;
        int i = 0;
        while (i < tags.length && foundModel == null) {
            if (tag == tags[i]) {
                foundModel = model;
            }
            ++i;
        }
        if (foundModel == null) {
            foundModel = WmiModelUtil.findAncestorOfTag(model, tags);
        }
        if (foundModel != null) {
            position = new WmiModelPosition(foundModel, expandingStart ? 0 : -1);
        }
        return position;
    }

    public static int ancestorIndexOf(WmiCompositeModel ancestor, WmiModel model) throws WmiNoReadAccessException {
        if (ancestor == model) {
            return 0;
        }
        WmiModel child = model;
        WmiCompositeModel parent = child.getParent();
        while (parent != ancestor && parent != null) {
            child = child.getParent();
            parent = parent.getParent();
        }
        return parent.indexOf(child);
    }

    public static WmiModelPath mapBeginningOfCompositeModel(WmiCompositeModel model) throws WmiNoReadAccessException {
        WmiModelPath path = new WmiModelPath(model);
        WmiCompositeModel toCheck = model;
        while (toCheck != null && toCheck.getChildCount() > 0) {
            path.push(0);
            WmiModel child = toCheck.getChild(0);
            if (child instanceof WmiCompositeModel) {
                toCheck = (WmiCompositeModel)child;
                continue;
            }
            toCheck = null;
            path.push(0);
        }
        return path;
    }

    public static WmiModelPath mapEndOfCompositeModel(WmiCompositeModel model) throws WmiNoReadAccessException {
        WmiModelPath path = new WmiModelPath(model);
        WmiCompositeModel toCheck = model;
        while (toCheck != null && toCheck.getChildCount() > 0) {
            int end = toCheck.getChildCount() - 1;
            path.push(end);
            WmiModel child = toCheck.getChild(end);
            if (child instanceof WmiCompositeModel) {
                toCheck = (WmiCompositeModel)child;
                continue;
            }
            toCheck = null;
            path.push(-1);
        }
        return path;
    }

    public static int splitModel(WmiModel model, int pos) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        int fracturePosition = -1;
        WmiCompositeModel parent = model.getParent();
        int modelIndex = parent.indexOf(model);
        if (modelIndex >= 0) {
            if (model instanceof WmiTextModel) {
                WmiTextModel textModel = (WmiTextModel)model;
                if (pos > 0) {
                    ++modelIndex;
                    if (pos < textModel.getLength()) {
                        textModel.splitModel(pos);
                    }
                }
                fracturePosition = modelIndex;
            } else {
                if (pos > 0) {
                    ++modelIndex;
                    if (model instanceof WmiCompositeModel && pos < ((WmiCompositeModel)model).getChildCount()) {
                        ((WmiCompositeModel)model).splitModel(pos);
                    }
                }
                fracturePosition = modelIndex;
            }
        }
        return fracturePosition;
    }

    public static WmiModelTag getTagForString(String s) {
        WmiModelTag answer = null;
        int i = 0;
        while (i < WmiModelTag.ALL_MATHDOC_TAGS.length) {
            if (WmiModelTag.ALL_MATHDOC_TAGS[i].getName().equals(s)) {
                answer = WmiModelTag.ALL_MATHDOC_TAGS[i];
            }
            ++i;
        }
        return answer;
    }

    public static boolean isLeftmostPosition(WmiModelPosition modelPos) throws WmiNoReadAccessException {
        boolean isLeftmost = false;
        WmiModel model = null;
        int offset = -1;
        if (modelPos != null) {
            model = modelPos.getModel();
            offset = modelPos.getOffset();
        }
        if (model != null && offset == 0) {
            isLeftmost = true;
            if (model instanceof WmiMathModel) {
                WmiCompositeModel parent = model.getParent();
                while (parent instanceof WmiMathModel) {
                    if (parent.getChildInTraversalOrder(0) != model) {
                        isLeftmost = false;
                        break;
                    }
                    model = parent;
                    parent = parent.getParent();
                }
            }
        }
        return isLeftmost;
    }

    public static WmiCompositeModel findAncestorOfClass(WmiModel model, Class c) throws WmiNoReadAccessException {
        WmiCompositeModel p = model.getParent();
        while (p != null) {
            if (c.isInstance(p)) break;
            p = p.getParent();
        }
        return p;
    }

    public static WmiCompositeModel findAncestorOfTag(WmiModel model, WmiModelTag tag) throws WmiNoReadAccessException {
        WmiCompositeModel p = model != null ? model.getParent() : null;
        while (p != null) {
            if (p.getTag() == tag) break;
            p = p.getParent();
        }
        return p;
    }

    public static WmiCompositeModel findAncestorOfTag(WmiModel model, WmiModelTag[] tag) throws WmiNoReadAccessException {
        WmiCompositeModel foundModel = null;
        int i = 0;
        while (i < tag.length && foundModel == null) {
            foundModel = WmiModelUtil.findAncestorOfTag(model, tag[i]);
            ++i;
        }
        return foundModel;
    }

    public static WmiCompositeModel findAncestorOfTags(WmiModel model, WmiModelTag[] tag) throws WmiNoReadAccessException {
        WmiCompositeModel parent;
        WmiCompositeModel foundModel = null;
        if (model != null && (parent = model.getParent()) != null) {
            WmiModelTag parentTag = parent.getTag();
            int i = 0;
            while (i < tag.length && foundModel == null) {
                if (parentTag == tag[i]) {
                    foundModel = parent;
                }
                ++i;
            }
            if (foundModel == null) {
                foundModel = WmiModelUtil.findAncestorOfTags(parent, tag);
            }
        }
        return foundModel;
    }

    public static WmiModel findAncestorWithAttribute(WmiModel model, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(model, key, value);
        return WmiModelUtil.parentSearch(model, condition);
    }

    public static WmiModel findAncestorWithAttribute(WmiModel model, Object key) throws WmiNoReadAccessException {
        ModelUtilAttributeFind condition = new ModelUtilAttributeFind(model, key);
        return WmiModelUtil.parentSearch(model, condition);
    }

    public static boolean isModelAncestorOfModel(WmiModel first, WmiModel second) throws WmiNoReadAccessException {
        WmiCompositeModel searchResult = null;
        if (first != second) {
            searchResult = WmiModelUtil.parentSearch(second, new ModelUtilEqualityMatch(first));
        }
        return searchResult != null;
    }

    public static boolean isEmptyIdentifierModel(WmiModel model) throws WmiNoReadAccessException {
        int length;
        boolean emptyIdent = false;
        if (model instanceof WmiIdentifierModel && (length = ((WmiIdentifierModel)model).getLength()) == 0) {
            emptyIdent = true;
        }
        return emptyIdent;
    }

    public static WmiCompositeModel findParentParagraph(WmiModel model) throws WmiNoReadAccessException {
        WmiCompositeModel paragraph = null;
        WmiCompositeModel parent = model.getParent();
        while (parent != null) {
            if (parent instanceof WmiParagraphModel) {
                paragraph = parent;
                break;
            }
            parent = parent.getParent();
        }
        return paragraph;
    }

    public static WmiModel findFirstDescendantOfClass(WmiModel root, Class c) throws WmiNoReadAccessException {
        ModelUtilClassMatch condition = new ModelUtilClassMatch(root, c);
        return WmiModelUtil.depthFirstSearch(root, defaultChildOp, condition, 1);
    }

    public static WmiModel findFirstDescendantOfTag(WmiModel model, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(model, tag);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, 1);
    }

    public static WmiModel findFirstDescendantOfTag(WmiModel model, WmiModelTag[] tag) throws WmiNoReadAccessException {
        ModelUtilTagsMatch condition = new ModelUtilTagsMatch(model, tag);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, 1);
    }

    public static WmiModel findLastDescendantOfTag(WmiModel model, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(model, tag);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, -1);
    }

    public static WmiModel findFirstDescendantWithAttribute(WmiModel model, Object key) throws WmiNoReadAccessException {
        ModelUtilAttributeFind condition = new ModelUtilAttributeFind(model, key);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, 1);
    }

    public static WmiModel findFirstDescendantWithAttribute(WmiModel model, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(model, key, value);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, 1);
    }

    public static WmiModel findLastDescendantWithAttribute(WmiModel model, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(model, key, value);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, -1);
    }

    public static WmiModel findFirstDescendantLeaf(WmiCompositeModel model) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch condition = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, 1);
    }

    public static WmiModel findLastDescendantLeaf(WmiCompositeModel model) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch condition = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.depthFirstSearch(model, defaultChildOp, condition, -1);
    }

    public static WmiModel findNextDescendantLeaf(WmiCompositeModel root, WmiModel reference) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch condition = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findPreviousDescendantLeaf(WmiCompositeModel root, WmiModel reference) throws WmiNoReadAccessException {
        ModelUtilClassNotMatch condition = new ModelUtilClassNotMatch(WmiCompositeModel.class);
        return WmiModelUtil.searchFromReference(root, reference, condition, -1);
    }

    public static WmiModel findFirstTraversalOrderedDescendantOfTag(WmiModel model, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(model, tag);
        return WmiModelUtil.depthFirstSearch(model, traversalChildOp, condition, 1);
    }

    public static WmiModel findLastTraversalOrderedDescendantOfTag(WmiModel model, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(model, tag);
        return WmiModelUtil.depthFirstSearch(model, traversalChildOp, condition, -1);
    }

    public static WmiModel findFirstTraversalOrderedDescendantWithAttribute(WmiModel model, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(model, key, value);
        return WmiModelUtil.depthFirstSearch(model, traversalChildOp, condition, 1);
    }

    public static WmiModel findLastTraversalOrderedDescendantWithAttribute(WmiModel model, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(model, key, value);
        return WmiModelUtil.depthFirstSearch(model, traversalChildOp, condition, -1);
    }

    public static WmiModel findNextModel(WmiModel root, WmiModel reference, Class c) throws WmiNoReadAccessException {
        ModelUtilClassMatch condition = new ModelUtilClassMatch(reference, c);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findNextModel(WmiModel root, WmiModel reference, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(reference, tag);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findNextModel(WmiModel root, WmiModel reference, WmiModelTag[] tag) throws WmiNoReadAccessException {
        ModelUtilTagsMatch condition = new ModelUtilTagsMatch(reference, tag);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findNextModelWithAttribute(WmiModel root, WmiModel reference, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, key, value);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findNextModelWithAttribute(WmiModel root, WmiModel reference, Object key) throws WmiNoReadAccessException {
        ModelUtilAttributeFind condition = new ModelUtilAttributeFind(reference, key);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findNextModel(WmiModel root, WmiModel reference, Object attribute, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, attribute, value);
        return WmiModelUtil.searchFromReference(root, reference, condition, 1);
    }

    public static WmiModel findPreviousModel(WmiModel root, WmiModel reference, Class c) throws WmiNoReadAccessException {
        ModelUtilClassMatch condition = new ModelUtilClassMatch(reference, c);
        return WmiModelUtil.searchFromReference(root, reference, condition, -1);
    }

    public static WmiModel findPreviousModel(WmiModel root, WmiModel reference, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(reference, tag);
        return WmiModelUtil.searchFromReference(root, reference, condition, -1);
    }

    public static WmiModel findPreviousModel(WmiModel root, WmiModel reference, Object attribute, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, attribute, value);
        return WmiModelUtil.searchFromReference(root, reference, condition, -1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel root, WmiModel reference, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(reference, tag);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, 1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel root, WmiModel reference, WmiModelTag[] tag) throws WmiNoReadAccessException {
        ModelUtilTagsMatch condition = new ModelUtilTagsMatch(reference, tag);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, 1);
    }

    public static WmiModel findNextTraversalOrderedModel(WmiModel root, WmiModel reference, Object attribute, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, attribute, value);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, 1);
    }

    public static WmiModel findNextTraversalOrderedModelWithAttribute(WmiModel root, WmiModel reference, Object key, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, key, value);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, 1);
    }

    public static WmiModel findNextTraversalOrderedModelWithAttribute(WmiModel root, WmiModel reference, Object key) throws WmiNoReadAccessException {
        ModelUtilAttributeFind condition = new ModelUtilAttributeFind(reference, key);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, 1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel root, WmiModel reference, WmiModelTag tag) throws WmiNoReadAccessException {
        ModelUtilTagMatch condition = new ModelUtilTagMatch(reference, tag);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, -1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel root, WmiModel reference, WmiModelTag[] tag) throws WmiNoReadAccessException {
        ModelUtilTagsMatch condition = new ModelUtilTagsMatch(reference, tag);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, -1);
    }

    public static WmiModel findPreviousTraversalOrderedModel(WmiModel root, WmiModel reference, Object attribute, Object value) throws WmiNoReadAccessException {
        ModelUtilAttributeMatch condition = new ModelUtilAttributeMatch(reference, attribute, value);
        return WmiModelUtil.searchFromTraversalOrderedReference(root, reference, condition, -1);
    }

    public static void collectModels(WmiModel rootModel, WmiModelTag searchTag, Collection collection) throws WmiNoReadAccessException {
        WmiModelUtil.collectModels(rootModel, searchTag, collection, null);
    }

    public static void collectModels(WmiModel rootModel, WmiModelTag searchTag, Collection collection, WmiModelTag terminateTag) throws WmiNoReadAccessException {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        WmiModelUtil.visitModelsWithConditions(rootModel, new WmiModelCollector(collection), searchTag, terminateTag);
    }

    public static void collectModels(WmiModel rootModel, Class searchClass, Collection collection) throws WmiNoReadAccessException {
        WmiModelUtil.collectModels(rootModel, searchClass, collection, null);
    }

    public static void collectModels(WmiModel rootModel, Class searchClass, Collection collection, Class terminateClass) throws WmiNoReadAccessException {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        WmiModelUtil.visitModelsWithConditions(rootModel, new WmiModelCollector(collection), searchClass, terminateClass);
    }

    private static void visitModelsWithConditions(WmiModel rootModel, WmiSearchVisitor visitor, Object search, Object terminate) throws WmiNoReadAccessException {
        block8: {
            SearchAlgorithms.MatchCondition match = null;
            if (search instanceof WmiModelTag) {
                match = new ModelUtilTagMatch(rootModel, (WmiModelTag)search);
            } else if (search instanceof Class) {
                match = new ModelUtilClassMatch(rootModel, (Class)search);
            }
            SearchAlgorithms.MatchCondition stop = null;
            if (terminate instanceof WmiModelTag) {
                stop = new ModelUtilTagMatch(rootModel, (WmiModelTag)terminate);
            } else if (terminate instanceof Class) {
                stop = new ModelUtilClassMatch(rootModel, (Class)terminate);
            }
            try {
                SearchAlgorithms.depthFirstVisit(rootModel, defaultChildOp, match, stop, 1, visitor);
            }
            catch (WmiSearchException e) {
                Exception keep = e.getOriginatingException();
                if (!(keep instanceof WmiNoReadAccessException)) break block8;
                throw (WmiNoReadAccessException)keep;
            }
        }
    }

    public static void visitModels(WmiModel rootModel, WmiSearchVisitor visitor) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(rootModel, visitor, null, null);
    }

    public static void visitModels(WmiModel rootModel, WmiSearchVisitor visitor, WmiModelTag searchTag) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(rootModel, visitor, searchTag, null);
    }

    public static void visitModels(WmiModel rootModel, WmiSearchVisitor visitor, WmiModelTag searchTag, WmiModelTag terminateTag) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(rootModel, visitor, searchTag, terminateTag);
    }

    public static WmiModel commonParent(WmiModelPosition pos1, WmiModelPosition pos2) throws WmiNoReadAccessException {
        return WmiModelUtil.commonParent(pos1.getModel(), pos2.getModel());
    }

    public static WmiModel commonParent(WmiModel model1, WmiModel model2) throws WmiNoReadAccessException {
        WmiModel commonParent = null;
        Stack<WmiModel> stack1 = new Stack<WmiModel>();
        Stack<WmiModel> stack2 = new Stack<WmiModel>();
        WmiModel currentModel = model1;
        while (currentModel != null) {
            stack1.push(currentModel);
            currentModel = currentModel.getParent();
        }
        currentModel = model2;
        while (currentModel != null) {
            stack2.push(currentModel);
            currentModel = currentModel.getParent();
        }
        commonParent = (WmiModel)stack1.pop();
        stack2.pop();
        while (!stack1.isEmpty() && !stack2.isEmpty() && stack1.peek() == stack2.peek()) {
            commonParent = (WmiModel)stack1.pop();
            stack2.pop();
        }
        return commonParent;
    }

    public static void visitModels(WmiModel rootModel, WmiSearchVisitor visitor, Class searchClass, Class terminateClass) throws WmiNoReadAccessException {
        WmiModelUtil.visitModelsWithConditions(rootModel, visitor, searchClass, terminateClass);
    }

    public static WmiModel deepCopy(WmiModel model, WmiMathDocumentModel doc) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser == null || formatter == null) {
            throw new IllegalStateException("setDeepCopyIOHandlers must be called prior to invoking deepCopy.");
        }
        WmiGenericCompositeModel parent = new WmiGenericCompositeModel(doc, null);
        StringWriter writer = new StringWriter();
        try {
            formatter.format(writer, model);
        }
        catch (WmiFormatException fe) {
            WmiErrorLog.log(fe);
            return null;
        }
        StringReader reader = new StringReader(((Object)writer).toString());
        try {
            parser.parse(reader, (WmiCompositeModel)parent, 0);
        }
        catch (WmiParseException pe) {
            WmiErrorLog.log(pe);
            return null;
        }
        catch (WmiModelIndexOutOfBoundsException mioobe) {
            WmiErrorLog.log(mioobe);
            return null;
        }
        WmiModel result = parent.getChild(0);
        result.setParent(null);
        return result;
    }

    public static void setDeepCopyIOHandlers(WmiImportParser parser, WmiExportFormatter formatter) {
        WmiModelUtil.parser = parser;
        WmiModelUtil.formatter = formatter;
    }

    private static WmiModel depthFirstSearch(WmiModel model, SearchAlgorithms.ChildOperation childOp, SearchAlgorithms.MatchCondition condition, int dir) throws WmiNoReadAccessException {
        WmiModel descendant;
        block2: {
            descendant = null;
            try {
                descendant = (WmiModel)SearchAlgorithms.depthFirstSearch(model, childOp, condition, dir);
            }
            catch (WmiSearchException e) {
                Exception keep = e.getOriginatingException();
                if (!(keep instanceof WmiNoReadAccessException)) break block2;
                throw (WmiNoReadAccessException)keep;
            }
        }
        return descendant;
    }

    private static WmiCompositeModel parentSearch(WmiModel model, SearchAlgorithms.MatchCondition c) throws WmiNoReadAccessException {
        WmiCompositeModel parent;
        block2: {
            parent = null;
            try {
                parent = (WmiCompositeModel)SearchAlgorithms.parentSearch(model, parentOp, c);
            }
            catch (WmiSearchException e) {
                Exception keep = e.getOriginatingException();
                if (!(keep instanceof WmiNoReadAccessException)) break block2;
                throw (WmiNoReadAccessException)keep;
            }
        }
        return parent;
    }

    public static boolean shareAncestorOfTag(WmiModel one, WmiModel two, WmiModelTag tag) throws WmiNoReadAccessException {
        WmiCompositeModel parentTwo;
        WmiCompositeModel parentOne = WmiModelUtil.findAncestorOfTag(one, tag);
        return parentOne == (parentTwo = WmiModelUtil.findAncestorOfTag(two, tag));
    }

    private static WmiModel searchFromReference(WmiModel root, WmiModel reference, SearchAlgorithms.MatchCondition condition, int dir) throws WmiNoReadAccessException {
        WmiModel match = null;
        WmiCompositeModel parent = reference != null ? reference.getParent() : null;
        int index = parent != null ? parent.indexOf(reference) : -1;
        index += dir == 1 ? 1 : -1;
        if (parent != null) {
            if (index >= 0 && index < parent.getChildCount()) {
                WmiModel siblingModel = parent.getChild(index);
                match = condition.matchesCondition(siblingModel) ? siblingModel : WmiModelUtil.depthFirstSearch(siblingModel, defaultChildOp, condition, dir);
                if (match == null) {
                    match = WmiModelUtil.searchFromReference(root, siblingModel, condition, dir);
                }
            } else if (parent != null && parent != root) {
                match = WmiModelUtil.searchFromReference(root, parent, condition, dir);
            }
        }
        return match;
    }

    private static WmiModel searchFromTraversalOrderedReference(WmiModel root, WmiModel reference, SearchAlgorithms.MatchCondition condition, int dir) throws WmiNoReadAccessException {
        WmiModel match = null;
        WmiCompositeModel parent = reference.getParent();
        int index = parent != null ? parent.indexOfInTraversalOrder(reference) : -1;
        index += dir == 1 ? 1 : -1;
        if (parent != null) {
            if (index >= 0 && index < parent.getChildCount()) {
                WmiModel siblingModel = parent.getChildInTraversalOrder(index);
                match = condition.matchesCondition(siblingModel) ? siblingModel : WmiModelUtil.depthFirstSearch(siblingModel, traversalChildOp, condition, dir);
                if (match == null) {
                    match = WmiModelUtil.searchFromTraversalOrderedReference(root, siblingModel, condition, dir);
                }
            } else if (parent != null && parent != root) {
                match = WmiModelUtil.searchFromTraversalOrderedReference(root, parent, condition, dir);
            }
        }
        return match;
    }

    public static int getRemainingChildCount(WmiCompositeModel parent) throws WmiNoReadAccessException {
        int count = parent.getChildCount();
        int number = 0;
        int i = 0;
        while (i < count) {
            if (!(parent.getChild(i) instanceof WmiDeletePlaceholderModel)) {
                ++number;
            }
            ++i;
        }
        return number;
    }

    public static int getDeletedChildCount(WmiCompositeModel parent) throws WmiNoReadAccessException {
        int count = parent.getChildCount();
        int number = 0;
        int i = 0;
        while (i < count) {
            if (parent.getChild(i) instanceof WmiDeletePlaceholderModel) {
                ++number;
            }
            ++i;
        }
        return number;
    }

    public static int getFirstNonDeletePlaceHolderPosition(WmiCompositeModel parent) throws WmiNoReadAccessException {
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (!(parent.getChild(i) instanceof WmiDeletePlaceholderModel)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getFirstDeletePlaceHolderPosition(WmiCompositeModel parent) throws WmiNoReadAccessException {
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (parent.getChild(i) instanceof WmiDeletePlaceholderModel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private WmiModelUtil() {
    }

    public static WmiModel getPreviousSibling(WmiModel model) throws WmiNoReadAccessException {
        int index;
        int sibIndex;
        WmiCompositeModel parent = model.getParent();
        WmiModel sibling = null;
        if (parent != null && (sibIndex = (index = parent.indexOf(model)) - 1) > -1) {
            sibling = parent.getChild(sibIndex);
        }
        return sibling;
    }

    public static WmiModel getNextSibling(WmiModel model) throws WmiNoReadAccessException {
        int index;
        int sibIndex;
        WmiCompositeModel parent = model.getParent();
        WmiModel sibling = null;
        if (parent != null && (sibIndex = (index = parent.indexOf(model)) + 1) < parent.getChildCount()) {
            sibling = parent.getChild(sibIndex);
        }
        return sibling;
    }

    public static int getNumEmptyIdentifiers(WmiCompositeModel model) throws WmiNoReadAccessException {
        if (model == null) {
            return 0;
        }
        int count = 0;
        int size = model.getChildCount();
        int i = 0;
        while (i < size) {
            WmiModel child = model.getChild(i);
            if (WmiModelUtil.isEmptyIdentifierModel(child)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean isEmptyModel(WmiModel candidate) throws WmiNoReadAccessException {
        return WmiModelUtil.isEmptyModel(candidate, null);
    }

    public static boolean isEmptyModel(WmiModel candidate, WmiModel reference) throws WmiNoReadAccessException {
        WmiModelTag tag;
        boolean isEmpty = false;
        WmiModelTag wmiModelTag = tag = candidate != null ? candidate.getTag() : null;
        if (tag == WmiModelTag.MATH_NUMERIC || tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_OPERATOR) {
            if (candidate != reference) {
                isEmpty = ((WmiTextModel)candidate).getLength() == 0;
            }
        } else if (tag != WmiModelTag.MATH_SPACE && tag != WmiModelTag.MATH_SQUARE_ROOT && tag != WmiModelTag.MATH_NROOT && tag != WmiModelTag.MATH_FRAC && tag != WmiModelTag.MATH_FENCED && tag != WmiModelTag.MATH_TABLE_CELL) {
            if (tag == WmiModelTag.MATH_ROW && candidate.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && candidate.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune")) {
                isEmpty = false;
            } else if (candidate instanceof WmiCompositeModel) {
                WmiCompositeModel comp = (WmiCompositeModel)candidate;
                isEmpty = true;
                int size = comp.getChildCount();
                int i = 0;
                while (i < size) {
                    isEmpty = WmiModelUtil.isEmptyModel(comp.getChild(i), reference);
                    if (!isEmpty) break;
                    ++i;
                }
            }
        }
        return isEmpty;
    }

    private static class ModelUtilAttributeFind
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private Object attribute = null;

        private ModelUtilAttributeFind(WmiModel origin, Object attribute) {
            this.origin = origin;
            this.attribute = attribute;
        }

        @Override
        public boolean matchesCondition(Object o) {
            boolean match = false;
            if (o != this.origin) {
                WmiModel model = (WmiModel)o;
                try {
                    Object aValue;
                    WmiAttributeSet attribs = model.getAttributesForRead();
                    if (attribs != null && (aValue = attribs.getAttribute(this.attribute)) != null) {
                        match = true;
                    }
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                }
            }
            return match;
        }
    }

    private static class ModelUtilAttributeMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private Object attribute = null;
        private Object value = null;

        private ModelUtilAttributeMatch(WmiModel origin, Object attribute, Object value) {
            this.origin = origin;
            this.attribute = attribute;
            this.value = value;
        }

        @Override
        public boolean matchesCondition(Object o) {
            boolean match = false;
            if (o != this.origin) {
                WmiModel model = (WmiModel)o;
                try {
                    WmiAttributeSet attribs = model.getAttributesForRead();
                    Object aValue = attribs.getAttribute(this.attribute);
                    if (aValue != null && aValue.equals(this.value)) {
                        match = true;
                    }
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                }
            }
            return match;
        }
    }

    private static class ModelUtilChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ModelUtilChildOperation() {
        }

        @Override
        public Object getChild(Object o, int i) throws WmiSearchException {
            WmiCompositeModel model = (WmiCompositeModel)o;
            WmiModel result = null;
            try {
                result = model.getChild(i);
            }
            catch (WmiNoReadAccessException nrae) {
                throw new WmiSearchException(nrae);
            }
            return result;
        }

        @Override
        public int getChildCount(Object o) throws WmiSearchException {
            WmiCompositeModel model = (WmiCompositeModel)o;
            int result = 0;
            try {
                result = model.getChildCount();
            }
            catch (WmiNoReadAccessException nrae) {
                throw new WmiSearchException(nrae);
            }
            return result;
        }

        @Override
        public boolean hasChildren(Object o) {
            return o instanceof WmiCompositeModel;
        }

        /* synthetic */ ModelUtilChildOperation(ModelUtilChildOperation modelUtilChildOperation, ModelUtilChildOperation modelUtilChildOperation2) {
            this();
        }
    }

    private static class ModelUtilClassMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel model = null;
        private Class toMatch = null;

        private ModelUtilClassMatch(WmiModel model, Class toMatch) {
            this.model = model;
            this.toMatch = toMatch;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return (this.model == null || this.model != o) && this.toMatch.isInstance(o);
        }
    }

    private static class ModelUtilClassNotMatch
    implements SearchAlgorithms.MatchCondition {
        private Class toMatch = null;

        private ModelUtilClassNotMatch(Class toMatch) {
            this.toMatch = toMatch;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return !this.toMatch.isInstance(o);
        }
    }

    private static class ModelUtilEqualityMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel toMatch = null;

        private ModelUtilEqualityMatch(WmiModel toMatch) {
            this.toMatch = toMatch;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return o == this.toMatch;
        }
    }

    private static class ModelUtilParentOperation
    implements SearchAlgorithms.ParentOperation {
        private ModelUtilParentOperation() {
        }

        @Override
        public Object getParent(Object o) throws WmiSearchException {
            WmiModel model = (WmiModel)o;
            WmiCompositeModel result = null;
            try {
                result = model.getParent();
            }
            catch (WmiNoReadAccessException nrae) {
                throw new WmiSearchException(nrae);
            }
            return result;
        }
    }

    private static class ModelUtilTagMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private WmiModelTag tag = null;

        private ModelUtilTagMatch(WmiModel origin, WmiModelTag tag) {
            this.origin = origin;
            this.tag = tag;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return o instanceof WmiModel && o != this.origin && ((WmiModel)o).getTag() == this.tag;
        }
    }

    private static class ModelUtilTagsMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiModel origin = null;
        private WmiModelTag[] tags = null;

        private ModelUtilTagsMatch(WmiModel origin, WmiModelTag[] tag) {
            this.origin = origin;
            this.tags = tag;
        }

        @Override
        public boolean matchesCondition(Object o) {
            boolean result = false;
            int i = 0;
            while (i < this.tags.length) {
                if (result |= o != this.origin && ((WmiModel)o).getTag() == this.tags[i]) break;
                ++i;
            }
            return result;
        }
    }

    private static class ModelUtilTraversalOrderedChildOperation
    extends ModelUtilChildOperation {
        private ModelUtilTraversalOrderedChildOperation() {
            super(null, null);
        }

        @Override
        public Object getChild(Object o, int i) throws WmiSearchException {
            WmiCompositeModel model = (WmiCompositeModel)o;
            WmiModel result = null;
            try {
                result = model.getChildInTraversalOrder(i);
            }
            catch (WmiNoReadAccessException nrae) {
                throw new WmiSearchException(nrae);
            }
            return result;
        }
    }

    protected static class WmiModelCollector
    implements WmiSearchVisitor {
        private Collection collection;

        protected WmiModelCollector(Collection collection) {
            this.collection = collection;
        }

        @Override
        public int visitMatch(Object match) {
            int continueSearch = 2;
            try {
                this.collection.add(match);
                continueSearch = 0;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return continueSearch;
        }
    }
}

