/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiStringAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private String name;
    private String defaultValue;

    public WmiStringAttributeKey(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public WmiStringAttributeKey(String name, String defaultValue, int inheritanceIndex) {
        super(inheritanceIndex);
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean getBooleanValue(WmiAttributeSet set) {
        String value = this.getStringValue(set);
        return value != null ? value.compareToIgnoreCase("true") == 0 : false;
    }

    @Override
    public int getIntValue(WmiAttributeSet set) {
        String value = this.getStringValue(set);
        int iValue = 0;
        try {
            iValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            WmiErrorLog.log(nfe);
        }
        return iValue;
    }

    @Override
    public float getFloatValue(WmiAttributeSet set) {
        String value = this.getStringValue(set);
        float fValue = 0.0f;
        try {
            fValue = Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            WmiErrorLog.log(nfe);
        }
        return fValue;
    }

    @Override
    public abstract String getStringValue(WmiAttributeSet var1);

    @Override
    public Object getValue(WmiAttributeSet set) {
        return this.getStringValue(set);
    }

    @Override
    public void setBooleanValue(WmiAttributeSet set, boolean value) {
        this.setStringValue(set, value ? "true" : "false");
    }

    @Override
    public void setIntValue(WmiAttributeSet set, int value) {
        this.setStringValue(set, Integer.toString(value));
    }

    @Override
    public void setFloatValue(WmiAttributeSet set, float value) {
        this.setStringValue(set, Float.toString(value));
    }

    @Override
    public abstract void setStringValue(WmiAttributeSet var1, String var2);

    @Override
    public void setValue(WmiAttributeSet set, Object value) {
        if (value == null) {
            this.setStringValue(set, null);
        } else {
            this.setStringValue(set, value.toString());
        }
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public int getAttributeType() {
        return 3;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

