/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;

public class WmiTableCellAttributeSet
extends WmiGenericAttributeSet {
    public static final String ROWSPAN = "rowspan";
    public static final String COLUMNSPAN = "columnspan";
    public static final Integer DEFAULT_ROWSPAN = new Integer(1);
    public static final Integer DEFAULT_COLUMNSPAN = new Integer(1);

    public WmiTableCellAttributeSet() {
        this.addAttribute(ROWSPAN, DEFAULT_ROWSPAN);
        this.addAttribute(COLUMNSPAN, DEFAULT_COLUMNSPAN);
    }

    public int getRowSpan() {
        return this.getIntAttribute(ROWSPAN);
    }

    public void setRowSpan(int value) {
        this.addAttribute(ROWSPAN, new Integer(value));
    }

    public int getColumnSpan() {
        return this.getIntAttribute(COLUMNSPAN);
    }

    public int getIntAttribute(String key) {
        int value = 1;
        Object obj = this.getAttribute(key);
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj != null) {
            String strValue = obj.toString();
            try {
                value = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                WmiErrorLog.log(e);
            }
        }
        return value;
    }

    @Override
    public WmiAttributeSet copyAttributes() {
        WmiTableCellAttributeSet copy = new WmiTableCellAttributeSet();
        copy.addAttribute(ROWSPAN, this.getAttribute(ROWSPAN));
        copy.addAttribute(COLUMNSPAN, this.getAttribute(COLUMNSPAN));
        return copy;
    }
}

