/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTableModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiTableColumnModel
extends WmiAbstractModel {
    public static final String COLUMN_WEIGHT = "weight";
    public static final Integer DEFAULT_COLUMN_WEIGHT = new Integer(100);
    public static final String SEPARATOR = "separator";
    public static final Boolean DEFAULT_SEPARATOR = Boolean.TRUE;

    public WmiTableColumnModel(WmiMathDocumentModel docModel) {
        super(docModel);
        try {
            this.addAttribute(COLUMN_WEIGHT, DEFAULT_COLUMN_WEIGHT);
            this.addAttribute(SEPARATOR, DEFAULT_SEPARATOR);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.TABLE_COLUMN;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    public int getColumnWeight() throws WmiNoReadAccessException {
        int weight = DEFAULT_COLUMN_WEIGHT;
        WmiAttributeSet set = this.getAttributesForRead();
        Object value = set.getAttribute(COLUMN_WEIGHT);
        if (value instanceof Integer) {
            weight = (Integer)value;
        } else if (value != null) {
            String strvalue = value.toString();
            try {
                weight = Integer.parseInt(strvalue);
            }
            catch (NumberFormatException nfe) {
                weight = DEFAULT_COLUMN_WEIGHT;
            }
        }
        return weight;
    }

    @Override
    public void addAttribute(Object key, Object value) throws WmiNoWriteAccessException {
        try {
            WmiTableModel table = (WmiTableModel)WmiModelUtil.findAncestorOfTag((WmiModel)this, WmiModelTag.TABLE);
            if (table != null) {
                this.getDocument().markDirty(table);
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        super.addAttribute(key, value);
    }

    @Override
    public WmiUndoableEdit createUndoableEdit() {
        return new WmiTableColumnUndoableEdit(this);
    }

    protected static class WmiTableColumnUndoableEdit
    extends WmiAbstractModel.WmiAbstractModelEdit {
        protected WmiTableColumnUndoableEdit(WmiAbstractModel model) {
            super(model);
        }

        public void notifyTable() {
            WmiModel model = this.getModel();
            WmiMathDocumentModel docModel = model.getDocument();
            try {
                WmiCompositeModel table = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.TABLE);
                if (table != null && docModel != null) {
                    docModel.notifyModelListeners(table, 0);
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            super.undo();
            this.notifyTable();
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            super.redo();
            this.notifyTable();
        }
    }
}

