/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTableAttributeSet;
import com.maplesoft.mathdoc.model.WmiTableCellAttributeSet;
import com.maplesoft.mathdoc.model.WmiTableCellModel;
import com.maplesoft.mathdoc.model.WmiTableColumnModel;
import com.maplesoft.mathdoc.model.WmiTableRowModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class WmiTableModel
extends WmiAbstractArrayCompositeModel {
    public WmiTableModel(WmiMathDocumentModel docModel) {
        super(docModel);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.TABLE;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiTableAttributeSet();
    }

    public int getAdjustedWidth(int zoom, int breakWidth) throws WmiNoReadAccessException {
        int width = 0;
        WmiAttributeSet currentAttr = this.getAttributesForRead();
        if (currentAttr != null) {
            Object value = currentAttr.getAttribute("width");
            if (value instanceof Integer) {
                width = (Integer)value * zoom / 100;
            } else if (value != null) {
                String strValue = value.toString();
                int offset = strValue.indexOf("%");
                try {
                    float base;
                    float f = base = offset < 0 ? Float.parseFloat(strValue) : Float.parseFloat(strValue.substring(0, offset));
                    width = strValue.endsWith("%") ? (int)((double)(base * (float)breakWidth) / 100.0) : (int)((double)(base * (float)zoom) / 100.0);
                }
                catch (NumberFormatException nfe) {
                    WmiErrorLog.log(nfe);
                    width = breakWidth;
                }
            }
        }
        return width;
    }

    @Override
    public WmiUndoableEdit createUndoableEdit() {
        return new WmiTableUndoableEdit(this);
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        block6: {
            this.verifyUpdateLock();
            try {
                String strValue;
                int offset;
                Object value;
                WmiTableAttributeSet attrForRead;
                if (this.getParent() == null || this.getParent().getTag() != WmiModelTag.TABLE_CELL || (attrForRead = (WmiTableAttributeSet)this.getAttributesForRead()) == null || (value = attrForRead.getAttribute("width")) == null || value instanceof Integer || (offset = (strValue = value.toString()).indexOf("%")) <= -1) break block6;
                try {
                    float base = Float.parseFloat(strValue.substring(0, offset));
                    if ((double)base > 100.0) {
                        WmiTableAttributeSet attrForWrite = (WmiTableAttributeSet)this.getAttributes();
                        attrForWrite.addAttribute("width", "100%");
                        this.setAttributes(attrForWrite);
                    }
                }
                catch (NumberFormatException e) {
                    WmiErrorLog.log(e);
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        super.update(undoName);
    }

    public WmiTransferModel createTransferModel(WmiTableCellModel first, WmiTableCellModel last) throws WmiNoReadAccessException {
        WmiTableCellIterator it = new WmiTableCellIterator(this);
        int startRow = -1;
        int startColumn = -1;
        int endRow = -1;
        int endColumn = -1;
        while (it.hasNext()) {
            WmiTableCellIteratorNode node = (WmiTableCellIteratorNode)it.next();
            WmiTableCellModel cell = node.getCell();
            if (cell == first) {
                startRow = node.getRowIndex();
                startColumn = node.getColumnIndex();
            }
            if (cell != last) continue;
            endRow = node.getRowIndex();
            endColumn = node.getColumnIndex();
        }
        return this.createTransferModel(startRow, endRow, startColumn, endColumn);
    }

    public WmiTransferModel createTransferModel(int startRow, int endRow, int startColumn, int endColumn) throws WmiNoReadAccessException {
        boolean success = true;
        WmiTransferModel subTable = null;
        WmiTableCellIterator it = new WmiTableCellIterator(this);
        WmiTableCellIteratorNode node = (WmiTableCellIteratorNode)it.next();
        if (startRow >= 0 && endRow >= 0 && startColumn >= 0 && endColumn >= 0) {
            subTable = new WmiTransferModel(this, 0, this.getChildCount() - 1);
            int column = 0;
            int row = 0;
            int tableIndex = 0;
            while (tableIndex < subTable.getChildCount() && success) {
                WmiModel child = subTable.getChild(tableIndex);
                if (child instanceof WmiTableColumnModel) {
                    if (column < startColumn || column > endColumn) {
                        subTable.trim(tableIndex);
                    } else {
                        ++tableIndex;
                    }
                    ++column;
                    continue;
                }
                if (child instanceof WmiTableRowModel) {
                    if (row < startRow || row > endRow) {
                        subTable.trim(tableIndex);
                        while (node != null && node.getRowIndex() == row) {
                            WmiTableCellIteratorNode wmiTableCellIteratorNode = node = it.hasNext() ? (WmiTableCellIteratorNode)it.next() : null;
                        }
                    } else {
                        WmiTransferModel rowTransfer = subTable.convertToTransferModel(tableIndex);
                        ++tableIndex;
                        int rowIndex = 0;
                        while (node != null && node.getRowIndex() == row) {
                            if (node.getCell() != rowTransfer.getChild(rowIndex)) {
                                WmiErrorLog.log(new Exception("Synchronization error creating subtable"));
                                success = false;
                                break;
                            }
                            int columnIndex = node.getColumnIndex();
                            if (columnIndex < startColumn || columnIndex > endColumn) {
                                rowTransfer.trim(rowIndex);
                            } else {
                                ++rowIndex;
                            }
                            WmiTableCellIteratorNode wmiTableCellIteratorNode = node = it.hasNext() ? (WmiTableCellIteratorNode)it.next() : null;
                        }
                    }
                    ++row;
                    continue;
                }
                WmiErrorLog.log(new Exception("Unexpected model " + child));
                ++tableIndex;
            }
        }
        return success ? subTable : null;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public int computeRowCount() throws WmiNoReadAccessException {
        int rows = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiModel child = this.getChild(i);
            if (child.getTag() == WmiModelTag.TABLE_ROW) {
                ++rows;
            }
            ++i;
        }
        return rows;
    }

    public int computeColumnCount() throws WmiNoReadAccessException {
        int columns = 0;
        int size = this.getChildCount();
        int i = 0;
        while (i < size) {
            WmiModel child = this.getChild(i);
            if (child.getTag() == WmiModelTag.TABLE_COLUMN) {
                ++columns;
            }
            ++i;
        }
        return columns;
    }

    public boolean useColumnwiseTraversal() throws WmiNoReadAccessException {
        boolean columnwise = false;
        WmiAttributeSet attribs = this.getAttributesForRead();
        Object value = attribs.getAttribute("order");
        columnwise = value != null && value.equals(WmiTableAttributeSet.ORDER_OPTIONS[1]);
        return columnwise;
    }

    public void randomizeRowOrder(boolean random) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet attrs = this.getAttributes();
        if (random) {
            attrs.addAttribute("randomized", "true");
            int rowCount = this.computeRowCount();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int i = 0;
            while (i < rowCount) {
                indexes.add(new Integer(i));
                ++i;
            }
            Collections.shuffle(indexes);
            attrs.addAttribute("randomizedroworder", indexes);
        } else {
            attrs.addAttribute("randomized", "false");
            attrs.addAttribute("randomizedroworder", null);
        }
        this.setAttributes(attrs);
    }

    public WmiTableCellModel createTableCellModel(WmiMathDocumentModel docModel) {
        return new WmiTableCellModel(docModel);
    }

    public void attachPlotsToLinker() throws WmiNoReadAccessException {
    }

    public static class WmiTableCellIterator
    implements Iterator {
        private int iteratorPos;
        private ArrayList list;

        /*
         * Unable to fully structure code
         */
        public WmiTableCellIterator(WmiAbstractArrayCompositeModel table) throws WmiNoReadAccessException {
            block11: {
                super();
                this.iteratorPos = 0;
                this.list = new ArrayList<E>();
                if (table.getTag() != WmiModelTag.TABLE) break block11;
                size = table.getChildCount();
                columns = 0;
                i = 0;
                while (i < size) {
                    child = table.getChild(i);
                    if (child.getTag() == WmiModelTag.TABLE_COLUMN) {
                        ++columns;
                    }
                    ++i;
                }
                rowspan = new int[columns];
                columnspan = new int[columns];
                r = 0;
                i = 0;
                while (i < size) {
                    block12: {
                        child = table.getChild(i);
                        if (child.getTag() != WmiModelTag.TABLE_ROW || !(child instanceof WmiAbstractArrayCompositeModel)) break block12;
                        row = (WmiAbstractArrayCompositeModel)child;
                        rowSize = row.getChildCount();
                        if (rowSize == 0) {
                            c = 0;
                            while (c < columns && rowspan[c] != 0) {
                                c += columnspan[c];
                            }
                        }
                        c = 0;
                        j = 0;
                        ** GOTO lbl45
                        {
                            c += columnspan[c];
                            do {
                                if (c < columns && rowspan[c] != 0) continue block3;
                                if (c >= columns) break block3;
                                cell = (WmiTableCellModel)row.getChild(j);
                                set = cell.getAttributesForRead();
                                if (set instanceof WmiTableCellAttributeSet) {
                                    attributes = (WmiTableCellAttributeSet)cell.getAttributesForRead();
                                    rowspan[c] = attributes.getRowSpan();
                                    columnspan[c] = attributes.getColumnSpan();
                                }
                                this.list.add(new WmiTableCellIteratorNode(r, c, cell));
                                c += columnspan[c];
                                ++j;
lbl45:
                                // 2 sources

                            } while (j < rowSize);
                        }
                        ++r;
                        colNum = 0;
                        while (colNum < columns) {
                            if (rowspan[colNum] > 0) {
                                v0 = colNum;
                                rowspan[v0] = rowspan[v0] - 1;
                            }
                            if (rowspan[colNum] == 0) {
                                columnspan[colNum] = 0;
                            }
                            ++colNum;
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.iteratorPos < this.list.size();
        }

        public Object next() {
            return this.list.get(this.iteratorPos++);
        }

        public void rewind() {
            this.iteratorPos = 0;
        }

        @Override
        public void remove() {
        }
    }

    public static class WmiTableCellIteratorNode {
        private int row;
        private int column;
        private WmiTableCellModel cell;

        private WmiTableCellIteratorNode(int row, int column, WmiTableCellModel cell) {
            this.row = row;
            this.column = column;
            this.cell = cell;
        }

        public int getRowIndex() {
            return this.row;
        }

        public int getColumnIndex() {
            return this.column;
        }

        public WmiTableCellModel getCell() {
            return this.cell;
        }
    }

    private static class WmiTableUndoableEdit
    extends WmiAbstractArrayCompositeModel.WmiUndoableCompositeModelEdit {
        WmiTableUndoableEdit(WmiAbstractArrayCompositeModel model) {
            super(model);
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            super.undo();
            if (this.containsAttributeEdit()) {
                try {
                    this.updateNotify(this.getModel());
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            super.redo();
            if (this.containsAttributeEdit()) {
                try {
                    this.updateNotify(this.getModel());
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
        }

        public void updateNotify(WmiModel root) throws WmiNoReadAccessException {
            WmiMathDocumentModel docModel = this.getModel().getDocument();
            docModel.notifyModelListeners(root, 0);
            if (root instanceof WmiCompositeModel) {
                WmiCompositeModel composite = (WmiCompositeModel)root;
                int size = composite.getChildCount();
                int i = 0;
                while (i < size) {
                    this.updateNotify(composite.getChild(i));
                    ++i;
                }
            }
        }
    }
}

