/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.Arrays;
import java.util.HashMap;

public class WmiTransferModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    private HashMap fonts = new HashMap();
    private WmiModelTag tag = null;
    private WmiMathSemantics semantics = null;

    public WmiTransferModel(WmiMathDocumentModel docModel) {
        super(docModel);
    }

    public WmiTransferModel(WmiCompositeModel composite) throws WmiNoReadAccessException {
        super(composite.getDocument());
        this.attributes = composite.getAttributesForRead();
        this.tag = composite.getTag();
    }

    public WmiTransferModel(WmiCompositeModel composite, int first, int last) throws WmiNoReadAccessException {
        this(composite);
        int size;
        if (first == -1) {
            first = 0;
        }
        if (last == -1) {
            last = composite.getChildCount() - 1;
        }
        if ((size = last - first + 1) > 0) {
            this.children = new WmiModel[size];
            int i = 0;
            while (i < size) {
                this.children[i] = composite.getChild(first + i);
                ++i;
            }
            this.length = size;
        } else {
            this.children = new WmiModel[0];
            this.length = 0;
        }
        this.validateArrayForMath();
    }

    private void validateArrayForMath() {
        if (this.tag == WmiModelTag.MATH_SUPERSCRIPT || this.tag == WmiModelTag.MATH_SUBSCRIPT || this.tag == WmiModelTag.MATH_FRAC || this.tag == WmiModelTag.MATH_OVER || this.tag == WmiModelTag.MATH_UNDER || this.tag == WmiModelTag.MATH_NROOT) {
            this.correctChildCount(2);
        } else if (this.tag == WmiModelTag.MATH_UNDER_OVER || this.tag == WmiModelTag.MATH_SUB_SUP) {
            this.correctChildCount(3);
        } else if (this.tag == WmiModelTag.MATH_SQUARE_ROOT) {
            this.correctChildCount(1);
        }
    }

    private void correctChildCount(int correctCount) {
        int childCount = this.children.length;
        WmiModel[] newChildren = new WmiModel[correctCount];
        boolean modified = false;
        if (childCount < correctCount) {
            modified = true;
            int adds = correctCount - childCount;
            System.arraycopy(this.children, 0, newChildren, 0, childCount);
            WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.attributes);
            int i = childCount;
            while (i < correctCount) {
                newChildren[i] = WmiMathFactory.createMathIdentifierToken(this.getDocument(), "?", context);
                ++i;
            }
        } else if (childCount > correctCount) {
            modified = true;
            System.arraycopy(this.children, 0, newChildren, 0, correctCount);
        }
        if (modified) {
            this.length = correctCount;
            this.children = newChildren;
        }
    }

    public WmiTransferModel(WmiModel model) throws WmiNoReadAccessException {
        super(model.getDocument());
        this.children = new WmiModel[]{model};
        this.attributes = model.getAttributesForRead();
        this.tag = model.getTag();
    }

    public WmiAttributeSet getTransferAttributes() throws WmiNoReadAccessException {
        return this.attributes;
    }

    public void trim(int index) {
        if (index == this.length - 1) {
            this.children[this.length - 1] = null;
            --this.length;
        } else if (this.length - index - 1 > 0) {
            System.arraycopy(this.children, index + 1, this.children, index, this.length - index - 1);
            --this.length;
        }
    }

    public WmiTransferModel convertToTransferModel(int index) throws WmiNoReadAccessException {
        WmiTransferModel model = null;
        WmiModel child = this.getChild(index);
        if (child instanceof WmiCompositeModel) {
            model = new WmiTransferModel((WmiCompositeModel)child, 0, ((WmiCompositeModel)child).getChildCount() - 1);
            this.children[index] = model;
        }
        return model;
    }

    public HashMap getFonts() {
        return this.fonts;
    }

    public void addFont(String name, WmiFontAttributeSet set) {
        this.fonts.put(name, set);
    }

    public void replaceFirstChild(WmiModel model) {
        if (this.length > 0) {
            this.children[0] = model;
        }
    }

    public void replaceLastChild(WmiModel model) {
        if (this.length > 0) {
            this.children[this.length - 1] = model;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceChildren(WmiModel[] replacement, int first, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (!(this.pending instanceof WmiAbstractArrayCompositeModel)) throw new WmiNoWriteAccessException(this);
        WmiAbstractArrayCompositeModel model = (WmiAbstractArrayCompositeModel)this.pending;
        if (first < 0 || first > model.length) {
            throw new WmiModelIndexOutOfBoundsException(this, first);
        }
        if (span < 0) {
            throw new WmiModelIndexOutOfBoundsException(this, span);
        }
        int limit = model.length;
        if (first + span > limit) {
            throw new WmiModelIndexOutOfBoundsException(this, first + span);
        }
        int newLength = model.length - span;
        int shift = -span;
        if (replacement != null) {
            newLength += replacement.length;
            shift += replacement.length;
        }
        if (newLength < 0) throw new WmiModelIndexOutOfBoundsException(this, newLength);
        model.ensureCapacity(newLength, this);
        if (shift > 0) {
            System.arraycopy(model.children, first, model.children, first + shift, model.length - first);
        } else if (shift < 0) {
            System.arraycopy(model.children, first - shift, model.children, first, model.length - first + shift);
            Arrays.fill(model.children, model.length + shift, model.length, null);
        }
        if (replacement != null) {
            System.arraycopy(replacement, 0, model.children, first, replacement.length);
        }
        model.length = newLength;
    }

    public WmiModel getFirstChild() {
        return this.length > 0 ? this.children[0] : null;
    }

    public WmiModel getLastChild() {
        return this.length > 0 ? this.children[this.length - 1] : null;
    }

    @Override
    public int getChildCount() {
        return this.length;
    }

    @Override
    public void update(String undoName) {
        WmiErrorLog.log(new Exception("IncompatibleOperation"));
    }

    @Override
    public WmiModelTag getTag() {
        return this.tag;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }
}

