/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiUndoManager {
    private static final int UNDO_BUFFER_LENGTH = 20;
    private WmiCompositeUndoableEdit[] edits = new WmiCompositeUndoableEdit[20];
    private WmiMathDocumentModel doc = null;
    private int active = -1;
    private int tail = 0;
    private WmiCompositeUndoableEdit currentEdit = null;
    private boolean duringUndoOrRedo = false;

    public WmiUndoManager(WmiMathDocumentModel model) {
        this.doc = model;
    }

    public WmiCompositeUndoableEdit beginEdit(String name) {
        return this.beginEdit(name, null);
    }

    public WmiCompositeUndoableEdit beginEdit(String name, WmiCompositeUndoableEdit edit) {
        int adjustedTail = this.active + 1;
        if (adjustedTail >= 20) {
            adjustedTail = 0;
        }
        while (this.tail != adjustedTail) {
            if (--this.tail >= 0) continue;
            this.tail = 19;
        }
        this.flush(this.tail);
        this.edits[this.tail] = edit != null ? edit : new WmiCompositeUndoableEdit(name);
        this.currentEdit = this.edits[this.tail];
        try {
            this.doc.notifyModelListeners(this.currentEdit, 3);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return this.currentEdit;
    }

    public boolean endEdit() {
        boolean success = false;
        if (this.currentEdit != null) {
            success = true;
            try {
                this.doc.notifyModelListeners(this.currentEdit, 4);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            this.currentEdit = null;
            if (++this.tail == 20) {
                this.tail = 0;
            }
            if (this.edits[this.tail] != null) {
                try {
                    this.doc.notifyModelListeners(this.edits[this.tail], 5);
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
            this.edits[this.tail] = null;
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
        return success;
    }

    public boolean addEdit(WmiUndoableEdit edit) {
        boolean success = false;
        if (this.currentEdit != null) {
            this.currentEdit.addEdit(edit);
            success = true;
        } else {
            WmiErrorLog.log(new Exception("Cannot add edit"));
        }
        return success;
    }

    public void undo() {
        if (this.currentEdit != null) {
            this.endEdit();
        }
        try {
            try {
                this.duringUndoOrRedo = true;
                this.doc.notifyModelListeners(this.doc, 2);
                WmiModelLock.updateLock(this.doc, true);
                WmiCompositeUndoableEdit edit = this.getEdit(this.active);
                if (edit != null) {
                    edit.undo();
                }
                this.doc.notifyModelListeners(edit, 6);
                this.doc.notifyModelListeners(this.doc, 1);
                if (--this.active < 0) {
                    this.active = 19;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.updateUnlock(this.doc);
                this.duringUndoOrRedo = false;
            }
            catch (WmiNoUpdateAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.updateUnlock(this.doc);
                this.duringUndoOrRedo = false;
            }
        }
        finally {
            WmiModelLock.updateUnlock(this.doc);
            this.duringUndoOrRedo = false;
        }
    }

    public void redo() {
        try {
            try {
                this.duringUndoOrRedo = true;
                this.doc.notifyModelListeners(this.doc, 2);
                WmiModelLock.updateLock(this.doc, true);
                WmiCompositeUndoableEdit edit = this.getEdit(this.active + 1);
                if (edit != null) {
                    edit.redo();
                }
                this.doc.notifyModelListeners(edit, 7);
                this.doc.notifyModelListeners(this.doc, 1);
                if (++this.active == 20) {
                    this.active = 0;
                }
            }
            catch (WmiNoReadAccessException nrae) {
                WmiErrorLog.log(nrae);
                WmiModelLock.updateUnlock(this.doc);
                this.duringUndoOrRedo = false;
            }
            catch (WmiNoUpdateAccessException nuae) {
                WmiErrorLog.log(nuae);
                WmiModelLock.updateUnlock(this.doc);
                this.duringUndoOrRedo = false;
            }
        }
        finally {
            WmiModelLock.updateUnlock(this.doc);
            this.duringUndoOrRedo = false;
        }
    }

    public boolean isUndoingOrRedoing() {
        return this.duringUndoOrRedo;
    }

    public void flush() {
        int i = 0;
        while (i < 20) {
            this.flush(i);
            ++i;
        }
        this.active = -1;
        this.tail = 0;
    }

    private void flush(int index) {
        if (this.edits[index] != null) {
            try {
                this.doc.notifyModelListeners(this.edits[index], 5);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            this.edits[index] = null;
        }
    }

    public String getUndoName() {
        String name = null;
        WmiCompositeUndoableEdit edit = this.getEdit(this.active);
        if (edit != null) {
            name = edit.getName();
        }
        return name;
    }

    public String getRedoName() {
        String name = null;
        WmiCompositeUndoableEdit edit = this.getEdit(this.active + 1);
        if (edit != null) {
            name = edit.getName();
        }
        return name;
    }

    public boolean canUndo() {
        return this.getEdit(this.active) != null;
    }

    public boolean canRedo() {
        return this.getEdit(this.active + 1) != null;
    }

    public WmiCompositeUndoableEdit getEdit(int index) {
        if (index >= 20) {
            index -= 20;
        }
        WmiCompositeUndoableEdit edit = null;
        if (index >= 0 && index < 20 && index != this.tail) {
            edit = this.edits[index];
        }
        return edit;
    }

    public WmiCompositeUndoableEdit getActiveEdit() {
        return this.currentEdit;
    }

    public void coalesceLastEdits() {
        int top = this.tail - 1;
        if (top < 0) {
            top = 19;
        }
        if (this.edits[top] != null && this.edits[top].isCoalescable()) {
            while (true) {
                int prevTail;
                if ((prevTail = top - 1) < 0) {
                    prevTail = 19;
                }
                if (this.edits[prevTail] == null || !this.edits[prevTail].isCoalescable()) break;
                this.edits[prevTail].combineWith(this.edits[top]);
                this.flush(top);
                if (--top >= 0) continue;
                top = 19;
            }
            this.tail = top + 1;
            if (this.tail >= 20) {
                this.tail = 0;
            }
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
    }

    public void removeCoalescableEdits() {
        int top = this.tail - 1;
        if (top < 0) {
            top = 19;
        }
        if (this.edits[top] != null && this.edits[top].isCoalescable()) {
            while (this.edits[top] != null && this.edits[top].isCoalescable()) {
                this.flush(top);
                if (--top >= 0) continue;
                top = 19;
            }
            this.tail = top + 1;
            if (this.tail >= 20) {
                this.tail = 0;
            }
            this.active = this.tail - 1;
            if (this.active < 0) {
                this.active = 19;
            }
        }
    }

    public void makeLastEditCoalescable(boolean isCoalescable) {
        int top = this.tail - 1;
        if (top < 0) {
            top = 19;
        }
        if (this.edits[top] != null) {
            this.edits[top].setCoalescable(isCoalescable);
        }
    }

    public void clearRedo() {
        int adjustedTail = this.active + 1;
        if (adjustedTail >= 20) {
            adjustedTail = 0;
        }
        while (this.tail != adjustedTail) {
            if (--this.tail >= 0) continue;
            this.tail = 19;
        }
    }
}

