/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics;

import com.maplesoft.mathdoc.model.graphics.GfxDimension;
import com.maplesoft.mathdoc.model.graphics.GfxDoubleArray;
import com.maplesoft.mathdoc.model.graphics.GfxFloatArray;
import com.maplesoft.mathdoc.model.graphics.GfxIntArray;

public abstract class GfxArray {
    public static final int X_DIM_INDEX = GfxDimension.X_DIMENSION.getIndex();
    public static final int Y_DIM_INDEX = GfxDimension.Y_DIMENSION.getIndex();
    public static final int Z_DIM_INDEX = GfxDimension.Z_DIMENSION.getIndex();

    public abstract double[][] getStructureDvv(int var1);

    public abstract double[][] getStructure2Dvv(int var1);

    public abstract double[][] getStructure3Dvv(int var1);

    public abstract double[] getPoint2Dv(int var1, int var2);

    public abstract double[] getPoint3Dv(int var1, int var2);

    public abstract double[] getDimensionDv(int var1, GfxDimension var2);

    public abstract double getValueD(int var1, GfxDimension var2, int var3);

    public abstract double getXValueD(int var1, int var2);

    public abstract double getYValueD(int var1, int var2);

    public abstract double getZValueD(int var1, int var2);

    public abstract float[][] getStructureFvv(int var1);

    public abstract float getValueF(int var1, GfxDimension var2, int var3);

    public abstract float getXValueF(int var1, int var2);

    public abstract float getYValueF(int var1, int var2);

    public abstract float getZValueF(int var1, int var2);

    public abstract int[][] getStructureIvv(int var1);

    public abstract int getValueI(int var1, GfxDimension var2, int var3);

    public abstract int getXValueI(int var1, int var2);

    public abstract int getYValueI(int var1, int var2);

    public abstract int getZValueI(int var1, int var2);

    public final double[] getPoint2Dv(int index) {
        return this.getPoint2Dv(0, index);
    }

    public final double[] getPoint3Dv(int index) {
        return this.getPoint3Dv(0, index);
    }

    public final double[] getDimensionDv(GfxDimension dim) {
        return this.getDimensionDv(0, dim);
    }

    public final double getValueD(GfxDimension dim, int index) {
        return this.getValueD(0, dim, index);
    }

    public final double getXValueD(int index) {
        return this.getXValueD(0, index);
    }

    public final double getYValueD(int index) {
        return this.getYValueD(0, index);
    }

    public final double getZValueD(int index) {
        return this.getZValueD(0, index);
    }

    public final float getValueF(GfxDimension dim, int index) {
        return this.getValueF(0, dim, index);
    }

    public final float getXValueF(int index) {
        return this.getXValueF(0, index);
    }

    public final float getYValueF(int index) {
        return this.getYValueF(0, index);
    }

    public final float getZValueF(int index) {
        return this.getZValueF(0, index);
    }

    public final int getValueI(GfxDimension dim, int index) {
        return this.getValueI(0, dim, index);
    }

    public final int getXValueI(int index) {
        return this.getXValueI(0, index);
    }

    public final int getYValueI(int index) {
        return this.getYValueI(0, index);
    }

    public final int getZValueI(int index) {
        return this.getZValueI(0, index);
    }

    public abstract int getStructureCount();

    public abstract int getValueCount(int var1);

    public abstract boolean isClosed(int var1);

    public boolean isClosed() {
        return this.isClosed(0);
    }

    public final GfxArray getSubArray(int structure) {
        return this.getSubArray(structure, structure);
    }

    public abstract GfxArray getSubArray(int var1, int var2);

    protected final void rangeCheck(int from, int to) {
        if (from < 0 || from >= this.getStructureCount() || to < 0 || to >= this.getStructureCount()) {
            throw new IndexOutOfBoundsException("subarray index out of range: from=" + from + ", to=" + to);
        }
    }

    public static GfxArray createMultiStructureArrayD(double[][][] data, boolean[] closed) {
        return new GfxDoubleArray.MultiStructureArray(data, closed);
    }

    public static GfxArray createSingleStructureArrayD(double[][] data, boolean closed) {
        return new GfxDoubleArray.SingleStructureArray(data, closed);
    }

    public static GfxArray createMultiStructureArrayF(float[][][] data, boolean[] closed) {
        return new GfxFloatArray.MultiStructureArray(data, closed);
    }

    public static GfxArray createSingleStructureArrayF(float[][] data, boolean closed) {
        return new GfxFloatArray.SingleStructureArray(data, closed);
    }

    public static GfxArray createMultiStructureArrayI(int[][][] data, boolean[] closed) {
        return new GfxIntArray.MultiStructureArray(data, closed);
    }

    public static GfxArray createSingleStructureArrayI(int[][] data, boolean closed) {
        return new GfxIntArray.SingleStructureArray(data, closed);
    }
}

