/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics;

import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics.GfxDimension;

abstract class GfxDoubleArray
extends GfxArray {
    GfxDoubleArray() {
    }

    @Override
    public double[][] getStructureDvv(int structure) {
        return this.getStructure0(structure);
    }

    @Override
    public double[][] getStructure2Dvv(int structure) {
        return this.getStructure0(structure);
    }

    @Override
    public double[][] getStructure3Dvv(int structure) {
        return this.getStructure0(structure);
    }

    @Override
    public double[] getPoint2Dv(int structure, int index) {
        double[][] d = this.getStructureDvv(structure);
        return new double[]{d[X_DIM_INDEX][index], d[Y_DIM_INDEX][index]};
    }

    @Override
    public double[] getPoint3Dv(int structure, int index) {
        double[][] d = this.getStructureDvv(structure);
        return new double[]{d[X_DIM_INDEX][index], d[Y_DIM_INDEX][index], d[Z_DIM_INDEX][index]};
    }

    @Override
    public double[] getDimensionDv(int structure, GfxDimension dim) {
        return this.getStructureDvv(structure)[dim.getIndex()];
    }

    @Override
    public double getValueD(int structure, GfxDimension dim, int index) {
        return this.getStructureDvv(structure)[dim.getIndex()][index];
    }

    @Override
    public double getXValueD(int structure, int index) {
        return this.getStructureDvv(structure)[X_DIM_INDEX][index];
    }

    @Override
    public double getYValueD(int structure, int index) {
        return this.getStructureDvv(structure)[Y_DIM_INDEX][index];
    }

    @Override
    public double getZValueD(int structure, int index) {
        return this.getStructureDvv(structure)[Z_DIM_INDEX][index];
    }

    @Override
    public float[][] getStructureFvv(int structure) {
        double[][] dvv = this.getStructureDvv(structure);
        float[][] fvv = new float[dvv.length][];
        int i = 0;
        while (i < dvv.length) {
            fvv[i] = new float[dvv[i].length];
            int j = 0;
            while (j < dvv[i].length) {
                fvv[i][j] = (float)dvv[i][j];
                ++j;
            }
            ++i;
        }
        return fvv;
    }

    @Override
    public float getValueF(int structure, GfxDimension dim, int index) {
        return (float)this.getValueD(structure, dim, index);
    }

    @Override
    public float getXValueF(int structure, int index) {
        return (float)this.getXValueD(structure, index);
    }

    @Override
    public float getYValueF(int structure, int index) {
        return (float)this.getYValueD(structure, index);
    }

    @Override
    public float getZValueF(int structure, int index) {
        return (float)this.getZValueD(structure, index);
    }

    @Override
    public int[][] getStructureIvv(int structure) {
        double[][] d = this.getStructureDvv(structure);
        int[] x = new int[d[X_DIM_INDEX].length];
        int[] y = new int[d[Y_DIM_INDEX].length];
        int i = 0;
        while (i < x.length) {
            x[i] = (int)d[X_DIM_INDEX][i];
            y[i] = (int)d[Y_DIM_INDEX][i];
            ++i;
        }
        return new int[][]{x, y};
    }

    @Override
    public int getValueI(int structure, GfxDimension dim, int index) {
        return (int)this.getValueD(structure, dim, index);
    }

    @Override
    public int getXValueI(int structure, int index) {
        return (int)this.getXValueD(structure, index);
    }

    @Override
    public int getYValueI(int structure, int index) {
        return (int)this.getYValueD(structure, index);
    }

    @Override
    public int getZValueI(int structure, int index) {
        return (int)this.getZValueD(structure, index);
    }

    @Override
    public GfxArray getSubArray(int fromStructure, int toStructure) {
        this.rangeCheck(fromStructure, toStructure);
        GfxDoubleArray array = null;
        if (fromStructure == toStructure) {
            array = new SingleStructureArray(this.getStructure0(fromStructure), this.isClosed(fromStructure));
        } else if (fromStructure == 0 && toStructure == this.getStructureCount() - 1) {
            array = this;
        } else {
            double[][][] d = new double[toStructure - fromStructure + 1][][];
            boolean[] b = new boolean[toStructure - fromStructure + 1];
            int i = fromStructure;
            while (i <= toStructure) {
                d[i - fromStructure] = this.getStructure0(i);
                b[i - fromStructure] = this.isClosed(i);
                ++i;
            }
            array = new MultiStructureArray(d, b);
        }
        return array;
    }

    protected abstract double[][] getStructure0(int var1);

    protected static final class MultiStructureArray
    extends GfxDoubleArray {
        private double[][][] data;
        private boolean[] closed;

        public MultiStructureArray(double[][][] data, boolean[] closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected double[][] getStructure0(int structure) {
            return this.data[structure];
        }

        @Override
        public int getStructureCount() {
            return this.data.length;
        }

        @Override
        public boolean isClosed(int structure) {
            return this.closed[structure];
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0][0].length;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed(0);
        }
    }

    protected static final class SingleStructureArray
    extends GfxDoubleArray {
        private double[][] data;
        private boolean closed;

        public SingleStructureArray(double[][] data, boolean closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected double[][] getStructure0(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.data;
        }

        @Override
        public int getStructureCount() {
            return 1;
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0].length;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isClosed(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.closed;
        }
    }
}

