/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics;

import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics.GfxDimension;

abstract class GfxFloatArray
extends GfxArray {
    GfxFloatArray() {
    }

    @Override
    public double[][] getStructureDvv(int structure) {
        float[][] fvv = this.getStructureFvv(structure);
        double[][] dvv = new double[fvv.length][];
        int i = 0;
        while (i < fvv.length) {
            dvv[i] = new double[fvv[i].length];
            int j = 0;
            while (j < fvv[i].length) {
                dvv[i][j] = fvv[i][j];
                ++j;
            }
            ++i;
        }
        return dvv;
    }

    @Override
    public double[][] getStructure2Dvv(int structure) {
        return this.getStructureDvv(structure);
    }

    @Override
    public double[][] getStructure3Dvv(int structure) {
        return this.getStructureDvv(structure);
    }

    @Override
    public double[] getPoint2Dv(int structure, int index) {
        return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index)};
    }

    @Override
    public double[] getPoint3Dv(int structure, int index) {
        return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index), this.getZValueD(structure, index)};
    }

    @Override
    public double[] getDimensionDv(int structure, GfxDimension dim) {
        float[][] fvv = this.getStructureFvv(structure);
        double[] dv = new double[fvv[dim.getIndex()].length];
        int i = 0;
        while (i < dv.length) {
            dv[i] = fvv[dim.getIndex()][i];
            ++i;
        }
        return dv;
    }

    @Override
    public double getValueD(int structure, GfxDimension dim, int index) {
        return this.getValueF(structure, dim, index);
    }

    @Override
    public double getXValueD(int structure, int index) {
        return this.getXValueF(structure, index);
    }

    @Override
    public double getYValueD(int structure, int index) {
        return this.getYValueF(structure, index);
    }

    @Override
    public double getZValueD(int structure, int index) {
        return this.getZValueF(structure, index);
    }

    @Override
    public float[][] getStructureFvv(int structure) {
        return this.getStructure0(structure);
    }

    @Override
    public float getValueF(int structure, GfxDimension dim, int index) {
        return this.getStructure0(structure)[dim.getIndex()][index];
    }

    @Override
    public float getXValueF(int structure, int index) {
        return this.getStructure0(structure)[X_DIM_INDEX][index];
    }

    @Override
    public float getYValueF(int structure, int index) {
        return this.getStructure0(structure)[Y_DIM_INDEX][index];
    }

    @Override
    public float getZValueF(int structure, int index) {
        return this.getStructure0(structure)[Z_DIM_INDEX][index];
    }

    @Override
    public int[][] getStructureIvv(int structure) {
        float[][] fvv = this.getStructureFvv(structure);
        int[] x = new int[fvv[X_DIM_INDEX].length];
        int[] y = new int[fvv[Y_DIM_INDEX].length];
        int i = 0;
        while (i < x.length) {
            x[i] = (int)fvv[X_DIM_INDEX][i];
            y[i] = (int)fvv[Y_DIM_INDEX][i];
            ++i;
        }
        return new int[][]{x, y};
    }

    @Override
    public int getValueI(int structure, GfxDimension dim, int index) {
        return (int)this.getValueF(structure, dim, index);
    }

    @Override
    public int getXValueI(int structure, int index) {
        return (int)this.getXValueF(structure, index);
    }

    @Override
    public int getYValueI(int structure, int index) {
        return (int)this.getYValueF(structure, index);
    }

    @Override
    public int getZValueI(int structure, int index) {
        return (int)this.getZValueF(structure, index);
    }

    @Override
    public GfxArray getSubArray(int fromStructure, int toStructure) {
        this.rangeCheck(fromStructure, toStructure);
        GfxFloatArray array = null;
        if (fromStructure == toStructure) {
            array = new SingleStructureArray(this.getStructure0(fromStructure), this.isClosed(fromStructure));
        } else if (fromStructure == 0 && toStructure == this.getStructureCount() - 1) {
            array = this;
        } else {
            float[][][] f = new float[toStructure - fromStructure + 1][][];
            boolean[] b = new boolean[toStructure - fromStructure + 1];
            int i = fromStructure;
            while (i <= toStructure) {
                f[i - fromStructure] = this.getStructure0(i);
                b[i - fromStructure] = this.isClosed(i);
                ++i;
            }
            array = new MultiStructureArray(f, b);
        }
        return array;
    }

    protected abstract float[][] getStructure0(int var1);

    protected static final class MultiStructureArray
    extends GfxFloatArray {
        private float[][][] data;
        private boolean[] closed;

        public MultiStructureArray(float[][][] data, boolean[] closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected float[][] getStructure0(int structure) {
            return this.data[structure];
        }

        @Override
        public int getStructureCount() {
            return this.data.length;
        }

        @Override
        public boolean isClosed(int structure) {
            return this.closed[structure];
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0][0].length;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed(0);
        }
    }

    protected static final class SingleStructureArray
    extends GfxFloatArray {
        private float[][] data;
        private boolean closed;

        public SingleStructureArray(float[][] data, boolean closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected float[][] getStructure0(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.data;
        }

        @Override
        public int getStructureCount() {
            return 1;
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0].length;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isClosed(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.closed;
        }
    }
}

