/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics;

import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics.GfxDimension;

abstract class GfxIntArray
extends GfxArray {
    GfxIntArray() {
    }

    @Override
    public double[][] getStructureDvv(int structure) {
        int[][] ivv = this.getStructureIvv(structure);
        double[][] dvv = new double[ivv.length][];
        int i = 0;
        while (i < ivv.length) {
            dvv[i] = new double[ivv[i].length];
            int j = 0;
            while (j < ivv[i].length) {
                dvv[i][j] = ivv[i][j];
                ++j;
            }
            ++i;
        }
        return dvv;
    }

    @Override
    public double[][] getStructure2Dvv(int structure) {
        return this.getStructureDvv(structure);
    }

    @Override
    public double[][] getStructure3Dvv(int structure) {
        return this.getStructureDvv(structure);
    }

    @Override
    public double[] getPoint2Dv(int structure, int index) {
        return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index)};
    }

    @Override
    public double[] getPoint3Dv(int structure, int index) {
        return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index), this.getZValueD(structure, index)};
    }

    @Override
    public double[] getDimensionDv(int structure, GfxDimension dim) {
        int[][] ivv = this.getStructureIvv(structure);
        double[] dv = new double[ivv[dim.getIndex()].length];
        int i = 0;
        while (i < dv.length) {
            dv[i] = ivv[dim.getIndex()][i];
            ++i;
        }
        return dv;
    }

    @Override
    public double getValueD(int structure, GfxDimension dim, int index) {
        return this.getValueI(structure, dim, index);
    }

    @Override
    public double getXValueD(int structure, int index) {
        return this.getXValueI(structure, index);
    }

    @Override
    public double getYValueD(int structure, int index) {
        return this.getYValueI(structure, index);
    }

    @Override
    public double getZValueD(int structure, int index) {
        return this.getZValueI(structure, index);
    }

    @Override
    public float[][] getStructureFvv(int structure) {
        int[][] ivv = this.getStructureIvv(structure);
        float[][] fvv = new float[ivv.length][];
        int i = 0;
        while (i < ivv.length) {
            fvv[i] = new float[ivv[i].length];
            int j = 0;
            while (j < ivv[i].length) {
                fvv[i][j] = ivv[i][j];
                ++j;
            }
            ++i;
        }
        return fvv;
    }

    @Override
    public float getValueF(int structure, GfxDimension dim, int index) {
        return this.getValueI(structure, dim, index);
    }

    @Override
    public float getXValueF(int structure, int index) {
        return this.getXValueI(structure, index);
    }

    @Override
    public float getYValueF(int structure, int index) {
        return this.getYValueI(structure, index);
    }

    @Override
    public float getZValueF(int structure, int index) {
        return this.getZValueI(structure, index);
    }

    @Override
    public int[][] getStructureIvv(int structure) {
        return this.getStructure0(structure);
    }

    @Override
    public int getValueI(int structure, GfxDimension dim, int index) {
        return this.getStructure0(structure)[dim.getIndex()][index];
    }

    @Override
    public int getXValueI(int structure, int index) {
        return this.getStructure0(structure)[X_DIM_INDEX][index];
    }

    @Override
    public int getYValueI(int structure, int index) {
        return this.getStructure0(structure)[Y_DIM_INDEX][index];
    }

    @Override
    public int getZValueI(int structure, int index) {
        return this.getStructure0(structure)[Z_DIM_INDEX][index];
    }

    @Override
    public GfxArray getSubArray(int fromStructure, int toStructure) {
        this.rangeCheck(fromStructure, toStructure);
        GfxIntArray array = null;
        if (fromStructure == toStructure) {
            array = new SingleStructureArray(this.getStructure0(fromStructure), this.isClosed(fromStructure));
        } else if (fromStructure == 0 && toStructure == this.getStructureCount() - 1) {
            array = this;
        } else {
            int[][][] a = new int[toStructure - fromStructure + 1][][];
            boolean[] b = new boolean[toStructure - fromStructure + 1];
            int i = fromStructure;
            while (i <= toStructure) {
                a[i - fromStructure] = this.getStructure0(i);
                b[i - fromStructure] = this.isClosed(i);
                ++i;
            }
            array = new MultiStructureArray(a, b);
        }
        return array;
    }

    protected abstract int[][] getStructure0(int var1);

    protected static final class MultiStructureArray
    extends GfxIntArray {
        private int[][][] data;
        private boolean[] closed;

        public MultiStructureArray(int[][][] data, boolean[] closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected int[][] getStructure0(int structure) {
            return this.data[structure];
        }

        @Override
        public int getStructureCount() {
            return this.data.length;
        }

        @Override
        public boolean isClosed(int structure) {
            return this.closed[structure];
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0][0].length;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed(0);
        }
    }

    protected static final class SingleStructureArray
    extends GfxIntArray {
        private int[][] data;
        private boolean closed;

        public SingleStructureArray(int[][] data, boolean closed) {
            this.data = data;
            this.closed = closed;
        }

        @Override
        protected int[][] getStructure0(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.data;
        }

        @Override
        public int getStructureCount() {
            return 1;
        }

        @Override
        public int getValueCount(int structure) {
            return this.data[0].length;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isClosed(int structure) {
            if (structure != 0) {
                throw new IndexOutOfBoundsException("structure: " + structure);
            }
            return this.closed;
        }
    }
}

