/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics;

import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics.GfxDimension;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;

public abstract class GfxMutableArray
extends GfxArray {
    public abstract void setValue2D(int var1, int var2, double var3, double var5);

    public abstract void setValue2D(int var1, double var2, double var4);

    public abstract void appendValue2D(int var1, double var2, double var4);

    public abstract void appendValue2F(int var1, float var2, float var3);

    public abstract void appendValue2I(int var1, int var2, int var3);

    public abstract void appendValue2D(double var1, double var3);

    public abstract void appendValue2F(float var1, float var2);

    public abstract void appendValue2I(int var1, int var2);

    public abstract void closeStructure(boolean var1);

    public abstract void newStructure();

    public abstract GfxArray commitToDoubleArray();

    public abstract GfxArray commitToFloatArray();

    public abstract GfxArray commitToIntArray();

    public static GfxMutableArray createMutableInstance(GfxArray array) {
        return null;
    }

    public static GfxMutableArray createEmptyArray() {
        return new ArrayListMutableArray();
    }

    private static final class ArrayListMutableArray
    extends GfxMutableArray {
        private ArrayList structures = new ArrayList();
        private BitSet closed = new BitSet();

        private ArrayList getStructure(int s) {
            return (ArrayList)this.structures.get(s);
        }

        private ArrayList getCurrentStructure() {
            return (ArrayList)this.structures.get(this.structures.size() - 1);
        }

        private boolean[] getClosedArray(int from, int to) {
            boolean[] b = new boolean[from - to + 1];
            int i = 0;
            while (i < b.length) {
                b[i] = this.closed.get(i + from);
                ++i;
            }
            return b;
        }

        @Override
        public void closeStructure(boolean closed) {
            this.closed.set(this.structures.size() - 1, closed);
        }

        @Override
        public void newStructure() {
            this.closed.set(this.structures.size(), false);
            this.structures.add(new ArrayList());
        }

        @Override
        public GfxArray commitToDoubleArray() {
            return this.commitToDoubleArray(0, this.getStructureCount() - 1);
        }

        public GfxArray commitToDoubleArray(int from, int to) {
            this.rangeCheck(from, to);
            GfxArray array = null;
            if (from == to) {
                array = GfxArray.createSingleStructureArrayD(this.getStructureDvv(from), this.closed.get(from));
            } else if (this.getStructureCount() > 1) {
                double[][][] dvvv = new double[to - from + 1][][];
                int i = 0;
                while (i < dvvv.length) {
                    dvvv[i] = this.getStructureDvv(i + from);
                    ++i;
                }
                array = GfxArray.createMultiStructureArrayD(dvvv, this.getClosedArray(from, to));
            }
            return array;
        }

        @Override
        public GfxArray commitToFloatArray() {
            return this.commitToFloatArray(0, this.getStructureCount() - 1);
        }

        public GfxArray commitToFloatArray(int from, int to) {
            this.rangeCheck(from, to);
            GfxArray array = null;
            if (from == to) {
                array = GfxArray.createSingleStructureArrayF(this.getStructureFvv(from), this.closed.get(from));
            } else if (this.getStructureCount() > 1) {
                float[][][] fvvv = new float[to - from + 1][][];
                int i = 0;
                while (i < fvvv.length) {
                    fvvv[i] = this.getStructureFvv(i + from);
                    ++i;
                }
                array = GfxArray.createMultiStructureArrayF(fvvv, this.getClosedArray(from, to));
            }
            return array;
        }

        @Override
        public GfxArray commitToIntArray() {
            return this.commitToIntArray(0, this.getStructureCount() - 1);
        }

        public GfxArray commitToIntArray(int from, int to) {
            this.rangeCheck(from, to);
            GfxArray array = null;
            if (from == to) {
                array = GfxArray.createSingleStructureArrayI(this.getStructureIvv(from), this.closed.get(from));
            } else {
                int[][][] ivvv = new int[to - from + 1][][];
                int i = 0;
                while (i < ivvv.length) {
                    ivvv[i] = this.getStructureIvv(i + from);
                    ++i;
                }
                array = GfxArray.createMultiStructureArrayI(ivvv, this.getClosedArray(from, to));
            }
            return array;
        }

        @Override
        public void setValue2D(int curve, int index, double x, double y) {
            this.getStructure(curve).set(index, new double[]{x, y});
        }

        @Override
        public void setValue2D(int index, double x, double y) {
            this.getStructure(0).set(index, new double[]{x, y});
        }

        @Override
        public void appendValue2D(int curve, double x, double y) {
            this.getStructure(curve).add(new double[]{x, y});
        }

        @Override
        public void appendValue2F(int curve, float x, float y) {
            this.getStructure(curve).add(new float[]{x, y});
        }

        @Override
        public void appendValue2I(int curve, int x, int y) {
            this.getStructure(curve).add(new int[]{x, y});
        }

        @Override
        public void appendValue2D(double x, double y) {
            this.getCurrentStructure().add(new double[]{x, y});
        }

        @Override
        public void appendValue2F(float x, float y) {
            this.getCurrentStructure().add(new float[]{x, y});
        }

        @Override
        public void appendValue2I(int x, int y) {
            this.getCurrentStructure().add(new int[]{x, y});
        }

        private double getValueD0(int structure, int dim, int index) {
            ArrayList list = this.getStructure(structure);
            Object point = list.get(index);
            return Array.getDouble(point, dim);
        }

        private float getValueF0(int structure, int dim, int index) {
            ArrayList list = this.getStructure(structure);
            Object point = list.get(index);
            return Array.getFloat(point, dim);
        }

        private int getValueI0(int structure, int dim, int index) {
            ArrayList list = this.getStructure(structure);
            Object point = list.get(index);
            return Array.getInt(point, dim);
        }

        @Override
        public GfxArray getSubArray(int fromStructure, int toStructure) {
            this.rangeCheck(fromStructure, toStructure);
            GfxArray array = null;
            ArrayList list = this.getStructure(fromStructure);
            Object point = list.get(0);
            if (point instanceof int[]) {
                array = this.commitToIntArray(fromStructure, toStructure);
            } else if (point instanceof float[]) {
                array = this.commitToFloatArray(fromStructure, toStructure);
            } else if (point instanceof double[]) {
                array = this.commitToDoubleArray(fromStructure, toStructure);
            }
            return array;
        }

        @Override
        public double[][] getStructureDvv(int structure) {
            double[][] dvv = new double[2][];
            int count = this.getValueCount(structure);
            dvv[0] = new double[count];
            dvv[1] = new double[count];
            int i = 0;
            while (i < count) {
                dvv[ArrayListMutableArray.X_DIM_INDEX][i] = this.getValueD0(structure, X_DIM_INDEX, i);
                dvv[ArrayListMutableArray.Y_DIM_INDEX][i] = this.getValueD0(structure, Y_DIM_INDEX, i);
                ++i;
            }
            return dvv;
        }

        @Override
        public double[][] getStructure2Dvv(int structure) {
            return this.getStructureDvv(structure);
        }

        @Override
        public double[][] getStructure3Dvv(int structure) {
            return this.getStructureDvv(structure);
        }

        @Override
        public double[] getPoint2Dv(int structure, int index) {
            return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index)};
        }

        @Override
        public double[] getPoint3Dv(int structure, int index) {
            return new double[]{this.getXValueD(structure, index), this.getYValueD(structure, index), this.getZValueD(structure, index)};
        }

        @Override
        public double[] getDimensionDv(int structure, GfxDimension dim) {
            int count = this.getValueCount(structure);
            double[] dv = new double[count];
            int i = 0;
            while (i < count) {
                dv[i] = this.getValueD0(structure, dim.getIndex(), i);
                ++i;
            }
            return dv;
        }

        @Override
        public double getValueD(int structure, GfxDimension dim, int index) {
            return this.getValueD0(structure, dim.getIndex(), index);
        }

        @Override
        public double getXValueD(int structure, int index) {
            return this.getValueD0(structure, X_DIM_INDEX, index);
        }

        @Override
        public double getYValueD(int structure, int index) {
            return this.getValueD0(structure, Y_DIM_INDEX, index);
        }

        @Override
        public double getZValueD(int structure, int index) {
            return this.getValueD0(structure, Z_DIM_INDEX, index);
        }

        @Override
        public float[][] getStructureFvv(int structure) {
            float[][] fvv = new float[2][];
            int count = this.getValueCount(structure);
            fvv[0] = new float[count];
            fvv[1] = new float[count];
            int i = 0;
            while (i < count) {
                fvv[ArrayListMutableArray.X_DIM_INDEX][i] = this.getValueF0(structure, X_DIM_INDEX, i);
                fvv[ArrayListMutableArray.Y_DIM_INDEX][i] = this.getValueF0(structure, Y_DIM_INDEX, i);
                ++i;
            }
            return fvv;
        }

        @Override
        public float getValueF(int structure, GfxDimension dim, int index) {
            return this.getValueF0(structure, dim.getIndex(), index);
        }

        @Override
        public float getXValueF(int structure, int index) {
            return this.getValueF0(structure, X_DIM_INDEX, index);
        }

        @Override
        public float getYValueF(int structure, int index) {
            return this.getValueF0(structure, Y_DIM_INDEX, index);
        }

        @Override
        public float getZValueF(int structure, int index) {
            return this.getValueF0(structure, Z_DIM_INDEX, index);
        }

        @Override
        public int[][] getStructureIvv(int structure) {
            int[][] ivv = new int[2][];
            int count = this.getValueCount(structure);
            ivv[0] = new int[count];
            ivv[1] = new int[count];
            int i = 0;
            while (i < count) {
                ivv[ArrayListMutableArray.X_DIM_INDEX][i] = this.getValueI0(structure, X_DIM_INDEX, i);
                ivv[ArrayListMutableArray.Y_DIM_INDEX][i] = this.getValueI0(structure, Y_DIM_INDEX, i);
                ++i;
            }
            return ivv;
        }

        @Override
        public int getValueI(int structure, GfxDimension dim, int index) {
            return this.getValueI0(structure, dim.getIndex(), index);
        }

        @Override
        public int getXValueI(int structure, int index) {
            return this.getValueI0(structure, X_DIM_INDEX, index);
        }

        @Override
        public int getYValueI(int structure, int index) {
            return this.getValueI0(structure, Y_DIM_INDEX, index);
        }

        @Override
        public int getZValueI(int structure, int index) {
            return this.getValueI0(structure, Z_DIM_INDEX, index);
        }

        @Override
        public int getStructureCount() {
            return this.structures.size();
        }

        @Override
        public int getValueCount(int structure) {
            return this.getStructure(structure).size();
        }

        @Override
        public boolean isClosed(int structure) {
            return this.closed.get(structure);
        }
    }
}

