/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics2d;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics.GfxMutableArray;
import com.maplesoft.mathdoc.model.graphics2d.G2DAttributeSet;
import com.maplesoft.mathdoc.model.graphics2d.G2DDataModel;
import java.awt.geom.AffineTransform;

public abstract class G2DAbstractModel
extends WmiAbstractModel
implements G2DDataModel {
    protected GfxArray gdata = null;

    public G2DAbstractModel(WmiMathDocumentModel doc) {
        this(doc, null);
    }

    public G2DAbstractModel(WmiMathDocumentModel doc, GfxArray data) {
        super(doc);
        this.gdata = data;
    }

    @Override
    public GfxArray getDataArrayForRead() throws WmiNoReadAccessException {
        this.verifyReadLock();
        GfxArray data = this.gdata;
        if (this.usePending()) {
            G2DAbstractModel gpending = (G2DAbstractModel)this.pending;
            if (this.pending != null && gpending.gdata != null) {
                data = gpending.gdata;
            }
        }
        return data;
    }

    @Override
    public GfxMutableArray getDataArrayForWrite() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.verifyWriteLock();
        return GfxMutableArray.createMutableInstance(this.getDataArrayForRead());
    }

    @Override
    public void setDataArray(GfxArray array) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending != null) {
            ((G2DAbstractModel)this.pending).gdata = array;
        }
    }

    @Override
    public AffineTransform get2DTransformForRead() throws WmiNoReadAccessException {
        G2DAttributeSet set = (G2DAttributeSet)this.getAttributesForRead();
        return set.getTransform();
    }

    @Override
    public void set2DTransform(AffineTransform matrix) throws WmiNoWriteAccessException {
        this.prepareForAttributeAddition();
        G2DAbstractModel gpending = (G2DAbstractModel)this.pending;
        if (gpending != null && gpending.attributes != null) {
            G2DAttributeSet set = (G2DAttributeSet)gpending.attributes;
            set.setTransform(matrix);
        }
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        if (this.pending != null) {
            this.gdata = ((G2DAbstractModel)this.pending).gdata;
        }
        super.update(undoName);
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return super.createCompatibleAttributeSet();
    }

    @Override
    public WmiUndoableEdit createUndoableEdit() {
        return super.createUndoableEdit();
    }
}

