/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics2d;

import com.maplesoft.mathdoc.model.InheritedAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiUntypedAttributeKey;
import com.maplesoft.mathdoc.model.graphics2d.G2DPaintValue;
import java.awt.geom.AffineTransform;
import java.util.HashMap;

public abstract class G2DAttributeSet
extends WmiAbstractArrayAttributeSet
implements InheritedAttributeSet {
    public static final String TRANSFORM = "transform";
    public static final String COLOR = "color";
    public static final String OUTLINE = "outline";
    public static final String FILL = "fill";
    public static final String FONT_FAMILY = "fontfamily";
    public static final String FONT_STYLE = "fontstyle";
    public static final String FONT_SIZE = "fontsize";
    public static final String LINE_STYLE = "linestyle";
    public static final String LINE_THICKNESS = "linethickness";
    public static final WmiAttributeKey TRANSFORM_KEY = new AffineTransformAttributeKey();
    public static final WmiAttributeKey COLOR_KEY = new ColorAttributeKey();
    public static final WmiAttributeKey OUTLINE_KEY = new OutlineAttributeKey();
    public static final WmiAttributeKey FILL_KEY = new FillAttributeKey();
    public static final WmiAttributeKey FONT_FAMILY_KEY = new FontFamilyAttributeKey();
    public static final WmiAttributeKey FONT_STYLE_KEY = new FontStyleAttributeKey();
    public static final WmiAttributeKey FONT_SIZE_KEY = new FontSizeAttributeKey();
    public static final WmiAttributeKey LINE_STYLE_KEY = new LineStyleAttributeKey();
    public static final WmiAttributeKey LINE_THICKNESS_KEY = new LineThicknessAttributeKey();
    private static final WmiAttributeKey[] ATTRIBUTE_KEYS = new WmiAttributeKey[]{TRANSFORM_KEY, COLOR_KEY, OUTLINE_KEY, FILL_KEY, FONT_FAMILY_KEY, FONT_STYLE_KEY, FONT_SIZE_KEY, LINE_STYLE_KEY, LINE_THICKNESS_KEY};
    private static int nextInheritanceIndex = 0;
    private AffineTransform transform;
    private String fontFamily;
    private String fontStyle;
    private int fontSize = 10;
    private int lineStyle = 1;
    private int lineThickness = 1;

    protected static synchronized int getNextIndex() {
        return nextInheritanceIndex++;
    }

    @Override
    public WmiAttributeKey[] getKeys() {
        return ATTRIBUTE_KEYS;
    }

    @Override
    public HashMap getCache() {
        return null;
    }

    @Override
    protected HashMap getKeyMap() {
        return null;
    }

    @Override
    protected void setKeyMap(HashMap map) {
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public abstract int getColor();

    public abstract void setColor(int var1);

    public abstract G2DPaintValue getFill();

    public abstract void setFill(G2DPaintValue var1);

    public abstract G2DPaintValue getOutline();

    public abstract void setOutline(G2DPaintValue var1);

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String family) {
        this.fontFamily = family;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String style) {
        this.fontStyle = style;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int thickness) {
        this.lineThickness = thickness;
    }

    public abstract boolean isInheritedByIndex(int var1);

    public abstract void setInheritedByIndex(int var1, boolean var2);

    private static final class AffineTransformAttributeKey
    extends WmiUntypedAttributeKey {
        public AffineTransformAttributeKey() {
            super(G2DAttributeSet.TRANSFORM, null);
        }

        @Override
        public Object getValue(WmiAttributeSet set) {
            return ((G2DAttributeSet)set).getTransform();
        }

        @Override
        public void setValue(WmiAttributeSet set, Object value) {
            ((G2DAttributeSet)set).setTransform((AffineTransform)value);
        }
    }

    private static class ColorAttributeKey
    extends WmiColorAttributeKey {
        private ColorAttributeKey() {
            super(G2DAttributeSet.COLOR, 0, ColorAttributeKey.getNextIndex());
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            return ((G2DAttributeSet)set).getColor();
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int color) {
            ((G2DAttributeSet)set).setColor(color);
        }

        public boolean isInherited(InheritedAttributeSet set) {
            return ((G2DAttributeSet)set).isInheritedByIndex(this.getInheritanceIndex());
        }

        public void setInheritance(InheritedAttributeSet set, boolean inherited) {
            ((G2DAttributeSet)set).setInheritedByIndex(this.getInheritanceIndex(), inherited);
        }

        @Override
        public void setValue(WmiAttributeSet set, Object value) {
            if (value instanceof Number) {
                this.setIntValue(set, ((Number)value).intValue());
            } else {
                super.setValue(set, value);
            }
        }
    }

    private static final class FillAttributeKey
    extends WmiUntypedAttributeKey {
        public FillAttributeKey() {
            super(G2DAttributeSet.FILL, null);
        }

        @Override
        public Object getValue(WmiAttributeSet set) {
            return ((G2DAttributeSet)set).getFill();
        }

        @Override
        public void setValue(WmiAttributeSet set, Object value) {
            ((G2DAttributeSet)set).setFill((G2DPaintValue)value);
        }
    }

    private static class FontFamilyAttributeKey
    extends WmiStringAttributeKey {
        private FontFamilyAttributeKey() {
            super(G2DAttributeSet.FONT_FAMILY, "", FontFamilyAttributeKey.getNextIndex());
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            String family = ((G2DAttributeSet)set).getFontFamily();
            if (family == null || family.length() == 0) {
                return this.getDefaultValue();
            }
            return family;
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String family) {
            ((G2DAttributeSet)set).setFontFamily(family);
        }

        public boolean isInherited(InheritedAttributeSet set) {
            return ((G2DAttributeSet)set).isInheritedByIndex(this.getInheritanceIndex());
        }

        public void setInheritance(InheritedAttributeSet set, boolean inherited) {
            ((G2DAttributeSet)set).setInheritedByIndex(this.getInheritanceIndex(), inherited);
        }
    }

    private static class FontSizeAttributeKey
    extends InheritedIntAttributeKey {
        private FontSizeAttributeKey() {
            super(G2DAttributeSet.FONT_SIZE, 10, FontSizeAttributeKey.getNextIndex());
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            int width = ((G2DAttributeSet)set).getFontSize();
            if (width < 0) {
                return this.getDefaultValue();
            }
            return width;
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int width) {
            ((G2DAttributeSet)set).setFontSize(width);
        }
    }

    private static class FontStyleAttributeKey
    extends WmiStringAttributeKey {
        private FontStyleAttributeKey() {
            super(G2DAttributeSet.FONT_STYLE, "", FontStyleAttributeKey.getNextIndex());
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            String style = ((G2DAttributeSet)set).getFontStyle();
            if (style == null || style.length() == 0) {
                return this.getDefaultValue();
            }
            return style;
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String style) {
            ((G2DAttributeSet)set).setFontStyle(style);
        }

        public boolean isInherited(InheritedAttributeSet set) {
            return ((G2DAttributeSet)set).isInheritedByIndex(this.getInheritanceIndex());
        }

        public void setInheritance(InheritedAttributeSet set, boolean inherited) {
            ((G2DAttributeSet)set).setInheritedByIndex(this.getInheritanceIndex(), inherited);
        }
    }

    private static abstract class InheritedIntAttributeKey
    extends WmiIntAttributeKey {
        protected InheritedIntAttributeKey(String name, int defaultValue, int inheritanceIndex) {
            super(name, defaultValue, inheritanceIndex);
        }

        public boolean isInherited(InheritedAttributeSet set) {
            return ((G2DAttributeSet)set).isInheritedByIndex(this.getInheritanceIndex());
        }

        public void setInheritance(InheritedAttributeSet set, boolean inherited) {
            ((G2DAttributeSet)set).setInheritedByIndex(this.getInheritanceIndex(), inherited);
        }
    }

    private static class LineStyleAttributeKey
    extends InheritedIntAttributeKey {
        private LineStyleAttributeKey() {
            super(G2DAttributeSet.LINE_STYLE, 0, LineStyleAttributeKey.getNextIndex());
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            int width = ((G2DAttributeSet)set).getLineStyle();
            if (width < 0) {
                return this.getDefaultValue();
            }
            return width;
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int width) {
            ((G2DAttributeSet)set).setLineStyle(width);
        }
    }

    private static class LineThicknessAttributeKey
    extends InheritedIntAttributeKey {
        private LineThicknessAttributeKey() {
            super(G2DAttributeSet.LINE_THICKNESS, 1, LineThicknessAttributeKey.getNextIndex());
        }

        @Override
        public int getIntValue(WmiAttributeSet set) {
            int width = ((G2DAttributeSet)set).getLineThickness();
            if (width < 0) {
                return this.getDefaultValue();
            }
            return width;
        }

        @Override
        public void setIntValue(WmiAttributeSet set, int width) {
            ((G2DAttributeSet)set).setLineThickness(width);
        }
    }

    private static final class OutlineAttributeKey
    extends WmiUntypedAttributeKey {
        public OutlineAttributeKey() {
            super(G2DAttributeSet.OUTLINE, null);
        }

        @Override
        public Object getValue(WmiAttributeSet set) {
            return ((G2DAttributeSet)set).getOutline();
        }

        @Override
        public void setValue(WmiAttributeSet set, Object value) {
            ((G2DAttributeSet)set).setOutline((G2DPaintValue)value);
        }
    }
}

