/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics2d;

public abstract class G2DPaintValue {
    public static final int FLAT_COLOR = 1;
    public static final int GRADIENT = 2;
    public static final int IMAGE = 3;

    public abstract int getType();

    public int getColor() {
        throw new IllegalStateException("getColor not supported on this paint value");
    }

    public int[] getGradientColors() {
        throw new IllegalStateException("getGradientColors not supported on this paint value");
    }

    public float[] getGradientPoints() {
        throw new IllegalStateException("getGradientPoints not supported on this paint value");
    }

    public byte[] getImageData() {
        throw new IllegalStateException("getImageData not supported on this paint value");
    }

    public static G2DPaintValue createFlatColorPaintValue(int color) {
        return new FlatColorValue(color);
    }

    public static G2DPaintValue createGradientPaintValue(int[] colors, float[] points) {
        return new GradientValue(colors, points);
    }

    public static G2DPaintValue createImagePaintValue(byte[] imageData) {
        return new ImageValue(imageData);
    }

    private static final class FlatColorValue
    extends G2DPaintValue {
        private int color;

        public FlatColorValue(int color) {
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    private static final class GradientValue
    extends G2DPaintValue {
        public int[] colors;
        public float[] points;

        public GradientValue(int[] colors, float[] points) {
            this.colors = colors;
            this.points = points;
        }

        @Override
        public int[] getGradientColors() {
            return this.colors;
        }

        @Override
        public float[] getGradientPoints() {
            return this.points;
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    private static final class ImageValue
    extends G2DPaintValue {
        private byte[] imageData;

        public ImageValue(byte[] imageData) {
            this.imageData = imageData;
        }

        @Override
        public byte[] getImageData() {
            return this.imageData;
        }

        @Override
        public int getType() {
            return 3;
        }
    }
}

