/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiSearchVisitor;
import com.maplesoft.util.WmiUnicodeMapper;
import java.util.ArrayList;
import java.util.Stack;

public class BracketMatcher {
    private static final int OPEN_BRACKET = 1;
    private static final int CLOSE_BRACKET = 2;
    private static final int RELATIONAL_OPERATOR = 4;
    private static final int EVAL_OPERATOR = 8;
    private static final int CONCATENATE_OPERATOR = 16;
    private static final int COLUMN_SEP_OPERATOR = 32;
    private static final int BRACKET_INDEX = 0;
    private static final int STRONG_MATCH_INDEX = 1;
    private static final int WEAK_MATCH_INDEX = 2;
    private static final int FLAGS_INDEX = 3;
    private static final int INCOMPATIBLE_BRACKETS = 0;
    private static final int STRONG_MATCH_BRACKETS = 1;
    private static final int WEAK_MATCH_BRACKETS = 2;
    private static final int NOOP_MATCH_BRACKETS = 3;
    private static final int LEFT_BIAS = 0;
    private static final int RIGHT_BIAS = 1;
    private static int[][] BRACKET_CANDIDATES;
    private static WmiUnicodeMapper candidateMap;

    static {
        int[][] nArrayArray = new int[22][];
        int[] nArray = new int[4];
        nArray[0] = 123;
        nArray[1] = 125;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 125;
        nArray2[1] = 123;
        nArray2[3] = 2;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{40, 41, 93, 1};
        nArrayArray[3] = new int[]{41, 40, 91, 2};
        nArrayArray[4] = new int[]{91, 93, 41, 1};
        nArrayArray[5] = new int[]{93, 91, 40, 2};
        nArrayArray[6] = new int[]{60, 62, 9002, 5};
        nArrayArray[7] = new int[]{62, 60, 9001, 6};
        nArrayArray[8] = new int[]{124, 124, 9122, 43};
        nArrayArray[9] = new int[]{9122, 9125, 124, 43};
        nArrayArray[10] = new int[]{9001, 9002, 62, 1};
        nArrayArray[11] = new int[]{9002, 9001, 60, 2};
        int[] nArray3 = new int[4];
        nArray3[0] = 12298;
        nArray3[1] = 12299;
        nArray3[3] = 1;
        nArrayArray[12] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 12299;
        nArray4[1] = 12298;
        nArray4[3] = 2;
        nArrayArray[13] = nArray4;
        nArrayArray[14] = new int[]{8968, 8969, 8971, 1};
        nArrayArray[15] = new int[]{8969, 8968, 8970, 2};
        nArrayArray[16] = new int[]{8970, 8971, 8969, 1};
        nArrayArray[17] = new int[]{8971, 8970, 8968, 2};
        int[] nArray5 = new int[4];
        nArray5[0] = 10214;
        nArray5[1] = 10215;
        nArray5[3] = 1;
        nArrayArray[18] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 10215;
        nArray6[1] = 10214;
        nArray6[3] = 2;
        nArrayArray[19] = nArray6;
        nArrayArray[20] = new int[]{8741, 8741, 8214, 19};
        nArrayArray[21] = new int[]{8214, 8214, 8741, 19};
        BRACKET_CANDIDATES = nArrayArray;
        candidateMap = null;
    }

    private static void initializeCandidateMap() {
        if (candidateMap == null) {
            candidateMap = new WmiUnicodeMapper();
            int i = 0;
            while (i < BRACKET_CANDIDATES.length) {
                candidateMap.put((char)BRACKET_CANDIDATES[i][0], BRACKET_CANDIDATES[i]);
                ++i;
            }
        }
    }

    public static boolean isCandidateBracket(WmiModel model) throws WmiNoReadAccessException {
        String value;
        boolean isBracket = false;
        BracketMatcher.initializeCandidateMap();
        if (model instanceof WmiMathOperatorModel && (value = ((WmiMathOperatorModel)model).getText()).length() == 1) {
            char ch = value.charAt(0);
            isBracket = candidateMap.get(ch) != null;
        }
        return isBracket;
    }

    public static WmiModelPosition matchBrackets(WmiMathModel rootModel, ArrayList scripts, WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ArrayList list = new ArrayList();
        BracketCollectionVisitor visitor = new BracketCollectionVisitor(list);
        WmiModelUtil.visitModels(rootModel, visitor);
        BracketMatcher.disambiguateCandidates(list);
        if (BracketMatcher.matchCandidates(list, scripts, pos)) {
            pos = BracketMatcher.createFenceModels(list, pos);
        }
        return pos;
    }

    private static boolean matchCandidates(ArrayList list, ArrayList scripts, WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean performMatch = true;
        boolean hasStrongMatch = false;
        boolean hasWeakMatch = false;
        boolean hasUnmatched = false;
        Stack<BracketCandidate> matcher = new Stack<BracketCandidate>();
        int size = list.size();
        int i = 0;
        while (i < size) {
            BracketCandidate candidate = (BracketCandidate)list.get(i);
            if (candidate.bracketType == 1) {
                matcher.push(candidate);
            } else if (candidate.bracketType == 2) {
                int matchType;
                BracketCandidate match = !matcher.isEmpty() ? (BracketCandidate)matcher.peek() : null;
                int n = matchType = match != null ? BracketMatcher.areCompatible(match, candidate, scripts, pos) : 0;
                if (matchType != 0) {
                    if (matchType == 1) {
                        hasStrongMatch = true;
                    } else if (matchType == 2) {
                        hasWeakMatch = true;
                    }
                    BracketMatcher.matchBrackets(match, candidate, matchType);
                    matcher.pop();
                } else {
                    matcher.clear();
                    hasUnmatched = true;
                }
            }
            ++i;
        }
        if (!matcher.isEmpty()) {
            hasUnmatched = true;
        }
        performMatch = !hasUnmatched && (hasStrongMatch || hasWeakMatch) || hasStrongMatch && !hasWeakMatch;
        return performMatch;
    }

    public static int areCompatible(BracketCandidate first, BracketCandidate second, ArrayList scripts, WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int compatible = 0;
        if (first == null || second == null) {
            return compatible;
        }
        if (first.record[1] == second.record[0]) {
            if (first.parentFence == second.parentFence) {
                compatible = 1;
                if (first.fenceBoundary && second.fenceBoundary) {
                    compatible = 3;
                } else if (first.fenceBoundary || second.fenceBoundary) {
                    compatible = 2;
                }
            } else {
                compatible = 2;
            }
        } else if (first.record[2] == second.record[0]) {
            compatible = 2;
        }
        if (!(compatible != 1 && compatible != 2 || BracketMatcher.checkStructuralCompatibility(first, second, scripts, pos))) {
            compatible = 0;
        }
        return compatible;
    }

    private static boolean checkStructuralCompatibility(BracketCandidate open, BracketCandidate close, ArrayList scripts, WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean compatible = true;
        Stack<WmiCompositeModel> openAncestors = new Stack<WmiCompositeModel>();
        Stack<WmiCompositeModel> closeAncestors = new Stack<WmiCompositeModel>();
        WmiModel model = open.fenceBoundary ? open.parentFence : open.model.getParent();
        while (model != null && model.getTag() != WmiModelTag.MATH) {
            openAncestors.push((WmiCompositeModel)model);
            model = model.getParent();
        }
        model = close.fenceBoundary ? close.parentFence : close.model.getParent();
        while (model != null && model.getTag() != WmiModelTag.MATH) {
            closeAncestors.push((WmiCompositeModel)model);
            model = model.getParent();
        }
        WmiModel commonParent = null;
        while (!openAncestors.isEmpty() && !closeAncestors.isEmpty() && openAncestors.peek() == closeAncestors.peek()) {
            commonParent = (WmiModel)openAncestors.peek();
            openAncestors.pop();
            closeAncestors.pop();
        }
        while (!openAncestors.isEmpty()) {
            model = (WmiModel)openAncestors.pop();
            WmiModelTag tag = model.getTag();
            if (tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT || tag == WmiModelTag.MATH_SUB_SUP) {
                boolean addedScript = false;
                if (!openAncestors.isEmpty()) {
                    WmiModel next = (WmiModel)openAncestors.peek();
                    if (((WmiCompositeModel)model).getChild(0) == next && scripts != null) {
                        MathTokenizer.doScriptDetachment((WmiCompositeModel)model);
                        scripts.add(model);
                        addedScript = true;
                    }
                }
                if (addedScript) continue;
                compatible = false;
                break;
            }
            if (model.getTag() == WmiModelTag.MATH_ROW || model.getTag() == WmiModelTag.MATH_FENCED) continue;
            compatible = false;
            break;
        }
        if (compatible) {
            model = close.model;
            boolean enablePromotion = pos.getModel() == model;
            WmiCompositeModel parent = close.fenceBoundary ? close.parentFence : close.model.getParent();
            while (model != commonParent) {
                WmiModelTag tag;
                WmiModelTag wmiModelTag = tag = parent != null ? parent.getTag() : null;
                if (tag == WmiModelTag.MATH_FENCED) {
                    enablePromotion = false;
                } else if (tag == WmiModelTag.MATH_ROW) {
                    if (enablePromotion) {
                        enablePromotion = parent.getChild(parent.getChildCount() - 1) == model;
                    }
                } else if (enablePromotion) {
                    if (tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT || tag == WmiModelTag.MATH_SUB_SUP) {
                        if (parent.getChild(0) == model) {
                            compatible = false;
                            break;
                        }
                    } else if (tag == WmiModelTag.MATH_SQUARE_ROOT || tag == WmiModelTag.MATH_NROOT) {
                        if (parent.getChild(0) != model) {
                            compatible = false;
                            break;
                        }
                    } else if (tag != WmiModelTag.MATH_FRAC && tag != WmiModelTag.MATH_OVER && tag != WmiModelTag.MATH_UNDER && tag != WmiModelTag.MATH_UNDER_OVER) {
                        compatible = false;
                        break;
                    }
                } else {
                    compatible = false;
                    break;
                }
                model = parent;
                parent = model.getParent();
            }
        }
        return compatible;
    }

    public static void matchBrackets(BracketCandidate first, BracketCandidate second, int type) throws WmiNoReadAccessException {
        first.match = second;
        second.match = first;
        int n = type;
        second.matchType = n;
        first.matchType = n;
    }

    private static WmiModelPosition createFenceModels(ArrayList list, WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int size = list.size();
        int i = 0;
        while (i < size) {
            BracketCandidate candidate = (BracketCandidate)list.get(i);
            if (candidate.matchType != 3) {
                BracketMatcher.expandFence(candidate, list);
            }
            ++i;
        }
        while (!list.isEmpty()) {
            BracketCandidate candidate = (BracketCandidate)list.get(0);
            BracketCandidate match = candidate.match;
            if (match != null) {
                list.remove(match);
                if (match.matchType != 3) {
                    pos = BracketMatcher.createFence(candidate, match, pos);
                }
            }
            list.remove(0);
        }
        return pos;
    }

    private static void expandFence(BracketCandidate candidate, ArrayList list) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel fence;
        if (candidate.fenceBoundary && (fence = candidate.parentFence) != null) {
            WmiModelPosition pos;
            WmiModel child;
            int size = 2 * fence.getChildCount() - 1;
            if (fence.getChildCount() == 1 && (child = fence.getChild(0)) != null && child.getTag() == WmiModelTag.MATH_ROW) {
                size = ((WmiCompositeModel)child).getChildCount();
            }
            WmiMathModel oldOpen = fence.getModelForLeft();
            WmiMathModel oldClose = fence.getModelForRight();
            if (oldOpen != null) {
                ++size;
            }
            if (oldClose != null) {
                ++size;
            }
            WmiModel newOpen = (pos = fence.convertToInlineMath(0)) != null ? pos.getModel() : null;
            WmiModel newClose = null;
            if (oldClose != null && newOpen != null) {
                WmiCompositeModel parent = newOpen.getParent();
                int index = parent.indexOf(newOpen);
                newClose = parent.getChild(index + size - 1);
            }
            if (oldOpen == null) {
                newOpen = null;
            }
            size = list.size();
            int i = 0;
            while (i < size) {
                BracketCandidate child2 = (BracketCandidate)list.get(i);
                if (child2.model == oldOpen) {
                    child2.model = (WmiMathOperatorModel)newOpen;
                    child2.parentFence = null;
                    child2.fenceBoundary = false;
                } else if (child2.model == oldClose) {
                    child2.model = (WmiMathOperatorModel)newClose;
                    child2.parentFence = null;
                    child2.fenceBoundary = false;
                }
                ++i;
            }
        }
    }

    private static WmiModelPosition createFence(BracketCandidate open, BracketCandidate close, WmiModelPosition bracketPos) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiCompositeModel closeParent;
            int closeIndex;
            int openIndex;
            WmiModelPosition closer;
            WmiModelPosition opener;
            WmiModelPosition pos;
            WmiMathOperatorModel openModel = open.model;
            WmiMathOperatorModel closeModel = close.model;
            char openCh = (char)open.record[0];
            char closeCh = (char)close.record[0];
            if (openCh == '<' || closeCh == '>') {
                BracketMatcher.updateBracket(open, '\u2329');
                BracketMatcher.updateBracket(close, '\u232a');
            }
            WmiModel wrapModel = (pos = MathInsertUtil.wrapSelection(opener = new WmiModelPosition(openModel, 0), closer = new WmiModelPosition(closeModel, -1))) != null ? pos.getModel() : null;
            WmiCompositeModel parent = wrapModel != null ? wrapModel.getParent() : null;
            int targetIndex = parent != null ? parent.indexOf(wrapModel) : -1;
            WmiMathContext context = WmiMathWrapperModel.createContext(openModel.getAttributesForRead());
            WmiCompositeModel openParent = openModel.getParent();
            int n = openIndex = openParent != null ? openParent.indexOf(openModel) : -1;
            if (openIndex >= 0) {
                openParent.removeChild(openIndex);
            }
            int n2 = closeIndex = (closeParent = closeModel.getParent()) != null ? closeParent.indexOf(closeModel) : -1;
            if (closeIndex >= 0) {
                closeParent.removeChild(closeIndex);
            }
            WmiMathDocumentModel docModel = openModel.getDocument();
            WmiModel[] empty = new WmiMathModel[]{};
            WmiMathFencedModel fence = new WmiMathFencedModel(docModel, empty, context);
            String openFence = BracketMatcher.getBracketText(openModel);
            String closeFence = BracketMatcher.getBracketText(closeModel);
            fence.addAttribute("open", openFence);
            fence.addAttribute("close", closeFence);
            if (targetIndex >= 0) {
                parent.replaceChild(fence, targetIndex);
                if (wrapModel != null) {
                    fence.addChild(wrapModel, 0);
                } else {
                    fence.addChild(WmiMathFactory.createMathIdentifierToken(fence.getDocument(), "", context), 0);
                }
            }
            if (bracketPos.getModel() == openModel) {
                bracketPos = new WmiModelPosition(fence.getChild(0), 0);
            } else if (bracketPos.getModel() == closeModel) {
                bracketPos = new WmiModelPosition(fence, -1);
            }
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return bracketPos;
    }

    private static String getBracketText(WmiTextModel bracket) throws WmiNoReadAccessException {
        String entityName;
        char ch;
        String bracketText = bracket.getText();
        if (bracketText != null && bracketText.length() == 1 && (ch = bracketText.charAt(0)) > '\u007f' && (entityName = WmiMathEntityNameMapper.getEntityName(ch)) != null) {
            bracketText = "&" + entityName + ";";
        }
        return bracketText;
    }

    private static void disambiguateCandidates(ArrayList list) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        BracketCandidate candidate;
        int vectorTally = 0;
        int absTally = 0;
        int normTally = 0;
        int size = list.size();
        ArrayList<BracketCandidate> expandList = new ArrayList<BracketCandidate>();
        int i = 0;
        while (i < size) {
            candidate = (BracketCandidate)list.get(i);
            char ch = (char)candidate.record[0];
            BracketCandidate matchBracket = BracketMatcher.findMathingFenceBoundary(list, candidate);
            switch (ch) {
                case '<': 
                case '\u2329': {
                    if (matchBracket != null) {
                        if (BracketMatcher.isBoundingOperator(candidate, 0) || BracketMatcher.isBoundingOperator(matchBracket, 1)) {
                            ++vectorTally;
                            candidate.bracketType = 1;
                            matchBracket.bracketType = 2;
                            break;
                        }
                        candidate.bracketType = 4;
                        matchBracket.bracketType = 4;
                        BracketMatcher.updateBracket(candidate, '<');
                        BracketMatcher.updateBracket(matchBracket, '>');
                        expandList.add(candidate);
                        break;
                    }
                    if (BracketMatcher.isBoundingOperator(candidate, 0)) {
                        ++vectorTally;
                        candidate.bracketType = 1;
                        break;
                    }
                    candidate.bracketType = 4;
                    BracketMatcher.updateBracket(candidate, '<');
                    break;
                }
                case '>': 
                case '\u232a': {
                    if (candidate.bracketType == 2) {
                        --vectorTally;
                    }
                    if (candidate.bracketType == 4 || matchBracket != null) break;
                    if (BracketMatcher.isBoundingOperator(candidate, 1)) {
                        --vectorTally;
                        candidate.bracketType = 2;
                        break;
                    }
                    candidate.bracketType = 4;
                    if (ch != '\u232a') break;
                    BracketMatcher.updateBracket(candidate, '>');
                    break;
                }
                case '|': {
                    if (vectorTally != 0) break;
                    if (BracketMatcher.evalTest(candidate)) {
                        candidate.bracketType = 8;
                        expandList.add(candidate);
                        break;
                    }
                    if (absTally == 0 || BracketMatcher.isBoundingOperator(candidate, 0)) {
                        ++absTally;
                        candidate.bracketType = 1;
                        break;
                    }
                    --absTally;
                    candidate.bracketType = 2;
                    break;
                }
                case '\u2016': 
                case '\u2225': {
                    if (BracketMatcher.isConcatOperator(candidate)) {
                        candidate.bracketType = 16;
                        expandList.add(candidate);
                        break;
                    }
                    if (normTally == 0 || BracketMatcher.isBoundingOperator(candidate, 0)) {
                        ++normTally;
                        candidate.bracketType = 1;
                        break;
                    }
                    --normTally;
                    candidate.bracketType = 2;
                }
            }
            ++i;
        }
        while (expandList.size() > 0) {
            BracketCandidate candidate2 = (BracketCandidate)expandList.get(0);
            expandList.remove(0);
            if (!candidate2.fenceBoundary) continue;
            WmiMathFencedModel fence = candidate2.parentFence;
            fence.convertToInlineMath(0);
            size = expandList.size();
            int i2 = size - 1;
            while (i2 >= 0) {
                candidate2 = (BracketCandidate)expandList.get(i2);
                if (candidate2.fenceBoundary && candidate2.parentFence == fence) {
                    expandList.remove(i2);
                }
                --i2;
            }
        }
        int n = 0;
        while (n < list.size()) {
            candidate = (BracketCandidate)list.get(n);
            if (candidate.bracketType != 1 && candidate.bracketType != 2) {
                list.remove(n);
                continue;
            }
            ++n;
        }
    }

    private static BracketCandidate findMathingFenceBoundary(ArrayList candidates, BracketCandidate candidate) throws WmiNoReadAccessException {
        WmiMathModel match = null;
        BracketCandidate bracket = null;
        if (candidate.fenceBoundary) {
            WmiMathFencedModel fence = candidate.parentFence;
            WmiMathModel left = fence.getModelForLeft();
            WmiMathModel right = fence.getModelForRight();
            if (left == candidate.model) {
                match = right;
            } else if (right == candidate.model) {
                match = left;
            }
        }
        if (match != null) {
            int size = candidates.size();
            int i = 0;
            while (i < size) {
                bracket = (BracketCandidate)candidates.get(i);
                if (bracket.model == match) break;
                ++i;
            }
        }
        return bracket;
    }

    private static void updateBracket(BracketCandidate candidate, char ch) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (ch != (char)candidate.record[0]) {
            WmiMathOperatorModel model = candidate.model;
            int length = model.getLength();
            try {
                ((WmiTextModel)model).replaceText(Character.toString(ch), 0, length);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    private static boolean isBoundingOperator(BracketCandidate candidate, int side) throws WmiNoReadAccessException {
        WmiCompositeModel parent;
        WmiMathFencedModel fence;
        boolean bounding = true;
        WmiModel model = candidate.model;
        if (candidate.fenceBoundary && (fence = candidate.parentFence) != null) {
            if (fence.getModelForLeft() == model && side == 0) {
                model = model.getParent();
            } else if (fence.getModelForRight() == model && side == 1) {
                model = model.getParent();
            }
        }
        if ((parent = model.getParent()) != null && parent.getTag() == WmiModelTag.MATH_ROW) {
            int index = parent.indexOf(model);
            int limit = parent.getChildCount();
            int increment = 1;
            if (side == 0) {
                increment = -1;
                limit = -1;
            }
            int i = index + increment;
            while (i != limit) {
                WmiModelTag tag;
                WmiModel child = parent.getChild(i);
                WmiModelTag wmiModelTag = tag = child != null ? child.getTag() : null;
                if (tag != WmiModelTag.MATH_SPACE) {
                    String value;
                    if (tag == WmiModelTag.MATH_OPERATOR) {
                        value = ((WmiTextModel)child).getText();
                        if (!value.equals(" ") && !value.equals("&InvisibleTimes;")) break;
                    } else if (tag == WmiModelTag.MATH_IDENTIFIER) {
                        value = ((WmiTextModel)child).getText();
                        if (!value.equals("")) {
                            bounding = false;
                            break;
                        }
                    } else {
                        bounding = false;
                        break;
                    }
                }
                i += increment;
            }
        }
        return bounding;
    }

    private static boolean evalTest(BracketCandidate candidate) throws WmiNoReadAccessException {
        boolean isEval = false;
        WmiMathOperatorModel model = candidate.model;
        WmiCompositeModel parent = model.getParent();
        if (parent != null) {
            if (parent.getTag() == WmiModelTag.MATH_ROW) {
                int index = parent.indexOf(model);
                if (index > 0 && index < parent.getChildCount() - 2) {
                    WmiModel left = parent.getChild(index - 1);
                    WmiModel right = parent.getChild(index + 1);
                    if (WmiModelUtil.findFirstDescendantOfTag(left, WmiModelTag.MATH_PHANTOM) != null && WmiModelUtil.findFirstDescendantOfTag(right, WmiModelTag.MATH_PHANTOM) != null) {
                        isEval = true;
                    }
                }
            } else if (parent.getTag() == WmiModelTag.MATH_SUBSCRIPT) {
                isEval = true;
            }
        }
        return isEval;
    }

    private static boolean isConcatOperator(BracketCandidate candidate) throws WmiNoReadAccessException {
        int index;
        boolean isConcat = false;
        WmiMathOperatorModel model = candidate.model;
        WmiCompositeModel parent = model.getParent();
        if (parent != null && parent.getTag() == WmiModelTag.MATH_ROW && (index = parent.indexOf(model)) > 0 && index < parent.getChildCount() - 2) {
            WmiModel left = parent.getChild(index - 1);
            WmiModel right = parent.getChild(index + 1);
            if (left.getTag() == WmiModelTag.MATH_IDENTIFIER && (right.getTag() == WmiModelTag.MATH_IDENTIFIER || right.getTag() == WmiModelTag.MATH_NUMERIC)) {
                isConcat = true;
            }
        }
        return isConcat;
    }

    private static class BracketCandidate {
        private WmiMathOperatorModel model;
        private WmiMathFencedModel parentFence;
        private boolean fenceBoundary;
        private int[] record;
        private BracketCandidate match;
        private int matchType;
        private int bracketType;

        private BracketCandidate(WmiMathOperatorModel model, int[] data, WmiMathFencedModel fence) throws WmiNoReadAccessException {
            this.model = model;
            this.record = data;
            this.parentFence = fence;
            this.fenceBoundary = false;
            this.bracketType = this.record[3];
            if (this.parentFence != null && (fence.getModelForLeft() == model || fence.getModelForRight() == model)) {
                this.fenceBoundary = true;
            }
        }
    }

    private static class BracketCollectionVisitor
    implements WmiSearchVisitor {
        private ArrayList list;
        private WmiMathFencedModel parentFence;

        private BracketCollectionVisitor(ArrayList list) {
            this(list, (WmiMathFencedModel)null);
        }

        private BracketCollectionVisitor(ArrayList list, WmiMathFencedModel fence) {
            this.list = list;
            this.parentFence = fence;
            BracketMatcher.initializeCandidateMap();
        }

        @Override
        public int visitMatch(Object match) {
            int success = 0;
            try {
                if (match instanceof WmiMathModel) {
                    WmiModelTag tag = ((WmiMathModel)match).getTag();
                    if (tag == WmiModelTag.MATH_OPERATOR) {
                        this.addCandidate((WmiMathOperatorModel)match, null);
                    } else if (tag == WmiModelTag.MATH_FENCED) {
                        WmiMathFencedModel fence = (WmiMathFencedModel)match;
                        WmiMathModel open = fence.getModelForLeft();
                        WmiMathModel close = fence.getModelForRight();
                        success = 1;
                        this.addCandidate(open, fence);
                        BracketCollectionVisitor visitor = new BracketCollectionVisitor(this.list, fence);
                        int size = fence.getChildCount();
                        int i = 0;
                        while (i < size) {
                            WmiModelUtil.visitModels(fence.getChild(i), visitor);
                            ++i;
                        }
                        this.addCandidate(close, fence);
                    }
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                success = 2;
            }
            return success;
        }

        private void addCandidate(WmiMathModel model, WmiMathFencedModel fence) throws WmiNoReadAccessException {
            if (model instanceof WmiMathOperatorModel) {
                if (fence == null) {
                    fence = this.parentFence;
                }
                String text = ((WmiMathOperatorModel)model).getText();
                int length = text.length();
                char ch = '\u0000';
                if (length > 1) {
                    ch = text.charAt(0);
                    if (ch == '&') {
                        MathMLEntityMap map = MathMLEntityMap.getInstance();
                        Object value = map.get(text);
                        ch = value != null ? value.toString().charAt(0) : (char)'\u0000';
                    }
                } else if (length == 1) {
                    ch = text.charAt(0);
                }
                if (ch != '\u0000') {
                    Object value = candidateMap.get(ch);
                    WmiMathDocumentModel docModel = model.getDocument();
                    if (value != null && docModel.isMutableModel(model)) {
                        int[] data = (int[])value;
                        this.list.add(new BracketCandidate((WmiMathOperatorModel)model, data, fence));
                    }
                }
            }
        }
    }
}

