/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.BracketMatcher;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiUnicodeMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MathTokenizer {
    private static HashSet kmap = new HashSet();
    private static OperatorMap omap = new OperatorMap();
    private static HashMap replaceMap = new HashMap();
    private static HashSet linebreakSet = null;

    static {
        MathTokenizer.omap.add('-');
        MathTokenizer.omap.add('+');
        MathTokenizer.omap.add('/');
        MathTokenizer.omap.add('*');
        MathTokenizer.omap.add('=');
        MathTokenizer.omap.add(':');
        MathTokenizer.omap.add(';');
        MathTokenizer.omap.add('#');
        MathTokenizer.omap.add('<');
        MathTokenizer.omap.add('>');
        MathTokenizer.omap.add('@');
        MathTokenizer.omap.add('&');
        MathTokenizer.omap.add('^');
        MathTokenizer.omap.add('[');
        MathTokenizer.omap.add(']');
        MathTokenizer.omap.add('(');
        MathTokenizer.omap.add(')');
        MathTokenizer.omap.add('{');
        MathTokenizer.omap.add('}');
        MathTokenizer.omap.add('|');
        MathTokenizer.omap.add('.');
        MathTokenizer.omap.add(',');
        MathTokenizer.omap.add('!');
        MathTokenizer.omap.add('$');
        MathTokenizer.omap.add('?');
        MathTokenizer.omap.add(' ');
        MathTokenizer.omap.add('\'');
        MathTokenizer.omap.add('\\');
        MathTokenizer.omap.add('\u00b1');
        MathTokenizer.omap.add('\u00b7', '*');
        MathTokenizer.omap.add('\u00f7', '/');
        int i = 8192;
        while (i < 8303) {
            MathTokenizer.omap.add((char)i);
            ++i;
        }
        i = 8592;
        while (i < 8959) {
            MathTokenizer.omap.add((char)i);
            ++i;
        }
        MathTokenizer.omap.add('\u231c');
        MathTokenizer.omap.add('\u231d');
        MathTokenizer.omap.add('\u231e');
        MathTokenizer.omap.add('\u231f');
        MathTokenizer.omap.add('\u25a1');
        MathTokenizer.omap.add('\u25ad');
        MathTokenizer.omap.add('\u25b1');
        MathTokenizer.omap.add('\u25b3');
        MathTokenizer.omap.add('\u25bd');
        MathTokenizer.omap.add('\u25ca');
        MathTokenizer.omap.add('\u25cb');
        MathTokenizer.omap.add('\u2993');
        MathTokenizer.omap.add('\u25c1');
        MathTokenizer.omap.add('\u25b7');
        MathTokenizer.omap.add('\u00af');
        MathTokenizer.omap.add('\ufe37');
        MathTokenizer.omap.add('\ufe38');
        MathTokenizer.omap.add('\u2927');
        MathTokenizer.omap.add('\u2928');
        MathTokenizer.omap.add('\u2929');
        MathTokenizer.omap.add('\u292a');
        MathTokenizer.omap.add('\u296e');
        MathTokenizer.omap.add('\u296f');
        MathTokenizer.omap.add('\u2905');
        MathTokenizer.omap.add('\u2936');
        MathTokenizer.omap.add('\u2937');
        MathTokenizer.omap.add('\u2923');
        MathTokenizer.omap.add('\u2924');
        MathTokenizer.omap.add('\u2926');
        MathTokenizer.omap.add('\u2925');
        MathTokenizer.omap.add('\u00ac');
        MathTokenizer.omap.add('\u2145');
        MathTokenizer.omap.add('\u29b5');
        MathTokenizer.omap.add('\u29b6');
        MathTokenizer.omap.add('\u299c');
        MathTokenizer.omap.add('\u00b4');
        MathTokenizer.omap.add('\u00b8');
        MathTokenizer.omap.add('`');
        MathTokenizer.omap.add('\u02c6');
        MathTokenizer.omap.add('\u00a8');
        MathTokenizer.omap.add('\u00a1');
        MathTokenizer.omap.add('\u00bf');
        MathTokenizer.omap.add('\u00ab');
        MathTokenizer.omap.add('\u00bb');
        MathTokenizer.omap.add('\u00af');
        MathTokenizer.omap.add('\u00b6');
        MathTokenizer.omap.add('\u00a7');
        MathTokenizer.omap.add('\u00a8');
        MathTokenizer.omap.add('\u00b0');
        MathTokenizer.omap.add('\u2713');
        MathTokenizer.omap.add('\u00a9');
        MathTokenizer.omap.add('\u00ae');
        MathTokenizer.omap.add('\u00a3');
        MathTokenizer.omap.add('\u00a4');
        MathTokenizer.omap.add('\u00a5');
        i = 10176;
        while (i < 10219) {
            MathTokenizer.omap.add((char)i);
            ++i;
        }
        i = 10752;
        while (i < 11007) {
            MathTokenizer.omap.add((char)i);
            ++i;
        }
        i = 57857;
        while (i < 57871) {
            MathTokenizer.omap.add((char)i);
            ++i;
        }
        MathTokenizer.omap.add('\u00d7');
        MathTokenizer.omap.add('\u21d2');
        MathTokenizer.omap.add('\u2329');
        MathTokenizer.omap.add('\u232a');
        MathTokenizer.omap.add('\u2308');
        MathTokenizer.omap.add('\u2309');
        MathTokenizer.omap.add('\u230a');
        MathTokenizer.omap.add('\u230b');
        MathTokenizer.omap.add('\u2192');
        MathTokenizer.omap.add('\u21cf');
        MathTokenizer.omap.add('\u300a');
        MathTokenizer.omap.add('\u300b');
        MathTokenizer.omap.add('\u301a');
        MathTokenizer.omap.add('\u301b');
        MathTokenizer.omap.add('|', '|');
        MathTokenizer.omap.add('.', '.');
        MathTokenizer.omap.add(':', '-');
        MathTokenizer.omap.add(':', '=');
        MathTokenizer.omap.add(':', ':');
        MathTokenizer.omap.add('<', '=');
        MathTokenizer.omap.add('>', '=');
        MathTokenizer.omap.add('!', '=');
        MathTokenizer.omap.add('!', '<');
        MathTokenizer.omap.add('!', '>');
        MathTokenizer.omap.add('<', '>');
        MathTokenizer.omap.add('>', '<');
        MathTokenizer.omap.add('-', '>');
        MathTokenizer.omap.add('=', '>');
        MathTokenizer.omap.add('\u2212', '>');
        MathTokenizer.omap.add('\u2260', '>');
        MathTokenizer.omap.add('\u226e', '=');
        MathTokenizer.omap.add('\u226f', '=');
        MathTokenizer.omap.add('\u2225');
        MathTokenizer.omap.add('@', '@');
        MathTokenizer.omap.add('&', '*');
        MathTokenizer.omap.add('&', '-');
        MathTokenizer.omap.add('&', '+');
        MathTokenizer.omap.add('&', '/');
        MathTokenizer.omap.add('\\', '^');
        MathTokenizer.omap.add('\\', '*');
        MathTokenizer.omap.add('\\', '\u22c5');
        MathTokenizer.omap.add('\\', '/');
        MathTokenizer.omap.add('\\', '\\');
        kmap.add("and");
        kmap.add("assuming");
        kmap.add("break");
        kmap.add("by");
        kmap.add("catch");
        kmap.add("description");
        kmap.add("do");
        kmap.add("done");
        kmap.add("elif");
        kmap.add("else");
        kmap.add("end");
        kmap.add("error");
        kmap.add("export");
        kmap.add("fi");
        kmap.add("finally");
        kmap.add("for");
        kmap.add("from");
        kmap.add("global");
        kmap.add("if");
        kmap.add("iff");
        kmap.add("implies");
        kmap.add("in");
        kmap.add("intersect");
        kmap.add("local");
        kmap.add("minus");
        kmap.add("mod");
        kmap.add("module");
        kmap.add("nand");
        kmap.add("next");
        kmap.add("nor");
        kmap.add("not");
        kmap.add("od");
        kmap.add("option");
        kmap.add("options");
        kmap.add("or");
        kmap.add("proc");
        kmap.add("quit");
        kmap.add("read");
        kmap.add("return");
        kmap.add("save");
        kmap.add("stop");
        kmap.add("subset");
        kmap.add("then");
        kmap.add("to");
        kmap.add("try");
        kmap.add("union");
        kmap.add("use");
        kmap.add("while");
        kmap.add("xor");
        replaceMap.put(":-", ":-");
        replaceMap.put("\\^", "^");
        replaceMap.put("\\_", "_");
        replaceMap.put("\\*", "*");
        replaceMap.put("\\\u22c5", "*");
        replaceMap.put("\\/", "/");
        replaceMap.put(":=", "\u2254");
        replaceMap.put("::", "\u2237");
        replaceMap.put("<=", "\u2264");
        replaceMap.put(">=", "\u2265");
        replaceMap.put("!=", "\u2260");
        replaceMap.put("!<", "\u226e");
        replaceMap.put("!>", "\u226f");
        replaceMap.put("->", "\u2192");
        replaceMap.put("\u2212>", "\u2192");
        replaceMap.put("\u226e=", "\u2270");
        replaceMap.put("\u226f=", "\u2271");
        replaceMap.put("=>", "\u21d2");
        replaceMap.put("\u2260>", "\u21cf");
        replaceMap.put("<>", "\u2260");
        replaceMap.put("..", "..");
        replaceMap.put("-", "\u2212");
        replaceMap.put("||", "\u2225");
    }

    private static int extractNumeric(String source, int startPos, int limit) {
        char ch;
        int endOffset = startPos;
        int decimal = -1;
        int exponent = -1;
        boolean foundLeadingDigits = false;
        boolean foundTrailingDigits = false;
        int lastDigit = -1;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        while (endOffset < size) {
            ch = source.charAt(endOffset);
            if (exponent == endOffset - 1 && exponent >= 0 && (ch == '+' || ch == '-' || ch == '\u2212')) {
                ++endOffset;
                continue;
            }
            if (Character.isDigit(ch)) {
                ++endOffset;
                if (exponent < 0) {
                    foundLeadingDigits = true;
                } else {
                    foundTrailingDigits = true;
                }
                lastDigit = endOffset;
                continue;
            }
            if (ch == '.' && decimal < 0) {
                decimal = endOffset++;
                lastDigit = endOffset;
                continue;
            }
            if (exponent < 0 && (ch == 'e' || ch == 'E')) {
                if (!foundLeadingDigits) break;
                exponent = endOffset++;
                continue;
            }
            if (decimal != endOffset - 1 || ch != '.') break;
            --endOffset;
            break;
        }
        if (exponent > 0 && !foundTrailingDigits) {
            endOffset = lastDigit;
        }
        if (endOffset - startPos == 1 && !Character.isDigit(source.charAt(startPos))) {
            endOffset = startPos;
        }
        if (endOffset == startPos && startPos < size && (ch = source.charAt(startPos)) >= '\u00bc' && ch <= '\u00be') {
            ++endOffset;
        }
        return endOffset - startPos;
    }

    private static int extractString(String source, int startPos, int limit) {
        int endOffset = startPos;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        if (source.charAt(endOffset) == '\"') {
            while (++endOffset < size) {
                char ch = source.charAt(endOffset);
                if (ch == '\\' && endOffset + 1 < source.length()) {
                    ++endOffset;
                }
                if (ch != '\"') continue;
                ++endOffset;
                break;
            }
        }
        return endOffset - startPos;
    }

    private static int extractVerbatim(String source, int startPos, int limit) {
        char ch;
        int endOffset = startPos;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        if ((ch = source.charAt(endOffset)) == '?' || ch == '#') {
            while (++endOffset < size) {
                ch = source.charAt(endOffset);
                if (ch == '\n') break;
            }
        }
        return endOffset - startPos;
    }

    private static int extractIdentifier(String source, int startPos, int limit) {
        int endOffset = startPos;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        block0: while (endOffset < size) {
            char ch = source.charAt(endOffset);
            if (endOffset == startPos) {
                if (Character.isDigit(ch) || ch >= '\u00bc' && ch <= '\u00be') break;
                if (ch == '\"' || ch == '`') {
                    while (++endOffset < source.length()) {
                        if (ch == '\\') {
                            if (endOffset + 1 >= source.length()) continue;
                            ++endOffset;
                            continue;
                        }
                        if (source.charAt(endOffset) != ch) continue;
                        ++endOffset;
                        break block0;
                    }
                    break;
                }
            }
            if (MathTokenizer.omap.contains(ch) || Character.isWhitespace(ch)) break;
            ++endOffset;
        }
        return endOffset - startPos;
    }

    private static int extractNewline(String source, int startPos, int limit) {
        int endOffset = startPos;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        if (endOffset < size) {
            char ch = source.charAt(endOffset);
            if (ch == '\n') {
                if (++endOffset < size && source.charAt(endOffset) == '\r') {
                    ++endOffset;
                }
            } else if (ch == '\r' && ++endOffset < size && source.charAt(endOffset) == '\n') {
                ++endOffset;
            }
        }
        return endOffset - startPos;
    }

    private static int extractOperator(String source, int startPos, int limit) {
        char c2;
        char c1;
        int endOffset = startPos;
        int size = source.length();
        if (limit >= 0 && limit < size) {
            size = limit;
        }
        if (endOffset < size && MathTokenizer.omap.contains(c1 = source.charAt(endOffset)) && ++endOffset < source.length() && MathTokenizer.omap.contains(c1, c2 = source.charAt(endOffset))) {
            ++endOffset;
        }
        if (endOffset == startPos) {
            String candidate;
            while (endOffset < source.length()) {
                char c = source.charAt(endOffset);
                if (c < 'a' || c > 'z') break;
                ++endOffset;
            }
            if (endOffset > startPos && !kmap.contains(candidate = source.substring(startPos, endOffset))) {
                endOffset = startPos;
            }
        }
        return endOffset - startPos;
    }

    public static void registerIdentifierCharacter(char c) {
        MathTokenizer.omap.remove(c);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel doc, WmiMathContext context, String contents) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return MathTokenizer.tokenize(doc, context, contents, null, null, null, false);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel doc, WmiMathContext context, String contents, String placeholder, PlaceholderFiller filler) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return MathTokenizer.tokenize(doc, context, contents, null, placeholder, filler, false);
    }

    public static WmiMathWrapperModel tokenize(WmiMathDocumentModel doc, WmiMathContext context, String contents, int[] trackingOffsetArray, String placeholder, PlaceholderFiller filler, boolean startOfRow) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean unaryMinus = startOfRow;
        int trackingOffset = trackingOffsetArray != null ? trackingOffsetArray[0] : 0;
        int offset = 0;
        int limit = -1;
        WmiMathWrapperModel wrapper = new WmiMathWrapperModel(doc);
        WmiInlineMathModel row = new WmiInlineMathModel(doc);
        wrapper.appendChild(row);
        WmiFontAttributeSet attributes = context.getStyle();
        wrapper.addAttributes(attributes);
        row.addAttributes(attributes);
        while (offset < contents.length()) {
            if (placeholder != null && filler != null) {
                limit = contents.indexOf(placeholder, offset);
            }
            if (limit == offset) {
                filler.appendPlaceholder(row);
                offset += placeholder.length();
                continue;
            }
            WmiAbstractMathTokenModel model = null;
            String value = null;
            int numericLength = MathTokenizer.extractNumeric(contents, offset, limit);
            int operatorLength = MathTokenizer.extractOperator(contents, offset, limit);
            int stringLength = MathTokenizer.extractString(contents, offset, limit);
            int verbatimLength = MathTokenizer.extractVerbatim(contents, offset, limit);
            int identifierLength = MathTokenizer.extractIdentifier(contents, offset, limit);
            int newlineLength = MathTokenizer.extractNewline(contents, offset, limit);
            int maxLength = 0;
            int adjustedLength = 0;
            boolean isString = false;
            if (verbatimLength != 0) {
                int endOffset = offset + 1;
                if (contents.startsWith("???")) {
                    endOffset += 2;
                } else if (contents.startsWith("??")) {
                    ++endOffset;
                }
                value = contents.substring(offset, endOffset);
                model = new WmiMathOperatorModel(doc, value, value, context);
                row.appendChild(model);
                value = contents.substring(endOffset, offset + verbatimLength);
                model = new WmiIdentifierModel(doc, value, value, context, false);
                adjustedLength = 1 + ((WmiTextModel)model).getLength();
                maxLength = verbatimLength;
                unaryMinus = true;
            } else if (newlineLength != 0) {
                WmiMathAttributeSet style = context.createAttributes(3);
                WmiMathSpaceModel.WmiMathSpaceAttributeSet set = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
                set.addAttributes(style);
                model = new WmiMathSpaceModel(doc, "", (WmiAttributeSet)set);
                adjustedLength = 1;
                model.addAttribute("linebreak", "newline");
                row.appendChild(model);
                model = new WmiMathSpaceModel(doc, "", (WmiAttributeSet)set);
                maxLength = newlineLength;
            } else if (stringLength != 0) {
                value = contents.substring(offset, offset + stringLength);
                if (stringLength > 1 && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1);
                    value = value.substring(0, value.length() - 1);
                    model = new WmiMathStringModel(doc, value, context);
                } else {
                    model = new WmiMathOperatorModel(doc, value, value, context);
                }
                isString = true;
                adjustedLength = ((WmiTextModel)model).getLength();
                maxLength = stringLength;
                unaryMinus = false;
            } else if (numericLength > operatorLength) {
                if (numericLength >= identifierLength) {
                    if (numericLength > 0) {
                        value = contents.substring(offset, offset + numericLength);
                        model = new WmiNumericModel(doc, value, value, context);
                        adjustedLength = ((WmiTextModel)model).getLength();
                    }
                    maxLength = numericLength;
                    unaryMinus = false;
                } else {
                    value = contents.substring(offset, offset + identifierLength);
                    model = new WmiIdentifierModel(doc, value, value, context, MathTokenizer.isMathSymbol(value));
                    adjustedLength = ((WmiTextModel)model).getLength();
                    maxLength = identifierLength;
                    unaryMinus = false;
                }
            } else if (operatorLength >= identifierLength) {
                if (operatorLength > 0) {
                    String replacementText;
                    value = contents.substring(offset, offset + operatorLength);
                    if (context.isSyntaxMappingEnabled() && (replacementText = (String)replaceMap.get(value)) != null) {
                        value = replacementText;
                    }
                    if (value.equals("\u2212")) {
                        value = unaryMinus ? "&uminus0;" : "&minus;";
                    }
                    model = new WmiMathOperatorModel(doc, value, value, context);
                    adjustedLength = ((WmiTextModel)model).getLength();
                    unaryMinus = true;
                }
                maxLength = operatorLength;
            } else {
                value = contents.substring(offset, offset + identifierLength);
                model = new WmiIdentifierModel(doc, value, value, context, MathTokenizer.isMathSymbol(value));
                maxLength = identifierLength;
                adjustedLength = ((WmiTextModel)model).getLength();
                unaryMinus = false;
            }
            if (adjustedLength != maxLength && offset < trackingOffset) {
                trackingOffset = MathTokenizer.getCorrectedOffset(value, offset, trackingOffset, isString);
            }
            if (maxLength == 0) {
                maxLength = 1;
            }
            if (model != null) {
                if (MathTokenizer.requiresImplicitMultiplication(row, model)) {
                    WmiMathOperatorModel space = new WmiMathOperatorModel(doc, " ", " ", context);
                    row.appendChild(space);
                    if (trackingOffset > offset) {
                        ++trackingOffset;
                    }
                }
                row.appendChild(model);
            }
            offset += maxLength;
        }
        if (trackingOffsetArray != null) {
            trackingOffsetArray[0] = trackingOffset;
        }
        return wrapper;
    }

    private static boolean requiresImplicitMultiplication(WmiInlineMathModel row, WmiModel candidate) throws WmiNoReadAccessException {
        int size;
        boolean addImplicit = false;
        WmiModelTag candidateTag = candidate.getTag();
        if (candidateTag == WmiModelTag.MATH_IDENTIFIER && (size = row.getChildCount()) > 0) {
            String text;
            WmiModelTag lastTag;
            WmiModel last = row.getChild(size - 1);
            WmiModelTag wmiModelTag = lastTag = last != null ? last.getTag() : null;
            if (lastTag == WmiModelTag.MATH_NUMERIC && !(text = ((WmiIdentifierModel)candidate).getAllText()).equalsIgnoreCase("e")) {
                addImplicit = true;
            }
        }
        return addImplicit;
    }

    private static int getCorrectedOffset(String value, int offset, int trackingOffset, boolean isString) {
        int limitAdjustment;
        int correctedOffset = trackingOffset;
        int n = limitAdjustment = isString ? 2 : 1;
        if (value != null) {
            int size = value.length();
            int i = 0;
            while (i < size) {
                if (offset + i >= correctedOffset - limitAdjustment) break;
                char ch = value.charAt(i);
                if (ch == '&') {
                    int startOffset = i;
                    int endOffset = -1;
                    while (++i < size) {
                        if (value.charAt(i) != ';') continue;
                        endOffset = i;
                        break;
                    }
                    if (endOffset > startOffset) {
                        String entityCandiate = value.substring(startOffset + 1, endOffset);
                        char c = WmiMathEntityNameMapper.getUnicodeCharacter(entityCandiate);
                        correctedOffset = c == '\u0000' ? (correctedOffset -= 2) : (correctedOffset -= entityCandiate.length() + 1);
                    }
                }
                ++i;
            }
        }
        return correctedOffset;
    }

    public static boolean isMathSymbol(String contents) {
        boolean isSymbol = false;
        if (contents.length() == 1) {
            char ch = contents.charAt(0);
            isSymbol = MathTokenizer.isMathSymbol(ch);
        }
        return isSymbol;
    }

    public static boolean isMathSymbol(char ch) {
        boolean isSymbol = false;
        if (ch >= '\u0370' && ch <= '\u04ff') {
            isSymbol = true;
        } else if (ch >= '\u0080' && ch <= '\u00bf') {
            isSymbol = true;
        } else if (ch >= '\u2000' && ch <= '\u206f') {
            isSymbol = true;
        } else if (ch >= '\u2100' && ch <= '\u218f') {
            isSymbol = true;
        } else if (ch >= '\u2190' && ch <= '\u22ff') {
            isSymbol = true;
        } else if (ch >= '\u2600' && ch <= '\u26ff') {
            isSymbol = true;
        } else if (ch < '\u27c0' || ch > '\u27eb') {
            if (ch >= '\u2a00' && ch <= '\u2aff') {
                isSymbol = true;
            } else if (ch >= '\u300a' && ch <= '\u300b') {
                isSymbol = true;
            } else if (ch >= '\ue000' && ch <= '\uf8ff') {
                isSymbol = true;
            }
        }
        return isSymbol;
    }

    public static WmiModelPosition retokenize(WmiTextModel text, int offset) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathTokenizer.retokenize(text, offset, true);
    }

    public static WmiModelPosition retokenize(WmiTextModel text, int offset, boolean flatten) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition pos = null;
        WmiMathWrapperModel wrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag((WmiModel)text, WmiModelTag.MATH);
        if (wrapperModel == null || MathTokenizer.isSpecialCharacterModel(text)) {
            return new WmiModelPosition(text, offset);
        }
        if (text.getTag() == WmiModelTag.MATH_TEXT && text.getLength() > 0) {
            return new WmiModelPosition(text, offset);
        }
        ArrayList scripts = MathTokenizer.detachScripts(text);
        if (flatten) {
            MathTokenizer.expandNestedRows(text);
        }
        WmiCompositeModel parent = text.getParent();
        MathTokenizer.pruneEmptyModels(parent, text);
        RetokenizeContext retokenizeContext = new RetokenizeContext();
        retokenizeContext.offset = offset;
        MathTokenizer.getAttributes(text, wrapperModel, retokenizeContext);
        String content = MathTokenizer.getContent(parent, text, retokenizeContext);
        retokenizeContext.wrapper = wrapperModel;
        MathTokenizer.doReplacement(text, parent, content, retokenizeContext);
        if (retokenizeContext.posModel != null) {
            pos = new WmiModelPosition(retokenizeContext.posModel, retokenizeContext.posOffset);
            retokenizeContext.wrapper = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(retokenizeContext.posModel, WmiModelTag.MATH);
            pos = BracketMatcher.matchBrackets(retokenizeContext.wrapper, scripts, pos);
            MathTokenizer.reattachScripts(scripts);
        }
        return pos;
    }

    private static void doReplacement(WmiTextModel text, WmiCompositeModel parent, String content, RetokenizeContext retokenizeContext) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        WmiMathContext context = WmiMathWrapperModel.createContext(text.getAttributesForRead());
        context.enableSyntaxMapping(false);
        int[] trackingOffset = new int[]{retokenizeContext.adjustedOffset};
        retokenizeContext.wrapper = MathTokenizer.tokenize(text.getDocument(), context, content.toString(), trackingOffset, null, null, retokenizeContext.startIndex == 0);
        retokenizeContext.adjustedOffset = trackingOffset[0];
        WmiCompositeModel insertParent = retokenizeContext.wrapper;
        int insertSize = insertParent.getChildCount();
        if (insertSize == 1 && retokenizeContext.wrapper.getChild(0) instanceof WmiCompositeModel) {
            insertParent = (WmiCompositeModel)retokenizeContext.wrapper.getChild(0);
            insertSize = insertParent.getChildCount();
        }
        if (insertSize == 0) {
            WmiMathDocumentModel docModel = insertParent.getDocument();
            WmiIdentifierModel emptyModel = new WmiIdentifierModel(docModel, "", "", context, false);
            insertParent.appendChild(emptyModel);
            insertSize = 1;
        }
        int semanticIndex = 0;
        int semanticCheck = 0;
        WmiModel[] replacement = new WmiModel[insertSize];
        int i = 0;
        while (i < insertSize) {
            WmiAttributeSet attrs;
            WmiModel child;
            replacement[i] = child = insertParent.getChild(i);
            int childSize = 1;
            if (!(child instanceof WmiMathSpaceModel) && child instanceof WmiTextModel) {
                WmiTextModel childText = (WmiTextModel)child;
                String value = childText.getText();
                if (!value.equals("\u2212") && child.getTag() == WmiModelTag.MATH_OPERATOR) {
                    String entity;
                    char ch;
                    String replacementText;
                    Integer semanticOffset;
                    int length = value.length();
                    boolean semanticReplacement = false;
                    if (semanticIndex < retokenizeContext.semantics.size() && (semanticOffset = (Integer)retokenizeContext.semantics.get(semanticIndex)) == semanticCheck) {
                        String valueCheck = (String)retokenizeContext.semantics.get(semanticIndex + 1);
                        if (valueCheck.equals(value)) {
                            value = (String)retokenizeContext.semantics.get(semanticIndex + 2);
                            semanticReplacement = true;
                        }
                        semanticIndex += 3;
                        childText.replaceText(value, 0, length);
                        ((WmiMathOperatorModel)childText).configureStrings(value, context);
                    }
                    if ((replacementText = (String)replaceMap.get(value)) != null) {
                        childText.replaceText(replacementText, 0, value.length());
                        retokenizeContext.adjustedOffset += replacementText.length() - length;
                        value = replacementText;
                    }
                    if (!semanticReplacement && value.length() == 1 && (ch = value.charAt(0)) > '\u007f' && (entity = MathMLEntityMap.getMathMLName(value.charAt(0))) != null) {
                        childText.replaceText("&" + entity + ";", 0, value.length());
                    }
                }
                childSize = childText.getLength();
            }
            semanticCheck += childSize;
            if (retokenizeContext.attributeMask != 0 && (attrs = child.getAttributes()) instanceof WmiFontAttributeSet) {
                WmiFontAttributeSet fontAttrs = (WmiFontAttributeSet)attrs;
                int style = fontAttrs.getExtendedStyle();
                style = style & ~retokenizeContext.attributeMask | retokenizeContext.setAttributes;
                fontAttrs.setExtendedStyle(style);
                child.setAttributes(fontAttrs);
            }
            if (childSize < retokenizeContext.adjustedOffset) {
                retokenizeContext.adjustedOffset -= childSize;
            } else if (retokenizeContext.adjustedOffset >= 0 && retokenizeContext.posModel == null) {
                retokenizeContext.posModel = child;
                retokenizeContext.posOffset = retokenizeContext.adjustedOffset;
                if (MathTokenizer.isLinebreakingMSpace(child)) {
                    retokenizeContext.posOffset = 0;
                }
            }
            ++i;
        }
        parent.replaceChildren(replacement, retokenizeContext.startIndex, retokenizeContext.endIndex - retokenizeContext.startIndex + 1);
        WmiInsertGenericMathCommand.refreshSemantics(parent);
        MathTokenizer.removeEmptyModels(parent, retokenizeContext.posModel);
    }

    private static void getAttributes(WmiTextModel text, WmiMathWrapperModel wrapperModel, RetokenizeContext retokenizeContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet attributes = text.getAttributesForRead();
        if (attributes instanceof WmiMathAttributeSet) {
            WmiMathAttributeSet mathAttrs = (WmiMathAttributeSet)attributes;
            retokenizeContext.extStyle = mathAttrs.getExtendedStyle();
            int prototype = MathTokenizer.getPrototype(text, retokenizeContext.extStyle);
            if ((retokenizeContext.extStyle & 0x800) != 0 && text.getLength() == 0) {
                WmiFontAttributeSet set = (WmiFontAttributeSet)wrapperModel.getAttributesForRead();
                text.addAttributes(set);
                prototype = retokenizeContext.extStyle = set.getExtendedStyle();
            }
            int bitMask = 39;
            retokenizeContext.attributeMask = (retokenizeContext.extStyle ^ prototype) & bitMask;
            retokenizeContext.setAttributes = retokenizeContext.extStyle & bitMask;
        }
    }

    private static String getContent(WmiCompositeModel parent, WmiTextModel text, RetokenizeContext retokenizeContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        retokenizeContext.startIndex = retokenizeContext.targetIndex = parent.indexOf(text);
        retokenizeContext.endIndex = retokenizeContext.targetIndex;
        retokenizeContext.size = parent.getChildCount();
        if (retokenizeContext.offset == -1) {
            retokenizeContext.offset = text.getLength();
        }
        if (parent.getTag() == WmiModelTag.MATH_ROW) {
            AttributeCompareContext compareContext = new AttributeCompareContext(parent, retokenizeContext.targetIndex, retokenizeContext.offset);
            compareContext.significantAttributes = retokenizeContext.attributeMask;
            while (retokenizeContext.startIndex > 0) {
                if (!MathTokenizer.compatibleAttributes(compareContext, retokenizeContext.startIndex - 1)) break;
                --retokenizeContext.startIndex;
            }
            while (retokenizeContext.endIndex < retokenizeContext.size - 1) {
                if (!MathTokenizer.compatibleAttributes(compareContext, retokenizeContext.endIndex + 1)) break;
                ++retokenizeContext.endIndex;
            }
            retokenizeContext.attributeMask = compareContext.significantAttributes;
            retokenizeContext.setAttributes &= retokenizeContext.attributeMask;
        }
        StringBuffer content = new StringBuffer();
        int i = retokenizeContext.startIndex;
        while (i <= retokenizeContext.endIndex) {
            WmiModel child = parent.getChild(i);
            if (child instanceof WmiMathSpaceModel) {
                if (MathTokenizer.isLinebreakingMSpace(child)) {
                    content.append("\n");
                } else {
                    content.append(" ");
                }
                if (i < retokenizeContext.targetIndex) {
                    ++retokenizeContext.adjustedOffset;
                }
            } else if (child instanceof WmiTextModel) {
                String semanticLabel;
                String childText = ((WmiTextModel)child).getText();
                content.append(childText);
                if (child instanceof WmiMathOperatorModel && (semanticLabel = ((WmiMathOperatorModel)child).getSemanticLabel()) != null && MathTokenizer.isValidLabel(semanticLabel, childText)) {
                    retokenizeContext.semantics.add(new Integer(retokenizeContext.adjustedOffset));
                    retokenizeContext.semantics.add(childText);
                    retokenizeContext.semantics.add(semanticLabel);
                }
                if (i < retokenizeContext.targetIndex) {
                    retokenizeContext.adjustedOffset += childText.length();
                } else if (i == retokenizeContext.targetIndex) {
                    retokenizeContext.adjustedOffset += retokenizeContext.offset;
                }
            }
            ++i;
        }
        return content.toString();
    }

    private static void removeEmptyModels(WmiCompositeModel parent, WmiModel posModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (parent.getTag() == WmiModelTag.MATH_ROW) {
            int size = parent.getChildCount();
            int i = size - 1;
            while (i >= 0) {
                WmiModel child = parent.getChild(i);
                if (size > 1 && child.getTag() == WmiModelTag.MATH_IDENTIFIER && ((WmiTextModel)child).getLength() == 0 && posModel != child) {
                    parent.removeChild(i);
                    --size;
                }
                --i;
            }
        }
    }

    private static boolean isValidLabel(String semanticLabel, String childText) {
        boolean isValid = false;
        if (semanticLabel != null && childText != null && semanticLabel.length() > 1) {
            char first = semanticLabel.charAt(0);
            char last = semanticLabel.charAt(semanticLabel.length() - 1);
            isValid = childText.length() == 1 && first == '&' && last == ';';
        }
        return isValid;
    }

    public static void retokenize(List retokenizeList) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int i = 0;
        while (i < retokenizeList.size()) {
            WmiModelPosition modelPosition = (WmiModelPosition)retokenizeList.get(i);
            WmiModel model = modelPosition.getModel();
            WmiCompositeModel parent = model.getParent();
            if (parent.indexOf(model) != -1) {
                MathTokenizer.retokenize(modelPosition);
            }
            ++i;
        }
    }

    public static WmiModelPosition retokenize(WmiPositionMarker marker) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int offset;
        WmiModelPosition pos = null;
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel model = view != null ? view.getModel() : null;
        int n = offset = marker != null ? marker.getOffset() : 0;
        if (view instanceof WmiTextView) {
            offset += ((WmiTextView)view).getStartOffset();
        }
        if (model instanceof WmiTextModel) {
            pos = MathTokenizer.retokenize((WmiTextModel)model, offset);
        } else if (model instanceof WmiCompositeModel) {
            WmiCompositeModel parent = model.getParent();
            int index = parent != null ? parent.indexOf(model) : -1;
            WmiModel child = null;
            offset = 0;
            if (index > 0 && offset == 0) {
                child = parent.getChild(index - 1);
                offset = -1;
            } else if (index < parent.getChildCount() - 1 && offset != 0) {
                child = parent.getChild(index + 1);
                offset = 0;
            }
            if (child instanceof WmiTextModel) {
                pos = MathTokenizer.retokenize((WmiTextModel)child, offset);
            }
        }
        return pos;
    }

    public static WmiModelPosition retokenize(WmiModelPosition position) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition pos = null;
        WmiModel model = position.getModel();
        int offset = position.getOffset();
        if (model instanceof WmiTextModel) {
            pos = MathTokenizer.retokenize((WmiTextModel)model, offset);
        } else if (model instanceof WmiCompositeModel) {
            WmiCompositeModel parent = model.getParent();
            int index = parent != null ? parent.indexOf(model) : -1;
            WmiModel child = null;
            offset = 0;
            if (index > 0 && offset == 0) {
                child = parent.getChild(index - 1);
                offset = -1;
            } else if (index < parent.getChildCount() - 1 && offset != 0) {
                child = parent.getChild(index + 1);
                offset = 0;
            }
            if (child instanceof WmiTextModel) {
                pos = MathTokenizer.retokenize((WmiTextModel)child, offset);
            }
        }
        return pos;
    }

    private static void expandNestedRows(WmiTextModel text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel parent = text.getParent();
        if (parent != null && parent.getTag() == WmiModelTag.MATH_ROW) {
            MathTokenizer.expandChildRows(parent);
            WmiCompositeModel grandParent = parent.getParent();
            if (grandParent != null && grandParent.getTag() == WmiModelTag.MATH_ROW) {
                MathTokenizer.expandChildRows(grandParent);
                if (grandParent.indexOf(parent) < 0) {
                    parent = grandParent;
                }
            }
        }
    }

    private static void pruneEmptyModels(WmiCompositeModel parent, WmiTextModel text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelTag tag;
        WmiModelTag wmiModelTag = tag = parent != null ? parent.getTag() : null;
        if (tag == WmiModelTag.MATH_ROW) {
            int size = parent.getChildCount();
            int i = size - 1;
            while (i >= 0) {
                if (WmiModelUtil.isEmptyModel(parent.getChild(i), text)) {
                    try {
                        parent.removeChild(i);
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                    }
                }
                --i;
            }
        }
    }

    private static void expandChildRows(WmiCompositeModel parent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int size = parent.getChildCount();
        int i = size - 1;
        while (i >= 0) {
            WmiInlineMathModel childInline;
            WmiAttributeSet set;
            WmiModel child = parent.getChild(i);
            if (child != null && child.getTag() == WmiModelTag.MATH_ROW && (set = (childInline = (WmiInlineMathModel)child).getAttributesForRead()).getAttribute("Typesetting:-msemantics") == null) {
                int childSize = childInline.getChildCount();
                WmiModel[] replacement = new WmiModel[childSize];
                int j = 0;
                while (j < childSize) {
                    replacement[j] = childInline.getChild(j);
                    ++j;
                }
                try {
                    parent.replaceChildren(replacement, i, 1);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
            --i;
        }
    }

    private static ArrayList detachScripts(WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        ArrayList list = new ArrayList();
        MathTokenizer.detachScripts(model, list);
        WmiCompositeModel parent = model.getParent();
        if (parent != null && parent.getTag() == WmiModelTag.MATH_ROW) {
            int index = parent.indexOf(model);
            int limit = parent.getChildCount();
            while (list.size() == 0 && ++index < limit) {
                MathTokenizer.detachScripts(parent.getChild(index), list);
            }
        }
        return list;
    }

    private static void detachScripts(WmiModel model, ArrayList list) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel script = null;
        if (MathTokenizer.isScript(model)) {
            script = (WmiCompositeModel)model;
            MathTokenizer.doScriptDetachment(script);
        } else {
            WmiCompositeModel parent = model.getParent();
            while (MathTokenizer.sharesCommonBaseline(model, parent)) {
                if (MathTokenizer.isScript(parent)) {
                    MathTokenizer.doScriptDetachment(parent);
                    script = parent;
                    break;
                }
                model = parent;
                parent = model.getParent();
            }
        }
        if (script != null) {
            list.add(script);
        }
    }

    private static boolean sharesCommonBaseline(WmiModel child, WmiCompositeModel parent) throws WmiNoReadAccessException {
        WmiModelTag tag;
        boolean commonBaseline = false;
        WmiModelTag wmiModelTag = tag = parent != null ? parent.getTag() : null;
        if (tag == WmiModelTag.MATH_ROW || tag == WmiModelTag.MATH_FENCED) {
            commonBaseline = true;
        } else if (tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT || tag == WmiModelTag.MATH_SUB_SUP) {
            WmiModel candidate = parent.getChild(0);
            commonBaseline = candidate == child;
        }
        return commonBaseline;
    }

    public static void doScriptDetachment(WmiCompositeModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int index;
        WmiMathDocumentModel doc = model.getDocument();
        WmiCompositeModel parent = model.getParent();
        if (!parent.getTag().equals(WmiModelTag.MATH_ROW)) {
            index = parent.indexOf(model);
            WmiInlineMathModel inline = new WmiInlineMathModel(doc);
            inline.appendChild(model);
            try {
                parent.replaceChild(inline, index);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            parent = inline;
        }
        if ((index = parent.indexOf(model)) >= 0) {
            WmiModel base = model.getChild(0);
            WmiIdentifierModel empty = new WmiIdentifierModel(model.getDocument(), "", "", (WmiFontAttributeSet)model.getAttributes(), false);
            try {
                model.replaceChild(empty, 0);
                if (!(base.getTag() != WmiModelTag.MATH_ROW || base.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && base.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune"))) {
                    WmiCompositeModel comp = (WmiCompositeModel)base;
                    int size = comp.getChildCount();
                    WmiModel[] replacement = new WmiModel[size];
                    int i = 0;
                    while (i < size) {
                        replacement[i] = comp.getChild(i);
                        ++i;
                    }
                    parent.addChildren(replacement, index);
                } else {
                    parent.addChild(base, index);
                }
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    private static boolean isScript(WmiModel model) {
        WmiModelTag tag;
        WmiModelTag wmiModelTag = tag = model != null ? model.getTag() : null;
        return tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT || tag == WmiModelTag.MATH_SUB_SUP;
    }

    private static void reattachScripts(ArrayList list) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int size = list.size();
        int i = 0;
        while (i < size) {
            WmiCompositeModel script = (WmiCompositeModel)list.get(i);
            MathTokenizer.reattachScripts(script);
            ++i;
        }
    }

    private static void reattachScripts(WmiCompositeModel script) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel parent = script.getParent();
        int index = parent.indexOf(script);
        if (index > 0) {
            WmiModel base = parent.getChild(index - 1);
            WmiCompositeModel baseParent = base.getParent();
            while (base != null && base.getTag() == WmiModelTag.MATH_ROW) {
                if (base.getAttributesForRead().getAttribute("Typesetting:-msemantics") != null && base.getAttributesForRead().getAttribute("Typesetting:-msemantics").equals("donotprune")) break;
                baseParent = (WmiCompositeModel)base;
                base = baseParent.getChild(baseParent.getChildCount() - 1);
            }
            if (base != null) {
                try {
                    baseParent.removeChild(base);
                    script.replaceChild(base, 0);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
        }
    }

    private static boolean isSpecialCharacterModel(WmiTextModel candidate) throws WmiNoReadAccessException {
        String value;
        WmiModelTag tag;
        WmiModelTag wmiModelTag = tag = candidate != null ? candidate.getTag() : null;
        if (tag == WmiModelTag.MATH_OPERATOR && (value = candidate.getText()) != null && (value.equals("d") || value.equals("e"))) {
            return true;
        }
        return tag == WmiModelTag.MATH_NUMERIC && (value = candidate.getText()) != null && (value.equals("i") || value.equals("j") || value.equals("I"));
    }

    private static boolean compatibleAttributes(AttributeCompareContext context, int candidateIndex) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String value;
        WmiModelTag tag;
        WmiModel candidate = context.parent.getChild(candidateIndex);
        WmiTextModel reference = context.reference;
        WmiModelTag wmiModelTag = tag = candidate != null ? candidate.getTag() : null;
        if (tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_OPERATOR || tag == WmiModelTag.MATH_NUMERIC || tag == WmiModelTag.MATH_STRING || tag == WmiModelTag.MATH_TEXT) {
            WmiAttributeSet candidateAttributes = candidate.getAttributesForRead();
            WmiAttributeSet referenceAttributes = reference.getAttributesForRead();
            if (candidateAttributes instanceof WmiMathAttributeSet) {
                if (candidateAttributes.getAttribute("Typesetting:-msemantics") != null) {
                    return false;
                }
                if (MathTokenizer.isSpecialCharacterModel((WmiTextModel)candidate)) {
                    return false;
                }
                if (referenceAttributes == null) {
                    reference.setAttributes(candidateAttributes);
                    return true;
                }
                if (referenceAttributes instanceof WmiMathAttributeSet) {
                    WmiMathAttributeSet refFontAttrs = (WmiMathAttributeSet)referenceAttributes;
                    WmiMathAttributeSet candidateFontAttrs = (WmiMathAttributeSet)candidateAttributes;
                    int candidateStyle = candidateFontAttrs.getExtendedStyle();
                    int candidateProto = MathTokenizer.getPrototype(candidate, candidateStyle);
                    int referenceStyle = refFontAttrs.getExtendedStyle();
                    int significantCandidateAttributes = candidateStyle ^ candidateProto;
                    int ignoreFlags = ~(context.significantAttributes | significantCandidateAttributes);
                    if (!refFontAttrs.getFamily().equals(candidateFontAttrs.getFamily())) {
                        return false;
                    }
                    if (refFontAttrs.getSize() != candidateFontAttrs.getSize()) {
                        return false;
                    }
                    int comparedFlags = ~(0x740 | ignoreFlags);
                    if (((referenceStyle ^ candidateStyle) & comparedFlags) != 0) {
                        return false;
                    }
                    if (refFontAttrs.getForeground() != candidateFontAttrs.getForeground()) {
                        return false;
                    }
                    if (refFontAttrs.isOpaque() && refFontAttrs.getBackground() != candidateFontAttrs.getBackground()) {
                        return false;
                    }
                    AttributeCompareContext attributeCompareContext = context;
                    attributeCompareContext.significantAttributes = attributeCompareContext.significantAttributes | significantCandidateAttributes;
                    return true;
                }
            }
        } else if (candidate instanceof WmiTextModel && !MathTokenizer.isLinebreakingMSpace(candidate) && ((value = ((WmiTextModel)candidate).getText()) == null || value.length() == 0)) {
            return true;
        }
        return false;
    }

    public static int getPrototype(WmiModel model, int style) throws WmiNoReadAccessException {
        return WmiAbstractMathTokenModel.getPrototype(model, style);
    }

    public static boolean isOperator(char ch) {
        return MathTokenizer.omap.contains(ch);
    }

    public static boolean isLinebreakingMSpace(WmiModel candidate) throws WmiNoReadAccessException {
        boolean match = false;
        if (candidate.getTag() == WmiModelTag.MATH_SPACE) {
            WmiMathSpaceModel.WmiMathSpaceAttributeSet set = (WmiMathSpaceModel.WmiMathSpaceAttributeSet)candidate.getAttributesForRead();
            String linebreak = set.getLinebreak();
            if (linebreakSet == null) {
                linebreakSet = new HashSet();
                linebreakSet.add("newline");
                linebreakSet.add("decreaseindentnewline");
                linebreakSet.add("increaseindentnewline");
                linebreakSet.add("indentingnewline");
                linebreakSet.add("firstprocnewline");
            }
            match = linebreakSet.contains(linebreak);
        }
        return match;
    }

    public static boolean containsOperator(String name) {
        boolean hasOperator = false;
        int len = name.length();
        int i = 0;
        while (i < len) {
            int index;
            char ch = name.charAt(i);
            if (ch == '&' && (index = name.indexOf(59, i)) >= 0) {
                String entity = name.substring(i + 1, index);
                ch = WmiMathEntityNameMapper.getUnicodeCharacter(entity);
                i = index;
            }
            if (MathTokenizer.omap.contains(ch)) {
                hasOperator = true;
                break;
            }
            ++i;
        }
        return hasOperator;
    }

    private static class AttributeCompareContext {
        private WmiTextModel reference;
        private int referenceIndex;
        private WmiCompositeModel parent;
        private int significantAttributes = 0;

        private AttributeCompareContext(WmiCompositeModel parent, int index, int offset) throws WmiNoReadAccessException {
            this.parent = parent;
            this.referenceIndex = index;
            this.reference = (WmiTextModel)parent.getChild(this.referenceIndex);
        }
    }

    private static class OperatorMap {
        private static final Object DEFAULT_OPERATOR_MARKER = Boolean.TRUE;
        private WmiUnicodeMapper operatorMapper = new WmiUnicodeMapper();

        private OperatorMap() {
        }

        private void add(char c) {
            if (this.operatorMapper.get(c) == null) {
                this.operatorMapper.put(c, DEFAULT_OPERATOR_MARKER);
            }
        }

        private void remove(char c) {
            this.operatorMapper.put(c, null);
        }

        private void add(char c1, char c2) {
            Object marker = this.operatorMapper.get(c1);
            if (marker == null || marker == DEFAULT_OPERATOR_MARKER) {
                marker = new WmiUnicodeMapper();
                this.operatorMapper.put(c1, marker);
            }
            ((WmiUnicodeMapper)marker).put(c2, DEFAULT_OPERATOR_MARKER);
        }

        private boolean contains(char c) {
            return this.operatorMapper.get(c) != null;
        }

        private boolean contains(char c1, char c2) {
            boolean found = false;
            Object mapper = this.operatorMapper.get(c1);
            if (mapper instanceof WmiUnicodeMapper) {
                found = ((WmiUnicodeMapper)mapper).get(c2) != null;
            }
            return found;
        }
    }

    public static abstract class PlaceholderFiller {
        public void appendPlaceholder(WmiInlineMathModel row) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiModel model = this.createPlaceholder(row.getDocument());
            if (model != null) {
                row.appendChild(model);
            }
        }

        public abstract WmiModel createPlaceholder(WmiMathDocumentModel var1) throws WmiNoReadAccessException, WmiNoWriteAccessException;
    }

    private static class RetokenizeContext {
        public int startIndex = 0;
        public int endIndex = 0;
        public int adjustedOffset = 0;
        public int attributeMask = 0;
        public int setAttributes = 0;
        public int extStyle = 0;
        public int targetIndex = 0;
        public int size = 0;
        public int offset = 0;
        public ArrayList semantics = new ArrayList();
        public WmiMathWrapperModel wrapper = null;
        public WmiModel posModel = null;
        public int posOffset = 0;

        private RetokenizeContext() {
        }
    }
}

