/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;

public abstract class WmiAbstractElisionBuilder
implements WmiMathModelBuilder,
WmiRenderContextAwareBuilder {
    protected static final int DEFAULT_DIGIT_ELIDETHRESHOLD = 10000;
    protected static final int DEFAULT_TERM_ELIDETHRESHOLD = 1000;
    protected static final int DEFAULT_LEFTSAMPLE = 100;
    protected static final int DEFAULT_RIGHTSAMPLE = 100;
    protected int elideThreshold = 1000;
    protected int leftSample = 100;
    protected int rightSample = 100;
    protected static final String MARKER_TERMINATION_STRING = "...]";
    protected static final String MARKER_START_STRING = "[...";

    protected WmiAbstractElisionBuilder() {
    }

    @Override
    public abstract WmiMathModel createModel(Dag var1, WmiMathDocumentModel var2, WmiMathContext var3) throws WmiNoReadAccessException, WmiNoWriteAccessException;

    @Override
    public void updateContext(DagRenderContext context) {
        this.elideThreshold = context.getInterfaceProperty(this.getElisionThresholdProperty(), this.getDefaultElideThreshold());
        this.rightSample = context.getInterfaceProperty(this.getElisionAfterProperty(), this.getDefaultLeftSample());
        this.leftSample = context.getInterfaceProperty(this.getElisionBeforeProperty(), this.getDefaultRightSample());
        if (this.elideThreshold < 0) {
            this.elideThreshold = Integer.MAX_VALUE;
        }
    }

    public boolean isElisionRequired(int length) {
        boolean useElision = false;
        if (this.elideThreshold >= 0 && this.elideThreshold < Integer.MAX_VALUE) {
            useElision = length > this.elideThreshold && length > this.leftSample + this.rightSample && this.leftSample + this.rightSample > 0 && this.leftSample < Integer.MAX_VALUE && this.rightSample < Integer.MAX_VALUE && this.rightSample > 0 && this.leftSample > 0;
        }
        return useElision;
    }

    public WmiMathModel getElisionMarker(WmiMathDocumentModel docModel, int elisionSize, WmiMathContext context) {
        WmiMathTokenModel elide = null;
        StringBuffer elText = new StringBuffer(MARKER_START_STRING);
        elText.append(elisionSize);
        elText.append(" ");
        if (elisionSize > 1) {
            elText.append(this.getElisionMarkerText());
        } else {
            elText.append(this.getSingleElisionMarkerText());
        }
        elText.append(MARKER_TERMINATION_STRING);
        elide = WmiMathFactory.createMathIdentifierToken(docModel, elText.toString(), context);
        return elide;
    }

    public abstract String getSingleElisionMarkerText();

    public abstract String getElisionMarkerText();

    protected int getDefaultLeftSample() {
        return 100;
    }

    protected int getDefaultRightSample() {
        return 100;
    }

    protected abstract String getElisionThresholdProperty();

    protected abstract String getElisionAfterProperty();

    protected abstract String getElisionBeforeProperty();

    protected abstract int getDefaultElideThreshold();
}

