/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WmiAbstractMathTokenModel
extends WmiTextModel
implements WmiMathTokenModel,
WmiFontAttributeSource,
WmiValidForTypeMK {
    private StringList strings = new StringList();
    public int alignmarkIndex = -1;
    public int alignmarkEdge = 0;
    public long modified = 0L;
    private static final Pattern SPLIT = Pattern.compile("&[^&]*?;");
    private static final Pattern GREEK_BEGIN = Pattern.compile("(.*?)\\d.*");
    public static final int UNSET = 0;
    public static final int MATH_COLOR_FLAG = 1;
    public static final int MATH_BACKGROUND_FLAG = 2;
    public static final int MATH_SIZE_FLAG = 4;
    public static final int MATH_VARIANT_FLAG = 8;
    public static final int FONT_FAMILY_FLAG = 16;
    public static final int FORM_FLAG = 32;
    public static final int FENCE_FLAG = 64;
    public static final int SEPARATOR_FLAG = 128;
    public static final int LSPACE_FLAG = 256;
    public static final int RSPACE_FLAG = 512;
    public static final int STRETCHY_FLAG = 1024;
    public static final int SYMMETRIC_FLAG = 2048;
    public static final int MAXSIZE_FLAG = 4096;
    public static final int MINSIZE_FLAG = 8192;
    public static final int LARGEOP_FLAG = 16384;
    public static final int MOVABLELIMITS_FLAG = 32768;
    public static final int ACCENT_FLAG = 65536;
    public static final int HEIGHT_FLAG = 131072;
    public static final int WIDTH_FLAG = 262144;
    public static final int DEPTH_FLAG = 524288;
    public static final int LINEBREAK_FLAG = 0x100000;
    public static final int LEFT_QUOTE_FLAG = 0x200000;
    public static final int RIGHT_QUOTE_FLAG = 0x400000;
    public static final int ALT_FLAG = 0x800000;
    public static final int INDEX_FLAG = 0x1000000;
    private static String[] ATTRIBUTE_LIST = new String[]{"mathcolor", "mathbackground", "mathsize", "mathvariant", "fontfamily", "form", "fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "maxsize", "minsize", "largeop", "movablelimits", "accent", "height", "width", "depth", "linebreak", "lquote", "rquote", "alt", "index"};
    private ArrayList glyphIndices = new ArrayList();
    private ArrayList glyphs = new ArrayList();

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel doc) {
        this(doc, null);
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel doc, String contents) {
        super(doc, null, new WmiMathAttributeSet());
        this.configureStrings(contents, new WmiMathContext(new WmiMathAttributeSet()));
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel doc, String contents, WmiAttributeSet attrs) {
        super(doc, null, (WmiFontAttributeSet)attrs);
        this.configureStrings(contents, new WmiMathContext((WmiFontAttributeSet)attrs));
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel doc, String contents, WmiAttributeSet attrs, WmiMathContext context) {
        super(doc, null, (WmiFontAttributeSet)attrs);
        this.configureStrings(contents, context);
    }

    protected WmiAbstractMathTokenModel(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        super(doc, contents, context.getStyle());
        this.configureStrings(contents, context);
    }

    public void setModifiedFlag(int flag) {
        this.modified |= (long)flag;
    }

    public void setModified(long modified) {
        this.modified = modified;
    }

    public long getModified() {
        return this.modified;
    }

    public boolean isModified(int flag) {
        return (this.modified & (long)flag) != 0L;
    }

    public void addGlyph(WmiMathGlyphModel glyph) throws WmiNoReadAccessException {
        this.glyphIndices.add(new Integer(this.getContents().length()));
        this.glyphs.add(glyph);
    }

    public int getGlyphCount() {
        return this.glyphs.size();
    }

    public ArrayList getGlyphIndices() {
        return this.glyphIndices;
    }

    public WmiMathGlyphModel getGlyph(int index) {
        return (WmiMathGlyphModel)this.glyphs.get(index);
    }

    protected void configureStrings(String contents, WmiMathContext context) {
        if (contents == null) {
            this.strings = new StringList("", context);
            return;
        }
        if (!context.isSyntaxMappingEnabled() || context.useProcRules() && !WmiAbstractMathTokenModel.isAllowedInProc(contents)) {
            this.strings = this.createStringListSplitIfNecessary(contents, context);
        } else if (contents.indexOf(38) > -1 && contents.indexOf(59) > -1) {
            String tester;
            this.strings = this instanceof WmiMathStringModel && contents.startsWith("<math") && contents.endsWith("</math>") ? new StringList(contents, context) : ((tester = contents).equals("&InvisibleTimes;") ? new InvisibleTimesStringList() : (tester.equals("&ApplyFunction;") ? new ApplyFunctionStringList() : this.createStringListSplitIfNecessary(tester, context)));
        } else if (this.enableMapleSyntaxMapping()) {
            Matcher m = null;
            if (contents.length() > 1 && Character.isLetter(contents.charAt(0))) {
                m = GREEK_BEGIN.matcher(contents);
            }
            if (m != null && m.matches()) {
                String start = m.group(1);
                String mappedStart = WmiIdentifierModel.mapString(start, context, false);
                if (!mappedStart.equals(start)) {
                    LinkedList<String> children = new LinkedList<String>();
                    children.add(mappedStart);
                    children.add(contents.substring(m.end(1)));
                    String[] s = children.toArray(new String[1]);
                    this.strings = new StringList(s, context);
                } else {
                    this.strings = new StringList(contents, context);
                }
            } else {
                this.strings = new StringList(contents, context, true);
            }
        } else {
            this.strings = new StringList(contents, context);
        }
    }

    protected StringList createStringListSplitIfNecessary(String s, WmiMathContext context) {
        if (WmiAbstractMathTokenModel.stringRequiresSplit(s)) {
            String[] array = WmiAbstractMathTokenModel.splitStrings(s);
            return new StringList(array, context);
        }
        return new StringList(s, context);
    }

    protected static boolean stringRequiresSplit(String target) {
        int indexOfSemicolon = target.indexOf(59);
        return (target.lastIndexOf(38) != 0 || indexOfSemicolon != target.length() - 1) && target.indexOf(38) >= 0 && indexOfSemicolon >= 0;
    }

    protected static String[] splitStrings(String target) {
        String[] s = null;
        if (WmiAbstractMathTokenModel.stringRequiresSplit(target)) {
            LinkedList<String> children = new LinkedList<String>();
            Matcher m = SPLIT.matcher(target);
            while (m.find()) {
                children.add(target.substring(0, m.start()));
                children.add(target.substring(m.start(), m.end()));
                target = target.substring(m.end());
                m = SPLIT.matcher(target);
            }
            children.add(target);
            s = children.toArray(new String[1]);
        } else {
            s = new String[]{target};
        }
        return s;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        this.setAttributes(set, false, null);
    }

    public void setAttributes(WmiAttributeSet set, boolean inherit, HashMap styleAttrs) throws WmiNoWriteAccessException {
        boolean opaque;
        int background;
        WmiFontAttributeSet fontAttribs;
        int foreground;
        if (set instanceof WmiFontAttributeSet && (foreground = (fontAttribs = (WmiFontAttributeSet)set).getForeground() & 0xFFFFFF) == (background = fontAttribs.getBackground() & 0xFFFFFF) && (opaque = fontAttribs.isOpaque())) {
            try {
                fontAttribs = (WmiFontAttributeSet)this.getAttributes();
                fontAttribs.setStyle(32, false);
                set = fontAttribs;
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        if (!inherit) {
            super.setAttributes(set);
        } else {
            int i = 0;
            while (i < ATTRIBUTE_LIST.length) {
                int index = 1 << i;
                String attributeName = ATTRIBUTE_LIST[i];
                if (this.isModified(index)) {
                    set.addAttribute(attributeName, this.attributes.getAttribute(attributeName));
                } else if (set instanceof WmiAbstractArrayAttributeSet && ((WmiAbstractArrayAttributeSet)set).locateKey(attributeName) != null && styleAttrs != null && styleAttrs.get(attributeName) != null) {
                    set.addAttribute(attributeName, styleAttrs.get(attributeName));
                }
                ++i;
            }
            super.setAttributes(set);
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    protected boolean enableMapleSyntaxMapping() {
        return true;
    }

    protected boolean checkForQuotes() {
        return true;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    public static boolean isAllowedInProc(String entity) {
        return entity != null && entity.startsWith("&") && entity.endsWith(";");
    }

    @Override
    public String getTokenContents() throws WmiNoReadAccessException {
        return this.getText();
    }

    public String getSemanticLabel() {
        return this.strings.toSemanticString();
    }

    public void doReplaceText(String text, int offset, int span) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiAbstractMathTokenModel) {
            WmiAbstractMathTokenModel amtpending = (WmiAbstractMathTokenModel)this.pending;
            if (amtpending.strings == this.strings || amtpending.strings == null) {
                String sourceString = this.strings.toSemanticString();
                boolean parse = !sourceString.equals(this.strings.toString());
                amtpending.strings = new StringList(sourceString, parse, parse);
            }
            amtpending.strings.replaceText(text, offset, span);
        }
    }

    @Override
    protected String getContents() throws WmiNoReadAccessException {
        String data = null;
        this.verifyReadLock();
        data = this.usePending() && this.pending instanceof WmiAbstractMathTokenModel ? ((WmiAbstractMathTokenModel)this.pending).strings.toString() : this.strings.toString();
        return data;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiTokenModelEdit edit = null;
        if (undoName != null) {
            edit = this.createMathTextEdit();
            edit.setPreupdateProperties(this.parent, this.attributes, this.strings);
        }
        if (this.pending != null) {
            this.updateValuesFromPending();
        }
        if (edit != null) {
            edit.setPostupdateProperties(this.parent, this.attributes, this.strings);
            WmiUndoManager undoManager = this.getDocument().getUndoManager();
            undoManager.addEdit(edit);
        }
        this.pending = null;
    }

    protected WmiTokenModelEdit createMathTextEdit() {
        return new WmiTokenModelEdit(this);
    }

    @Override
    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        super.updateValuesFromPending();
        this.strings = ((WmiAbstractMathTokenModel)this.pending).strings;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return null;
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        return false;
    }

    @Override
    public Dag getTypeMk() {
        return null;
    }

    @Override
    public boolean suppliesOwnTypeMK() {
        return false;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        WmiAttributeSet set = this.getAttributesForRead();
        if (set instanceof WmiFontAttributeSet) {
            int styleMask = 3;
            int style = ((WmiFontAttributeSet)set).getExtendedStyle() & styleMask;
            int defStyle = defSet.getExtendedStyle();
            defStyle &= ~styleMask;
            defSet.setExtendedStyle(defStyle |= style);
        }
        this.addAttributes(defSet);
    }

    @Override
    public void replaceText(String text, int offset, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiAttributeSet set = this.getAttributes();
            if (set instanceof WmiFontAttributeSet) {
                WmiFontAttributeSet fontAttrs = (WmiFontAttributeSet)set;
                int style = fontAttrs.getExtendedStyle();
                int prototype = WmiAbstractMathTokenModel.getPrototype(this, style);
                int significantBits = prototype ^ style;
                this.doReplaceText(text, offset, span);
                int postPrototype = WmiAbstractMathTokenModel.getPrototype(this, style);
                if (postPrototype != prototype) {
                    if (significantBits != 0) {
                        postPrototype &= ~significantBits;
                        postPrototype |= style & significantBits;
                    }
                    fontAttrs.setExtendedStyle(postPrototype);
                }
                this.setAttributes(fontAttrs);
            } else {
                this.doReplaceText(text, offset, span);
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public static int getPrototype(WmiModel model, int style) throws WmiNoReadAccessException {
        WmiModelTag tag = model.getTag();
        int prototype = style;
        if (tag == WmiModelTag.MATH_IDENTIFIER) {
            String contents = ((WmiTextModel)model).getAllText();
            int type = WmiIdentifierModel.getAppropriateAttributeCode(contents, MathTokenizer.isMathSymbol(contents));
            if (type == 0) {
                prototype = style & 0xFFFFFFDA;
                prototype |= 2;
            } else {
                prototype = style & 0xFFFFFFD8;
            }
        } else if (tag == WmiModelTag.MATH_OPERATOR) {
            String contents = ((WmiTextModel)model).getAllText();
            int type = WmiMathOperatorModel.getType(contents);
            switch (type) {
                case 3: 
                case 5: {
                    prototype = style & 0xFFFFFFD8;
                    break;
                }
                case 4: {
                    prototype = style | 1;
                    prototype &= 0xFFFFFFD9;
                }
            }
        } else if (tag == WmiModelTag.MATH_NUMERIC || tag == WmiModelTag.MATH_STRING || tag == WmiModelTag.MATH_TEXT) {
            prototype = style & 0xFFFFFFD8;
        } else if (!(model instanceof WmiCompositeModel)) {
            WmiStyleAttributeSet styleSet;
            WmiMathDocumentModel docModel = model.getDocument();
            WmiAttributeSet set = model.getAttributesForRead();
            Object styleName = set.getAttribute(WmiFontAttributeSet.STYLE_KEY);
            if (styleName != null && (styleSet = docModel.getStyle(0, styleName.toString())) instanceof WmiFontAttributeSet) {
                prototype = ((WmiFontAttributeSet)styleSet).getExtendedStyle();
            }
        }
        return prototype;
    }

    protected class ApplyFunctionStringList
    extends StringList {
        protected ApplyFunctionStringList() {
        }

        @Override
        public String toSemanticString() {
            return "&ApplyFunction;";
        }

        @Override
        public String toString() {
            return "";
        }
    }

    protected class InvisibleTimesStringList
    extends StringList {
        protected InvisibleTimesStringList() {
        }

        @Override
        public String toSemanticString() {
            return "&InvisibleTimes;";
        }

        @Override
        public String toString() {
            return " ";
        }
    }

    protected class StringList
    implements Cloneable {
        private StringListEntry root;
        private String cachedDisplayString;

        public StringList() {
        }

        public StringList(String content) {
            this.root = this.createEntry(content, false);
        }

        public StringList(String content, boolean parse) {
            this.root = this.createEntry(content, parse);
        }

        public StringList(String content, boolean parse, boolean convert) {
            this.root = this.createEntry(content, parse, convert);
        }

        public StringList(String content, WmiMathContext context) {
            this.root = this.createEntry(content, context, false);
        }

        public StringList(String[] args, WmiMathContext context) {
            this.root = this.createEntry(args, context);
        }

        public StringList(String content, WmiMathContext context, boolean parse) {
            this.root = this.createEntry(content, context, parse);
        }

        public StringList(String content, WmiMathContext context, boolean parse, boolean convert) {
            this.root = this.createEntry(content, context, parse, convert);
        }

        public StringListEntry createEntry(String text, boolean parse) {
            return this.createEntry(text, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes), parse, true);
        }

        public StringListEntry createEntry(String text, boolean parse, boolean convert) {
            return this.createEntry(text, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes), parse, convert);
        }

        public StringListEntry createEntry(String content, WmiMathContext context, boolean split) {
            return this.createEntry(content, context, split, true);
        }

        public boolean requiresQuotes(String contents) {
            int i;
            boolean quote = false;
            if (" $".equals(contents)) {
                return quote;
            }
            int length = contents.length();
            if (length > 0) {
                i = 0;
                while (i < length) {
                    if (StringTools.isWordDelimiter(contents.charAt(i))) {
                        quote = true;
                        break;
                    }
                    ++i;
                }
            }
            if (quote) {
                quote = false;
                i = 0;
                while (i < length) {
                    if (contents.charAt(i) > ' ') {
                        quote = true;
                        break;
                    }
                    ++i;
                }
            }
            if (contents.length() > 0 && contents.charAt(0) == '`' && contents.charAt(contents.length() - 1) == '`') {
                quote = false;
            }
            return quote;
        }

        public StringListEntry createEntry(String content, WmiMathContext context, boolean split, boolean convert) {
            StringListEntry returned = null;
            String testStr = content;
            if (context.useProcRules() && !WmiAbstractMathTokenModel.isAllowedInProc(testStr)) {
                testStr = content;
            } else if (content != null) {
                if (split && content.indexOf("&") > -1 && content.indexOf(";") > -1) {
                    String[] s = WmiAbstractMathTokenModel.splitStrings(content);
                    return this.createEntry(s, context);
                }
                if (convert && content.startsWith("&") && content.endsWith(";")) {
                    testStr = WmiIdentifierModel.mapString(content.substring(1, content.length() - 1), context, true);
                } else if (!context.isMaple11OrLater() || context.getTypesettingCount() == 0) {
                    String string = testStr = WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() && split ? WmiIdentifierModel.mapString(content, context, false) : content;
                    if (WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() && split) {
                        content = testStr;
                    }
                }
            }
            if (testStr != content) {
                returned = new EntityStringListEntry(content, context);
            } else {
                if (context.useProcRules() && WmiAbstractMathTokenModel.this.checkForQuotes() && this.requiresQuotes(content)) {
                    content = String.valueOf('`') + content + '`';
                }
                returned = new TextStringListEntry(content);
            }
            return returned;
        }

        public StringListEntry createEntry(String[] args) {
            return this.createEntry(args, new WmiMathContext((WmiFontAttributeSet)WmiAbstractMathTokenModel.this.attributes));
        }

        public StringListEntry createEntry(String[] args, WmiMathContext context) {
            StringListEntry first = null;
            StringListEntry current = null;
            int i = 0;
            while (i < args.length) {
                StringListEntry newEntry = this.createEntry(args[i], context, false);
                if (current != null) {
                    current.setNext(newEntry);
                }
                newEntry.setPrevious(current);
                current = newEntry;
                if (i == 0) {
                    first = current;
                }
                ++i;
            }
            return first;
        }

        public void replaceText(String text, int offset, int span) {
            if (text != null && this.cachedDisplayString != null && span == this.cachedDisplayString.length() && offset == 0 && text.equals(this.cachedDisplayString)) {
                return;
            }
            StringListEntry targetNode = null;
            StringListEntry[] targetNodes = new StringListEntry[1];
            int offsetInTarget = this.locateOffset(targetNodes, offset, span);
            targetNode = targetNodes[0];
            if (this.root == null && targetNode == null && offsetInTarget == 0) {
                this.root = targetNode = new TextStringListEntry("");
            } else if (targetNode == null && offsetInTarget == 0) {
                targetNode = this.root;
            }
            if (span > 0) {
                this.deleteSpan(targetNode, offsetInTarget, span);
            }
            if (text != null) {
                this.insertText(targetNode, text, offsetInTarget);
            }
            if (this.root == null && targetNode != null && targetNode.toString().length() > 0) {
                this.root = targetNode;
                targetNode.setPrevious(null);
            }
            this.cachedDisplayString = null;
        }

        private int locateOffset(StringListEntry[] targetNodes, int offset, int span) {
            int accumoffs = 0;
            int offsetIntoStart = offset;
            StringListEntry targetNode = this.root;
            while (targetNode != null) {
                if ((accumoffs += targetNode.getLength()) >= offset + span) {
                    offsetIntoStart -= accumoffs;
                    offsetIntoStart += targetNode.getLength();
                    break;
                }
                targetNode = targetNode.getNext();
            }
            targetNodes[0] = targetNode;
            return offsetIntoStart;
        }

        private void deleteSpan(StringListEntry targetNode, int offsetIntoStart, int span) {
            StringListEntry deleteNode = targetNode;
            if (span > 0) {
                int deleteSpan = span;
                while (deleteNode != null && deleteSpan > 0) {
                    deleteSpan -= deleteNode.deleteSpan(offsetIntoStart, deleteSpan);
                    offsetIntoStart = 0;
                    if (deleteNode.getLength() == 0) {
                        StringListEntry nextNode = deleteNode.getNext();
                        StringListEntry prevNode = deleteNode.getPrevious();
                        if (nextNode != null) {
                            nextNode.setPrevious(prevNode);
                        }
                        if (prevNode != null) {
                            prevNode.setNext(nextNode);
                        } else {
                            this.root = nextNode;
                        }
                        deleteNode.setPrevious(null);
                        deleteNode.setNext(null);
                        deleteNode = nextNode;
                        continue;
                    }
                    deleteNode = deleteNode.getNext();
                }
            }
        }

        private void insertText(StringListEntry targetNode, String text, int offsetIntoStart) {
            StringListEntry newEntry = this.createEntry(text, false);
            if (newEntry.isEntity()) {
                if (offsetIntoStart == 0) {
                    this.insertHookUp(targetNode, newEntry, offsetIntoStart);
                } else if (offsetIntoStart == targetNode.getLength()) {
                    this.insertHookUp(targetNode, newEntry, offsetIntoStart);
                } else {
                    this.splitAndInsert(targetNode, newEntry, offsetIntoStart);
                }
            } else if (targetNode != null) {
                if (targetNode.isEntity()) {
                    this.insertHookUp(targetNode, newEntry, targetNode.getLength());
                } else {
                    targetNode.join(newEntry, offsetIntoStart);
                }
            } else {
                WmiErrorLog.log(new Exception("encountered a null target node"));
            }
        }

        private void insertHookUp(StringListEntry targetNode, StringListEntry newEntry, int offsetIntoStart) {
            if (offsetIntoStart == 0) {
                StringListEntry prevNode = targetNode.getPrevious();
                if (prevNode != null) {
                    prevNode.setNext(newEntry);
                } else {
                    this.root = newEntry;
                    if (targetNode.getNext() == null && targetNode.getLength() == 0) {
                        targetNode = null;
                    }
                }
                if (targetNode != null) {
                    targetNode.setPrevious(newEntry);
                }
                newEntry.setNext(targetNode);
            } else if (offsetIntoStart == targetNode.getLength()) {
                StringListEntry nextNode = targetNode.getNext();
                targetNode.setNext(newEntry);
                newEntry.setPrevious(targetNode);
                if (nextNode != null) {
                    nextNode.setPrevious(newEntry);
                }
                newEntry.setNext(nextNode);
            }
        }

        private void splitAndInsert(StringListEntry targetNode, StringListEntry newEntry, int splitIdx) {
            targetNode = targetNode.split(splitIdx);
            StringListEntry next = targetNode.getNext();
            targetNode.setNext(newEntry);
            newEntry.setPrevious(targetNode);
            next.setPrevious(newEntry);
            newEntry.setNext(next);
        }

        public String toString() {
            if (this.cachedDisplayString == null) {
                StringListEntry entry = this.root;
                if (entry == null) {
                    this.cachedDisplayString = "";
                } else if (entry.getNext() == null) {
                    this.cachedDisplayString = entry.toString();
                } else {
                    StringBuffer buf = new StringBuffer();
                    while (entry != null) {
                        buf.append(entry.toString());
                        entry = entry.getNext();
                    }
                    this.cachedDisplayString = buf.toString();
                }
            }
            return this.cachedDisplayString;
        }

        public String toSemanticString() {
            String semanticString;
            StringListEntry entry = this.root;
            if (entry == null) {
                semanticString = "";
            } else if (entry.getNext() == null) {
                semanticString = entry.toSemanticString();
            } else {
                StringBuffer buf = new StringBuffer();
                while (entry != null) {
                    buf.append(entry.toSemanticString());
                    entry = entry.getNext();
                }
                semanticString = buf.toString();
            }
            return semanticString;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o instanceof String) {
                equals = ((String)o).equals(this.toString());
            } else if (o instanceof StringList) {
                StringList otherList = (StringList)o;
                equals = this.toString().equals(otherList.toString());
            }
            return equals;
        }

        private class EntityStringListEntry
        extends StringListEntry
        implements Cloneable {
            private String displayEntity;
            private String semanticEntity;

            public EntityStringListEntry(String content, WmiMathContext context) {
                this.semanticEntity = content;
                this.configure(context);
            }

            private void configure(WmiMathContext context) {
                if (this.semanticEntity != null) {
                    if (this.semanticEntity.startsWith("&") && this.semanticEntity.endsWith(";")) {
                        this.displayEntity = WmiIdentifierModel.mapString(this.semanticEntity.substring(1, this.semanticEntity.length() - 1), context, true);
                    } else {
                        String testStr;
                        String string = testStr = WmiAbstractMathTokenModel.this.enableMapleSyntaxMapping() ? WmiIdentifierModel.mapString(this.semanticEntity, context, false) : this.semanticEntity;
                        if (!testStr.equals(this.semanticEntity)) {
                            this.displayEntity = testStr;
                        }
                    }
                }
            }

            @Override
            public boolean isEntity() {
                return true;
            }

            public String toString() {
                return this.displayEntity == null ? "" : this.displayEntity;
            }

            @Override
            public String toSemanticString() {
                return this.semanticEntity;
            }

            @Override
            public int getLength() {
                return this.displayEntity == null ? 0 : this.displayEntity.length();
            }

            @Override
            public void appendText(String appendedText) {
            }

            @Override
            public int deleteSpan(int offset, int span) {
                int deleted = this.displayEntity == null ? 0 : this.displayEntity.length();
                this.displayEntity = null;
                this.semanticEntity = null;
                return deleted;
            }

            @Override
            public StringListEntry split(int targetLocation) {
                return null;
            }

            @Override
            public void join(StringListEntry newMember, int offset) {
            }
        }

        private abstract class StringListEntry
        implements Cloneable {
            private StringListEntry previous;
            private StringListEntry next;

            private StringListEntry() {
            }

            public void setPrevious(StringListEntry previous) {
                this.previous = previous;
            }

            public void setNext(StringListEntry next) {
                this.next = next;
            }

            public StringListEntry getNext() {
                return this.next;
            }

            public StringListEntry getPrevious() {
                return this.previous;
            }

            public abstract int getLength();

            public abstract boolean isEntity();

            public abstract String toSemanticString();

            public abstract void appendText(String var1);

            public abstract int deleteSpan(int var1, int var2);

            public abstract StringListEntry split(int var1);

            public abstract void join(StringListEntry var1, int var2);
        }

        private class TextStringListEntry
        extends StringListEntry
        implements Cloneable {
            private String text;

            public TextStringListEntry(String text) {
                this.text = text;
            }

            @Override
            public boolean isEntity() {
                return false;
            }

            public String toString() {
                return this.text;
            }

            @Override
            public String toSemanticString() {
                return this.text;
            }

            @Override
            public int getLength() {
                return this.text.length();
            }

            @Override
            public void appendText(String appendedText) {
                this.text = this.text != null ? String.valueOf(this.text) + appendedText : appendedText;
            }

            @Override
            public int deleteSpan(int offset, int span) {
                int deleted = 0;
                if (offset + span < this.text.length()) {
                    if (offset == 0) {
                        this.text = this.text.substring(span);
                        deleted = span;
                    } else if (offset == this.text.length() - 1) {
                        this.text = this.text.substring(0, offset);
                        deleted = span;
                    } else if (offset < 0) {
                        this.text = this.text.substring(span + offset);
                        deleted = span + offset;
                    } else {
                        this.text = String.valueOf(this.text.substring(0, offset)) + this.text.substring(offset + span);
                        deleted = span;
                    }
                } else {
                    deleted = this.text.length() - offset;
                    deleted = deleted == 0 ? 1 : deleted;
                    this.text = this.text.substring(0, offset);
                }
                return deleted;
            }

            @Override
            public StringListEntry split(int targetLocation) {
                String first = this.text.substring(0, targetLocation);
                String last = this.text.substring(targetLocation);
                TextStringListEntry firstNewEntry = new TextStringListEntry(first);
                TextStringListEntry lastNewEntry = new TextStringListEntry(last);
                StringListEntry leadNode = this.getPrevious();
                StringListEntry endNode = this.getNext();
                if (leadNode != null) {
                    leadNode.setNext(firstNewEntry);
                } else {
                    StringList.this.root = firstNewEntry;
                }
                firstNewEntry.setPrevious(leadNode);
                firstNewEntry.setNext(lastNewEntry);
                lastNewEntry.setPrevious(firstNewEntry);
                lastNewEntry.setNext(endNode);
                if (endNode != null) {
                    endNode.setPrevious(lastNewEntry);
                }
                return firstNewEntry;
            }

            @Override
            public void join(StringListEntry newMember, int offset) {
                StringBuffer newText = new StringBuffer(this.text.substring(0, offset));
                newText.append(newMember.toString());
                newText.append(this.text.substring(offset));
                this.text = newText.toString();
            }
        }
    }

    protected static class WmiTokenModelEdit
    extends WmiTextModel.WmiTextModelEdit {
        protected StringList editStrings;
        protected StringList oldStrings;

        protected WmiTokenModelEdit(WmiAbstractMathTokenModel model) {
            super(model);
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            ((WmiAbstractMathTokenModel)this.model).strings = this.oldStrings;
            super.undo();
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            ((WmiAbstractMathTokenModel)this.model).strings = this.editStrings;
            super.redo();
        }

        protected void setPreupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, StringList strings) {
            super.setPreupdateProperties(parent, attributes, null);
            this.oldStrings = strings;
        }

        protected void setPostupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, StringList strings) {
            super.setPostupdateProperties(parent, attributes, null);
            this.editStrings = strings;
        }
    }
}

