/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTableBuilder;
import java.util.ArrayList;

public abstract class WmiCollectionBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String COMMA_OPERATOR = ",";
    public static final String LIST_BRACKET_LEFT = "[";
    public static final String LIST_BRACKET_RIGHT = "]";
    public static final String ARGS_BRACKET_LEFT = "(";
    public static final String ARGS_BRACKET_RIGHT = ")";
    public static final String SET_BRACKET_LEFT = "{";
    public static final String SET_BRACKET_RIGHT = "}";

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag attributes;
        WmiMathModel model = null;
        boolean isMatrix = false;
        if (dag.getType() == 30 && (attributes = dag.getAttributes()) != null) {
            String contents = attributes.getData();
            if (context != null && contents.equals("matrix")) {
                isMatrix = true;
            }
        }
        if (isMatrix && (model = WmiTableBuilder.buildMatrix(docModel, dag, context)) == null) {
            isMatrix = false;
        }
        if (!isMatrix) {
            model = new WmiInlineMathModel(docModel);
            WmiAbstractArrayCompositeModel composite = (WmiAbstractArrayCompositeModel)((Object)model);
            int numberItems = dag.getLength();
            int lastItemIndex = numberItems - 1;
            if (numberItems > 0) {
                int i = 0;
                while (i < lastItemIndex) {
                    Dag childDag = dag.getChild(i);
                    WmiMathModel childModel = WmiMathFactory.createMath(docModel, childDag, context);
                    composite.appendChild(childModel);
                    composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, COMMA_OPERATOR, context));
                    ++i;
                }
                WmiMathModel childModel = WmiMathFactory.createMath(docModel, dag.getChild(lastItemIndex), context);
                composite.appendChild(childModel);
            } else {
                composite.appendChild(WmiMathFactory.createMathIdentifierToken(docModel, "", context));
            }
            model.setSemantics(this);
            if (this.hasBrackets()) {
                model = WmiMathFactory.addBrackets(model, this.getLeftBracket(), this.getRightBracket(), context);
                model.setSemantics(this);
            }
        }
        return model;
    }

    public abstract String getLeftBracket();

    public abstract String getRightBracket();

    public abstract int getDagType();

    public boolean hasBrackets() {
        return true;
    }

    private boolean isBracketed(WmiMathModel model) throws WmiNoReadAccessException {
        boolean bracketed = false;
        if (this.hasBrackets()) {
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            int size = composite.getChildCount();
            WmiModel firstChild = composite.getChild(0);
            WmiModel lastChild = composite.getChild(size - 1);
            if (firstChild instanceof WmiMathOperatorModel && lastChild instanceof WmiMathOperatorModel) {
                WmiMathOperatorModel firstOp = (WmiMathOperatorModel)firstChild;
                WmiMathOperatorModel lastOp = (WmiMathOperatorModel)lastChild;
                String firstChar = firstOp.getText();
                String lastChar = lastOp.getText();
                if (firstChar.equals(this.getLeftBracket()) && lastChar.equals(this.getRightBracket())) {
                    bracketed = true;
                }
            }
        }
        return bracketed;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
        int size = composite.getChildCount();
        int i = this.isBracketed(model) ? 1 : 0;
        ArrayList<Dag> childList = new ArrayList<Dag>();
        while (i < size) {
            WmiModel kid = composite.getChild(i);
            WmiMathModel child = (WmiMathModel)kid;
            boolean addChild = true;
            if (WmiModelUtil.isEmptyIdentifierModel(child)) {
                addChild = false;
            }
            if (child instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)child).getContents().trim().equals(COMMA_OPERATOR)) {
                addChild = false;
            }
            if (addChild) {
                childList.add(child.toDag());
            }
            ++i;
        }
        Dag[] children = childList.toArray(new Dag[0]);
        WmiSemanticDagUtil.fillNullDags(children);
        if (children.length == 2 && this.isBracketed(model)) {
            return children[0];
        }
        return Dag.createDag(this.getDagType(), children, null, false);
    }

    public static class WmiArgsModelBuilder
    extends WmiListModelBuilder {
        @Override
        public String getLeftBracket() {
            return WmiCollectionBuilder.ARGS_BRACKET_LEFT;
        }

        @Override
        public String getRightBracket() {
            return WmiCollectionBuilder.ARGS_BRACKET_RIGHT;
        }
    }

    public static class WmiExpSequenceModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "expseq";

        @Override
        public boolean hasBrackets() {
            return false;
        }

        @Override
        public String getLeftBracket() {
            return null;
        }

        @Override
        public String getRightBracket() {
            return null;
        }

        @Override
        public int getDagType() {
            return 29;
        }
    }

    public static class WmiListModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "list";

        @Override
        public String getLeftBracket() {
            return WmiCollectionBuilder.LIST_BRACKET_LEFT;
        }

        @Override
        public String getRightBracket() {
            return WmiCollectionBuilder.LIST_BRACKET_RIGHT;
        }

        @Override
        public int getDagType() {
            return 30;
        }
    }

    public static class WmiSetModelBuilder
    extends WmiCollectionBuilder {
        protected static final String LINEBREAK_CONTEXT_NAME = "set";

        @Override
        public String getLeftBracket() {
            return WmiCollectionBuilder.SET_BRACKET_LEFT;
        }

        @Override
        public String getRightBracket() {
            return WmiCollectionBuilder.SET_BRACKET_RIGHT;
        }

        @Override
        public int getDagType() {
            return 36;
        }
    }
}

