/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiTwoArgumentMathModel;
import java.util.HashMap;

public class WmiFractionModel
extends WmiTwoArgumentMathModel
implements WmiMathModel {
    private static final WmiImpliedSemantics IMPLIED_FRACTION_SEMANTICS = new WmiImpliedSemantics();
    public static final int NUMERATOR_INDEX = 0;
    public static final int DENOMINATOR_INDEX = 1;

    private WmiFractionModel(WmiFractionModel source) throws WmiNoReadAccessException {
        super(source.getDocument());
        this.children[1] = source.getChild(1);
        WmiFractionAttributeSet newAttr = (WmiFractionAttributeSet)source.getAttributes().copyAttributes();
        newAttr.setStyle(128, true);
        this.attributes = newAttr;
        this.children[0] = new WmiNumericModel(source.getDocument(), "1", "1", new WmiMathContext((WmiFractionAttributeSet)newAttr.copyAttributes()));
        this.parent = source;
    }

    public WmiFractionModel(WmiMathDocumentModel docModel, WmiModel numerator, WmiModel denominator, WmiMathContext context) throws WmiNoWriteAccessException {
        super(docModel, numerator, denominator);
        this.setAttributes(context.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public WmiFractionModel(WmiMathDocumentModel docModel, WmiMathModel[] kids, WmiMathContext context) {
        super(docModel);
        this.children = kids;
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(context.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public WmiFractionModel(WmiMathDocumentModel docModel, WmiMathContext context) {
        super(docModel);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(context.createAttributes(2));
        this.setSemantics(IMPLIED_FRACTION_SEMANTICS);
    }

    public static WmiFractionModel createDenominatorModel(WmiFractionModel source) throws WmiNoReadAccessException {
        return new WmiFractionModel(source);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_FRAC;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFractionAttributeSet();
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        WmiMathSemantics semantics = this.getSemantics();
        return semantics != null ? semantics.toDag(this) : null;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiFractionDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    public static class WmiFractionAttributeSet
    extends WmiMathAttributeSet {
        public static final String LINE_THICKNESS = "linethickness";
        public static final String DENOMINATOR_ALIGNMENT = "denomalign";
        public static final String NUMERATOR_ALIGNMENT = "numalign";
        public static final String BEVELLED = "bevelled";
        public static final String[] ATTR_NAMES = new String[]{"linethickness", "denomalign", "numalign", "bevelled", "foreground", "background"};
        public static final String ALIGN_LEFT = "left";
        public static final String ALIGN_CENTER = "center";
        public static final String ALIGN_RIGHT = "right";
        public static final String[] ALIGNMENT_OPTIONS = new String[]{"left", "center", "right"};
        public static final int DEFAULT_ALIGNMENT = 1;
        public static final String LINE_THICKNESS_THIN = "thin";
        public static final String LINE_THICKNESS_MEDIUM = "medium";
        public static final String LINE_THICKNESS_THICK = "thick";
        private static final int DEFAULT_LINE_THICKNESS = 1;
        private static final boolean DEFAULT_BEVEL = false;
        public static final WmiAttributeKey[] FRACTION_KEYS = new WmiAttributeKey[]{new NumeratorAlignmentKey(), new DenominatorAlignmentKey(), new BevelKey(), new ThicknessKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_FRAC = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), FRACTION_KEYS);
        private static final int BEVEL_HASH_BIT = 128;
        private static HashMap keyMap;
        private static HashMap cache;
        private int linethickness = 1;
        private int denomalign = 1;
        private int numalign = 1;
        private boolean isBevelled = false;

        public WmiFractionAttributeSet() {
        }

        public WmiFractionAttributeSet(WmiFractionAttributeSet attributes) {
            super(attributes);
            this.denomalign = attributes.denomalign;
            this.numalign = attributes.numalign;
            this.linethickness = attributes.linethickness;
            this.isBevelled = attributes.isBevelled;
        }

        public WmiFractionAttributeSet(String styleName) {
            super.setFontStyleName(styleName);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiFractionAttributeSet) {
                WmiFractionAttributeSet source = (WmiFractionAttributeSet)set;
                this.denomalign = source.denomalign;
                this.numalign = source.numalign;
                this.linethickness = source.linethickness;
                this.isBevelled = source.isBevelled;
            }
        }

        public boolean isBevelled() {
            return this.isBevelled;
        }

        public int getLineThickness() {
            return this.linethickness;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiFractionAttributeSet(this);
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiFractionAttributeSet) {
                WmiFractionAttributeSet ref = (WmiFractionAttributeSet)obj;
                equals = ref.linethickness == this.linethickness && ref.isBevelled == this.isBevelled && ref.numalign == this.numalign && ref.denomalign == this.denomalign;
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.numalign;
            code ^= this.denomalign;
            code ^= this.linethickness;
            if (this.isBevelled) {
                code ^= 0x80;
            }
            return code;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_FRAC;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class BevelKey
        extends WmiBooleanAttributeKey {
            public BevelKey() {
                super(WmiFractionAttributeSet.BEVELLED, false);
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return ((WmiFractionAttributeSet)set).isBevelled;
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                ((WmiFractionAttributeSet)set).isBevelled = value;
            }
        }

        public static class DenominatorAlignmentKey
        extends WmiEnumeratedAttributeKey {
            public DenominatorAlignmentKey() {
                super(WmiFractionAttributeSet.DENOMINATOR_ALIGNMENT, ALIGNMENT_OPTIONS, 1);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiFractionAttributeSet)set).denomalign;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiFractionAttributeSet)set).denomalign = value;
            }
        }

        public static class NumeratorAlignmentKey
        extends WmiEnumeratedAttributeKey {
            public NumeratorAlignmentKey() {
                super(WmiFractionAttributeSet.NUMERATOR_ALIGNMENT, ALIGNMENT_OPTIONS, 1);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiFractionAttributeSet)set).numalign;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiFractionAttributeSet)set).numalign = value;
            }
        }

        public static class ThicknessKey
        extends WmiIntAttributeKey {
            protected ThicknessKey() {
                super(WmiFractionAttributeSet.LINE_THICKNESS, 1);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiFractionAttributeSet)set).linethickness;
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiFractionAttributeSet)set).linethickness = value;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                int iValue = 1;
                if (value != null) {
                    if (value.equals(WmiFractionAttributeSet.LINE_THICKNESS_THIN)) {
                        iValue = 1;
                    } else if (value.equals(WmiFractionAttributeSet.LINE_THICKNESS_MEDIUM)) {
                        iValue = 2;
                    } else if (value.equals(WmiFractionAttributeSet.LINE_THICKNESS_THICK)) {
                        iValue = 3;
                    } else {
                        try {
                            iValue = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                this.setIntValue(set, iValue);
            }
        }
    }

    public class WmiFractionDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        WmiFractionDeleteHandler(WmiFractionModel arg) {
            this.model = arg;
        }

        @Override
        protected void processRestructure(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel restructured = null;
                WmiCompositeModel myParent = WmiFractionModel.this.getParent();
                int index = myParent.indexOf(this.model);
                if (WmiFractionModel.this.getChild(0) instanceof WmiDeletePlaceholderModel) {
                    restructured = WmiFractionModel.this.getChild(1);
                    myParent.replaceChild(restructured, index);
                    if (restructured instanceof WmiCompositeModel) {
                        WmiModelPath leafPath = WmiModelUtil.mapBeginningOfCompositeModel((WmiCompositeModel)restructured);
                        WmiModelPosition leaf = leafPath.getModelPosition(restructured.getDocument());
                        manager.setModelToReposition(leaf);
                    } else if (restructured instanceof WmiTextModel) {
                        manager.setModelToReposition(new WmiModelPosition(restructured, 0));
                    }
                } else if (WmiFractionModel.this.getChild(1) instanceof WmiDeletePlaceholderModel) {
                    restructured = WmiFractionModel.this.getChild(0);
                    myParent.replaceChild(restructured, index);
                    if (restructured instanceof WmiCompositeModel) {
                        WmiModelPath leafPath = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)restructured);
                        WmiModelPosition leaf = leafPath.getModelPosition(restructured.getDocument());
                        manager.setModelToReposition(leaf);
                    } else if (restructured instanceof WmiTextModel) {
                        WmiTextModel textModel = (WmiTextModel)restructured;
                        int modelLength = textModel.getLength();
                        manager.setModelToReposition(new WmiModelPosition(restructured, modelLength));
                    }
                }
            }
        }
    }
}

