/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;

public class WmiHashTableBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final String ROW_LEAD_CHARACTERS = "#(";
    private static final String ROW_MIDDLE_CHARACTERS = ") = ";
    private static final String LINEBREAK_CONTEXT_NAME = "hashtable";

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel tableModel = null;
        int dagLength = dag.getLength();
        WmiModel[] children = new WmiMathModel[dagLength / 2];
        int addIndex = 0;
        int i = 0;
        while (i < dagLength - 1) {
            Dag key = dag.getChild(i);
            Dag value = dag.getChild(i + 1);
            children[addIndex++] = this.buildHashRow(key, value, docModel, context);
            i += 2;
        }
        try {
            tableModel = new WmiInlineMathModel(docModel, children);
            tableModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return tableModel;
    }

    private WmiMathModel buildHashRow(Dag key, Dag value, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiInlineMathModel row = new WmiInlineMathModel(docModel);
        WmiModel[] children = new WmiMathModel[1];
        StringBuffer rsb = new StringBuffer(ROW_LEAD_CHARACTERS);
        rsb.append(DagBuilder.lPrint(key));
        rsb.append(ROW_MIDDLE_CHARACTERS);
        rsb.append(DagBuilder.lPrint(value));
        children[0] = WmiMathFactory.createMathTextToken(docModel, rsb.toString(), context);
        try {
            row.replaceChildren(children, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        return row;
    }

    @Override
    public Dag toDag(WmiMathModel model) {
        return null;
    }
}

