/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTypeMKParser;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WmiIdentifierModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    private static HashMap symbolMap = null;
    private static HashMap reverseSymbolMap = null;
    private static HashSet keywordStyleSet = null;
    private static boolean useItalics = true;
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    static {
        WmiIdentifierModel.buildSymbolMap();
        WmiIdentifierModel.buildReverseSymbolMap();
    }

    public WmiIdentifierModel(WmiMathDocumentModel doc, String display, String semantics, WmiMathContext context, boolean containsOnlySymbols) {
        super(doc, semantics, context.createAttributes(WmiIdentifierModel.getAppropriateAttributeCode(semantics, containsOnlySymbols)), context);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiIdentifierModel(WmiMathDocumentModel doc, String display, String semantics, WmiFontAttributeSet attributes, boolean containsOnlySymbols) {
        super(doc, semantics, (WmiAttributeSet)attributes);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiIdentifierModel(WmiMathDocumentModel doc, String display, String semantics, WmiMathContext context, WmiFontAttributeSet attributes, boolean containsOnlySymbols) {
        super(doc, semantics, attributes, context);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_IDENTIFIER;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean isSubselectable() {
        return true;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributes());
        context.setSplitModel(true);
        return new WmiIdentifierModel(this.getDocument(), this.getText().substring(offset), this.getText().substring(offset), context, (WmiFontAttributeSet)this.getAttributes(), false);
    }

    private static boolean isNullString(String s) {
        return s == null || s.length() == 0 || s.charAt(0) == '\u0000';
    }

    public static String mapString(String name, WmiMathContext context, boolean isEntityName) {
        if (name != null && name.length() > 0 && WmiIdentifierModel.mayMapStringInContext(name, context, isEntityName)) {
            int index = name.indexOf(95, 1);
            String label = name;
            if (index >= 0) {
                label = name.substring(0, index);
            }
            String replacement = null;
            if (isEntityName) {
                String unicode = WmiMathEntityNameMapper.getUnicodeCharacterAsString(label);
                if (WmiIdentifierModel.isNullString(unicode) && label.startsWith("#")) {
                    try {
                        int i = -1;
                        if (label.length() > 2 && label.charAt(1) == 'x') {
                            i = Integer.parseInt(label.substring(2), 16);
                        } else if (label.length() > 1) {
                            i = Integer.parseInt(label.substring(1));
                        }
                        if (i != -1) {
                            char ch = (char)i;
                            label = WmiMathEntityNameMapper.getEntityName(ch);
                            unicode = label != null ? WmiMathEntityNameMapper.getUnicodeCharacterAsString(label) : Character.toString(ch);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!WmiIdentifierModel.isNullString(unicode)) {
                    replacement = unicode;
                } else if (WmiMathEntityNameMapper.isNonMarkingEntity(label)) {
                    name = "";
                } else if (WmiMathEntityNameMapper.isEmptyEntity(label)) {
                    name = "";
                }
            } else if (label.length() > 0 && label.charAt(label.length() - 1) == '~') {
                replacement = (String)symbolMap.get(label.substring(0, label.length() - 1));
                if (replacement != null) {
                    replacement = String.valueOf(replacement) + "~";
                }
            } else if (label.length() > 0 && label.charAt(0) == '_') {
                replacement = (String)symbolMap.get(label.substring(1));
                if (replacement != null) {
                    replacement = "_" + replacement;
                }
            } else {
                replacement = (String)symbolMap.get(label);
            }
            if (replacement != null) {
                name = index >= 0 ? String.valueOf(replacement) + name.substring(index + 1) : replacement;
            }
        }
        return name;
    }

    public static boolean mayMapStringInContext(String name, WmiMathContext context, boolean isEntityName) {
        boolean mayMapSymbol = true;
        if (context.isSplittingModel()) {
            mayMapSymbol = false;
        } else if (context.useProcRules()) {
            mayMapSymbol = isEntityName;
        }
        return mayMapSymbol;
    }

    public static void setUseItalics(boolean italics) {
        useItalics = italics;
    }

    public static int getAppropriateAttributeCode(String content, boolean containsOnlySymbols) {
        int style = 0;
        if (containsOnlySymbols || !useItalics || keywordStyleSet.contains(content)) {
            style = 1;
        }
        return style;
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        boolean save = false;
        if (key.toString().equals("italic")) {
            save = value.toString().equals("false");
        }
        return save;
    }

    public static String mapUnicodeToString(String unicode) {
        return (String)reverseSymbolMap.get(unicode);
    }

    private static void buildSymbolMap() {
        symbolMap = new HashMap();
        symbolMap.put("alpha", "\u03b1");
        symbolMap.put("beta", "\u03b2");
        symbolMap.put("gamma", "\u03b3");
        symbolMap.put("delta", "\u03b4");
        symbolMap.put("epsilon", "\u03b5");
        symbolMap.put("zeta", "\u03b6");
        symbolMap.put("eta", "\u03b7");
        symbolMap.put("theta", "\u03b8");
        symbolMap.put("iota", "\u03b9");
        symbolMap.put("kappa", "\u03ba");
        symbolMap.put("lambda", "\u03bb");
        symbolMap.put("mu", "\u03bc");
        symbolMap.put("nu", "\u03bd");
        symbolMap.put("xi", "\u03be");
        symbolMap.put("omicron", "\u03bf");
        symbolMap.put("pi", "\u03c0");
        symbolMap.put("rho", "\u03c1");
        symbolMap.put("sigma", "\u03c3");
        symbolMap.put("tau", "\u03c4");
        symbolMap.put("upsilon", "\u03c5");
        symbolMap.put("phi", "\u03c6");
        symbolMap.put("chi", "\u03c7");
        symbolMap.put("psi", "\u03c8");
        symbolMap.put("omega", "\u03c9");
        symbolMap.put("Alpha", "\u0391");
        symbolMap.put("Beta", "\u0392");
        symbolMap.put("Gamma", "\u0393");
        symbolMap.put("Delta", "\u0394");
        symbolMap.put("Epsilon", "\u0395");
        symbolMap.put("Zeta", "\u03b6");
        symbolMap.put("Eta", "\u0397");
        symbolMap.put("Theta", "\u0398");
        symbolMap.put("Iota", "\u0399");
        symbolMap.put("Kappa", "\u039a");
        symbolMap.put("Lambda", "\u039b");
        symbolMap.put("Mu", "\u039c");
        symbolMap.put("Nu", "\u039d");
        symbolMap.put("Xi", "\u039e");
        symbolMap.put("Omicron", "\u039f");
        symbolMap.put("Pi", "\u03c0");
        symbolMap.put("Rho", "\u03a1");
        symbolMap.put("Sigma", "\u03a3");
        symbolMap.put("Tau", "\u03a4");
        symbolMap.put("Upsilon", "\u03a5");
        symbolMap.put("Phi", "\u03a6");
        symbolMap.put("Psi", "\u03a8");
        symbolMap.put("Omega", "\u03a9");
        symbolMap.put("GAMMA", "\u0393");
        symbolMap.put("ZETA", "\u0396");
        symbolMap.put("PI", "\u03a0");
        symbolMap.put("CHI", "\u03a7");
        symbolMap.put("infinity", "\u221e");
        symbolMap.put("aleph", "\u2135");
        symbolMap.put("Im", "\u2111");
        symbolMap.put("Re", "\u211c");
        symbolMap.put("%?", "?");
        keywordStyleSet = new HashSet();
        keywordStyleSet.add("&alpha;");
        keywordStyleSet.add("&beta;");
        keywordStyleSet.add("&gamma;");
        keywordStyleSet.add("&delta;");
        keywordStyleSet.add("&epsilon;");
        keywordStyleSet.add("&varepsilon;");
        keywordStyleSet.add("&zeta;");
        keywordStyleSet.add("&eta;");
        keywordStyleSet.add("&theta;");
        keywordStyleSet.add("&vartheta;");
        keywordStyleSet.add("&iota;");
        keywordStyleSet.add("&kappa;");
        keywordStyleSet.add("&varkappa;");
        keywordStyleSet.add("&lambda;");
        keywordStyleSet.add("&mu;");
        keywordStyleSet.add("&nu;");
        keywordStyleSet.add("&xi;");
        keywordStyleSet.add("&omicron;");
        keywordStyleSet.add("&pi;");
        keywordStyleSet.add("&varpi;");
        keywordStyleSet.add("&rho;");
        keywordStyleSet.add("&varrho;");
        keywordStyleSet.add("&sigma;");
        keywordStyleSet.add("&varsigma;");
        keywordStyleSet.add("&tau;");
        keywordStyleSet.add("&upsilon;");
        keywordStyleSet.add("&phi;");
        keywordStyleSet.add("&varphi;");
        keywordStyleSet.add("&chi;");
        keywordStyleSet.add("&psi;");
        keywordStyleSet.add("&omega;");
        keywordStyleSet.add("&Alpha;");
        keywordStyleSet.add("&Beta;");
        keywordStyleSet.add("&Gamma;");
        keywordStyleSet.add("&Delta;");
        keywordStyleSet.add("&Epsilon;");
        keywordStyleSet.add("&Zeta;");
        keywordStyleSet.add("&Eta;");
        keywordStyleSet.add("&Theta;");
        keywordStyleSet.add("&Iota;");
        keywordStyleSet.add("&Kappa;");
        keywordStyleSet.add("&Lambda;");
        keywordStyleSet.add("&Mu;");
        keywordStyleSet.add("&Nu;");
        keywordStyleSet.add("&Xi;");
        keywordStyleSet.add("&Omicron;");
        keywordStyleSet.add("&Pi;");
        keywordStyleSet.add("&Rho;");
        keywordStyleSet.add("&Sigma;");
        keywordStyleSet.add("&Tau;");
        keywordStyleSet.add("&Upsi;");
        keywordStyleSet.add("&Upsilon;");
        keywordStyleSet.add("&Phi;");
        keywordStyleSet.add("&Chi;");
        keywordStyleSet.add("&Psi;");
        keywordStyleSet.add("&Omega;");
        keywordStyleSet.add("&complexes;");
        keywordStyleSet.add("&reals;");
        keywordStyleSet.add("&naturals;");
        keywordStyleSet.add("&rationals;");
        keywordStyleSet.add("&integers;");
        keywordStyleSet.add("&Re;");
        keywordStyleSet.add("&Im;");
        keywordStyleSet.add("&infin;");
        keywordStyleSet.add("&aleph;");
        keywordStyleSet.add("And");
        keywordStyleSet.add("abs");
        keywordStyleSet.add("AiryAi");
        keywordStyleSet.add("AiryAiZeros");
        keywordStyleSet.add("AiryBi");
        keywordStyleSet.add("AiryBiZeros");
        keywordStyleSet.add("alpha");
        keywordStyleSet.add("Alpha");
        keywordStyleSet.add("AngerJ");
        keywordStyleSet.add("arccos");
        keywordStyleSet.add("arccosh");
        keywordStyleSet.add("arccot");
        keywordStyleSet.add("arccoth");
        keywordStyleSet.add("arccsc");
        keywordStyleSet.add("arccsch");
        keywordStyleSet.add("arcsec");
        keywordStyleSet.add("arcsech");
        keywordStyleSet.add("arcsin");
        keywordStyleSet.add("arcsinh");
        keywordStyleSet.add("arctan");
        keywordStyleSet.add("arctanh");
        keywordStyleSet.add("argument");
        keywordStyleSet.add("bernoulli");
        keywordStyleSet.add("BesselI");
        keywordStyleSet.add("BesselIZeros");
        keywordStyleSet.add("BesselJ");
        keywordStyleSet.add("BesselJZeros");
        keywordStyleSet.add("BesselK");
        keywordStyleSet.add("BesselKZeros");
        keywordStyleSet.add("BesselY");
        keywordStyleSet.add("BesselYZeros");
        keywordStyleSet.add("Beta");
        keywordStyleSet.add("beta");
        keywordStyleSet.add("Beta");
        keywordStyleSet.add("binomial");
        keywordStyleSet.add("ceil");
        keywordStyleSet.add("ChebyshevT");
        keywordStyleSet.add("ChebyshevU");
        keywordStyleSet.add("Chi");
        keywordStyleSet.add("chi");
        keywordStyleSet.add("CHI");
        keywordStyleSet.add("Ci");
        keywordStyleSet.add("cos");
        keywordStyleSet.add("cosh");
        keywordStyleSet.add("cot");
        keywordStyleSet.add("coth");
        keywordStyleSet.add("CoulombF");
        keywordStyleSet.add("csc");
        keywordStyleSet.add("csch");
        keywordStyleSet.add("csgn");
        keywordStyleSet.add("CylinderD");
        keywordStyleSet.add("CylinderU");
        keywordStyleSet.add("CylinderV");
        keywordStyleSet.add("D");
        keywordStyleSet.add("dawson");
        keywordStyleSet.add("delta");
        keywordStyleSet.add("Delta");
        keywordStyleSet.add("dilog");
        keywordStyleSet.add("Dirac");
        keywordStyleSet.add("doublefactorial");
        keywordStyleSet.add("Ei");
        keywordStyleSet.add("EllipticCE");
        keywordStyleSet.add("EllipticCK");
        keywordStyleSet.add("EllipticCPi");
        keywordStyleSet.add("EllipticE");
        keywordStyleSet.add("EllipticF");
        keywordStyleSet.add("EllipticK");
        keywordStyleSet.add("EllipticModulus");
        keywordStyleSet.add("EllipticNome");
        keywordStyleSet.add("EllipticPi");
        keywordStyleSet.add("epsilon");
        keywordStyleSet.add("Epsilon");
        keywordStyleSet.add("erf");
        keywordStyleSet.add("erfc");
        keywordStyleSet.add("erfi");
        keywordStyleSet.add("eta");
        keywordStyleSet.add("Eta");
        keywordStyleSet.add("euler");
        keywordStyleSet.add("exp");
        keywordStyleSet.add("factorial");
        keywordStyleSet.add("floor");
        keywordStyleSet.add("frac");
        keywordStyleSet.add("FresnelC");
        keywordStyleSet.add("Fresnelf");
        keywordStyleSet.add("Fresnelg");
        keywordStyleSet.add("FresnelS");
        keywordStyleSet.add("GAMMA");
        keywordStyleSet.add("gamma");
        keywordStyleSet.add("Gamma");
        keywordStyleSet.add("GaussAGM");
        keywordStyleSet.add("GegenbauerC");
        keywordStyleSet.add("HankelH1");
        keywordStyleSet.add("HankelH2");
        keywordStyleSet.add("harmonic");
        keywordStyleSet.add("Heaviside");
        keywordStyleSet.add("HermiteH");
        keywordStyleSet.add("HeunB");
        keywordStyleSet.add("HeunBPrime");
        keywordStyleSet.add("HeunC");
        keywordStyleSet.add("HeunCPrime");
        keywordStyleSet.add("HeunD");
        keywordStyleSet.add("HeunDPrime");
        keywordStyleSet.add("HeunG");
        keywordStyleSet.add("HeunGPrime");
        keywordStyleSet.add("HeunT");
        keywordStyleSet.add("HeunTPrime");
        keywordStyleSet.add("Hypergeom");
        keywordStyleSet.add("hypergeom");
        keywordStyleSet.add("ilog");
        keywordStyleSet.add("ilog10");
        keywordStyleSet.add("ilog2");
        keywordStyleSet.add("Im");
        keywordStyleSet.add("InverseJacobiAM");
        keywordStyleSet.add("InverseJacobiCD");
        keywordStyleSet.add("InverseJacobiCN");
        keywordStyleSet.add("InverseJacobiCS");
        keywordStyleSet.add("InverseJacobiDC");
        keywordStyleSet.add("InverseJacobiDN");
        keywordStyleSet.add("InverseJacobiDS");
        keywordStyleSet.add("InverseJacobiNC");
        keywordStyleSet.add("InverseJacobiND");
        keywordStyleSet.add("InverseJacobiNS");
        keywordStyleSet.add("InverseJacobiSC");
        keywordStyleSet.add("InverseJacobiSD");
        keywordStyleSet.add("InverseJacobiSN");
        keywordStyleSet.add("iota");
        keywordStyleSet.add("Iota");
        keywordStyleSet.add("JacobiAM");
        keywordStyleSet.add("JacobiCD");
        keywordStyleSet.add("JacobiCN");
        keywordStyleSet.add("JacobiCS");
        keywordStyleSet.add("JacobiDC");
        keywordStyleSet.add("JacobiDN");
        keywordStyleSet.add("JacobiDS");
        keywordStyleSet.add("JacobiNC");
        keywordStyleSet.add("JacobiND");
        keywordStyleSet.add("JacobiNS");
        keywordStyleSet.add("JacobiP");
        keywordStyleSet.add("JacobiSC");
        keywordStyleSet.add("JacobiSD");
        keywordStyleSet.add("JacobiSN");
        keywordStyleSet.add("JacobiTheta1");
        keywordStyleSet.add("JacobiTheta2");
        keywordStyleSet.add("JacobiTheta3");
        keywordStyleSet.add("JacobiTheta4");
        keywordStyleSet.add("JacobiZeta");
        keywordStyleSet.add("kappa");
        keywordStyleSet.add("Kappa");
        keywordStyleSet.add("KelvinBei");
        keywordStyleSet.add("KelvinBer");
        keywordStyleSet.add("KelvinHei");
        keywordStyleSet.add("KelvinHer");
        keywordStyleSet.add("KelvinKei");
        keywordStyleSet.add("KelvinKer");
        keywordStyleSet.add("KummerM");
        keywordStyleSet.add("KummerU");
        keywordStyleSet.add("LaguerreL");
        keywordStyleSet.add("lambda");
        keywordStyleSet.add("Lambda");
        keywordStyleSet.add("LambertW");
        keywordStyleSet.add("LegendreP");
        keywordStyleSet.add("LegendreQ");
        keywordStyleSet.add("LerchPhi");
        keywordStyleSet.add("Li");
        keywordStyleSet.add("lim");
        keywordStyleSet.add("ln");
        keywordStyleSet.add("lnGAMMA");
        keywordStyleSet.add("log");
        keywordStyleSet.add("log10");
        keywordStyleSet.add("LommelS1");
        keywordStyleSet.add("LommelS2");
        keywordStyleSet.add("MathieuA");
        keywordStyleSet.add("MathieuB");
        keywordStyleSet.add("MathieuC");
        keywordStyleSet.add("MathieuCE");
        keywordStyleSet.add("MathieuCEPrime");
        keywordStyleSet.add("MathieuCPrime");
        keywordStyleSet.add("MathieuExponent");
        keywordStyleSet.add("MathieuFloquet");
        keywordStyleSet.add("MathieuFloquetPrime");
        keywordStyleSet.add("MathieuS");
        keywordStyleSet.add("MathieuSE");
        keywordStyleSet.add("MathieuSEPrime");
        keywordStyleSet.add("MathieuSPrime");
        keywordStyleSet.add("max");
        keywordStyleSet.add("MeijerG");
        keywordStyleSet.add("min");
        keywordStyleSet.add("mu");
        keywordStyleSet.add("Mu");
        keywordStyleSet.add("Not");
        keywordStyleSet.add("nu");
        keywordStyleSet.add("Nu");
        keywordStyleSet.add("O");
        keywordStyleSet.add("Omega");
        keywordStyleSet.add("omega");
        keywordStyleSet.add("omicron");
        keywordStyleSet.add("Omicron");
        keywordStyleSet.add("Or");
        keywordStyleSet.add("phi");
        keywordStyleSet.add("Phi");
        keywordStyleSet.add("pi");
        keywordStyleSet.add("Pi");
        keywordStyleSet.add("PI");
        keywordStyleSet.add("pochhammer");
        keywordStyleSet.add("polar");
        keywordStyleSet.add("polylog");
        keywordStyleSet.add("Psi");
        keywordStyleSet.add("psi");
        keywordStyleSet.add("Psi");
        keywordStyleSet.add("Re");
        keywordStyleSet.add("rho");
        keywordStyleSet.add("Rho");
        keywordStyleSet.add("RiemannTheta");
        keywordStyleSet.add("RootOf");
        keywordStyleSet.add("round");
        keywordStyleSet.add("sec");
        keywordStyleSet.add("sech");
        keywordStyleSet.add("Shi");
        keywordStyleSet.add("Si");
        keywordStyleSet.add("sigma");
        keywordStyleSet.add("Sigma");
        keywordStyleSet.add("signum");
        keywordStyleSet.add("sin");
        keywordStyleSet.add("sinh");
        keywordStyleSet.add("SphericalY");
        keywordStyleSet.add("sqrt");
        keywordStyleSet.add("Ssi");
        keywordStyleSet.add("stirling1");
        keywordStyleSet.add("stirling2");
        keywordStyleSet.add("StruveH");
        keywordStyleSet.add("StruveL");
        keywordStyleSet.add("surd");
        keywordStyleSet.add("tan");
        keywordStyleSet.add("tanh");
        keywordStyleSet.add("tau");
        keywordStyleSet.add("Tau");
        keywordStyleSet.add("theta");
        keywordStyleSet.add("Theta");
        keywordStyleSet.add("trunc");
        keywordStyleSet.add("upsilon");
        keywordStyleSet.add("Upsilon");
        keywordStyleSet.add("WeberE");
        keywordStyleSet.add("WeierstrassP");
        keywordStyleSet.add("WeierstrassPPrime");
        keywordStyleSet.add("WeierstrassSigma");
        keywordStyleSet.add("WeierstrassZeta");
        keywordStyleSet.add("WhittakerM");
        keywordStyleSet.add("WhittakerW");
        keywordStyleSet.add("Wrightomega");
        keywordStyleSet.add("xi");
        keywordStyleSet.add("Xi");
        keywordStyleSet.add("zeta");
        keywordStyleSet.add("Zeta");
        keywordStyleSet.add("ZETA");
    }

    private static void buildReverseSymbolMap() {
        reverseSymbolMap = new HashMap();
        Set keys = symbolMap.keySet();
        for (String key : keys) {
            String value = (String)symbolMap.get(key);
            reverseSymbolMap.put(value, key);
        }
        reverseSymbolMap.put("\u0393", "GAMMA");
        reverseSymbolMap.put("\u03b6", "Zeta");
        reverseSymbolMap.put("\u03c0", "Pi");
    }

    public static class WmiNameBuilder
    implements WmiRenderContextAwareBuilder,
    WmiMathModelBuilder,
    WmiMathSemantics {
        private static final int NO_SHOW = 0;
        private static final int SHOW_TILDE = 1;
        private static final int SHOW_AFTER = 2;
        private static final int ASSUME_DEFAULT = 1;
        private boolean suppressAssumptionAnnotation = false;
        private boolean showAssumptionSummary = false;
        private static final String ASSUMPTION_MARKER = "~";
        private static int markerLength = "~".length();
        private static final Pattern variablDelimPattern = Pattern.compile("__([a-zA-Z0-9]+)__");

        @Override
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) {
            String name = dag.getData();
            if (name.length() == 1 && MathTokenizer.containsOperator(name) && !name.startsWith("`")) {
                name = "`" + name + "`";
            }
            if (this.suppressAssumptionAnnotation && name.endsWith(ASSUMPTION_MARKER)) {
                name = name.substring(0, name.length() - markerLength);
                if (this.showAssumptionSummary) {
                    context.makeAssumption(name);
                }
            }
            if (context.getRenderMode() == 1 && name.indexOf("__") >= 0) {
                StringBuffer newContentsBuff = new StringBuffer();
                Matcher variableDelimMatcher = variablDelimPattern.matcher(name);
                while (variableDelimMatcher.find()) {
                    String taskVariable = variableDelimMatcher.group(1);
                    variableDelimMatcher.appendReplacement(newContentsBuff, taskVariable);
                }
                variableDelimMatcher.appendTail(newContentsBuff);
                name = newContentsBuff.toString();
            }
            WmiMathModel model = null;
            String mathml = WmiTypeMKParser.parse(name);
            if (mathml != null) {
                try {
                    model = WmiInsertMathMLCommand.convertMathMLToModel(mathml, docModel, context);
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                }
            } else {
                model = WmiMathFactory.createMathIdentifierToken(docModel, name, context);
            }
            model.setSemantics(this);
            return model;
        }

        @Override
        public Dag toDag(WmiMathModel model) {
            Dag dag = null;
            if (model instanceof WmiIdentifierModel) {
                String label = ((WmiIdentifierModel)model).getSemanticLabel();
                dag = Dag.createDag(8, null, label, false);
            } else {
                System.out.println("unexpected model type");
            }
            return dag;
        }

        @Override
        public void updateContext(DagRenderContext context) {
            int showAssumedValue = context.getInterfaceProperty("showassumed", 1);
            this.suppressAssumptionAnnotation = showAssumedValue == 0 || showAssumedValue == 2;
            this.showAssumptionSummary = showAssumedValue == 2;
        }
    }
}

