/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiIfStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String IF_KEYWORD = "if";
    public static final String THEN_KEYWORD = "then";
    public static final String ELSE_KEYWORD = "else";
    public static final String ELSE_IF_KEYWORD = "elif";
    public static final String END_IF_KEYWORD = "end if";
    public static final String END_IF_SHORT_KEYWORD = "fi";
    public static final int IF_SIZE = 8;
    private static final int ELSE_SIZE = 4;
    private static final int FIRST_CONDITION_INDEX = 0;
    private static final int FIRST_STATEMENT_INDEX = 1;
    private static final int FIRST_ELSE_INDEX = 2;
    private static final WmiIfLineSemantics LINE_SEMANTICS = new WmiIfLineSemantics();

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel ifModel = null;
        int ifLength = dag.getLength();
        boolean dagLengthIsOdd = (ifLength & 1) == 1;
        WmiModel[] children = new WmiMathModel[ifLength / 2 + ifLength % 2 + 1];
        int insertIndex = 0;
        children[insertIndex++] = this.createIfCondition(dag.getChild(0), dag.getChild(1), docModel, context, IF_KEYWORD);
        int i = 2;
        while (i < ifLength - 1) {
            children[insertIndex++] = this.createIfCondition(dag.getChild(i), dag.getChild(i + 1), docModel, context, ELSE_IF_KEYWORD);
            i += 2;
        }
        if (dagLengthIsOdd) {
            children[insertIndex++] = this.createElseStatement(dag.getChild(ifLength - 1), docModel, context);
        }
        children[insertIndex] = WmiMathFactory.createMathOperatorToken(docModel, WmiProcBuilder.getLongDelimProperty(docModel) ? END_IF_KEYWORD : END_IF_SHORT_KEYWORD, context);
        try {
            ifModel = new WmiInlineMathModel(docModel, children);
            ifModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return ifModel;
    }

    public WmiMathModel createIfCondition(Dag condition, Dag statement, WmiMathDocumentModel docModel, WmiMathContext context, String ifKeyw) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel ifcondition = null;
        WmiModel[] children = new WmiMathModel[8];
        children[0] = WmiMathFactory.createMathOperatorToken(docModel, ifKeyw, context);
        children[1] = new WmiMathSpaceModel(docModel);
        children[1].addAttribute("width", "0.5em");
        children[2] = WmiProcBuilder.createStatementSequenceRow(condition, docModel, context);
        children[3] = new WmiMathSpaceModel(docModel);
        children[3].addAttribute("width", "0.5em");
        children[4] = WmiMathFactory.createMathOperatorToken(docModel, THEN_KEYWORD, context);
        children[5] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        children[6] = WmiProcBuilder.createStatementSequenceRow(statement, docModel, context);
        children[7] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        try {
            ifcondition = new WmiInlineMathModel(docModel, children);
            ifcondition.setSemantics(LINE_SEMANTICS);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return ifcondition;
    }

    public WmiMathModel createElseStatement(Dag statement, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel elseModel = null;
        WmiModel[] children = new WmiMathModel[]{WmiMathFactory.createMathOperatorToken(docModel, ELSE_KEYWORD, context), WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR), WmiProcBuilder.createStatementSequenceRow(statement, docModel, context), WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR)};
        try {
            elseModel = new WmiInlineMathModel(docModel, children);
            elseModel.setSemantics(LINE_SEMANTICS);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return elseModel;
    }

    @Override
    public Dag toDag(WmiMathModel model) {
        return null;
    }

    public static class WmiIfLineSemantics
    implements WmiMathSemantics {
        @Override
        public Dag toDag(WmiMathModel model) {
            return null;
        }
    }
}

