/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import java.util.HashSet;

public class WmiInlineMathModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    public static final int FUNCTION_SIZE = 3;
    public static final int APPLY_FUNCTION_INDEX = 1;
    public static final int FENCED_MODEL_INDEX = 2;
    public static final int FUNCTION_NAME_INDEX = 0;
    protected WmiDeleteHandler deleteHandler = null;
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private static WmiModelTag[] PLACEHOLDER_SKIP = new WmiModelTag[]{WmiModelTag.MATH_FENCED, WmiModelTag.MATH_FRAC, WmiModelTag.MATH_IDENTIFIER, WmiModelTag.MATH_MULTISCRIPTS, WmiModelTag.MATH_NUMERIC, WmiModelTag.MATH_OPERATOR, WmiModelTag.MATH_OVER, WmiModelTag.MATH_SQUARE_ROOT, WmiModelTag.MATH_SUB_SUP, WmiModelTag.MATH_SUBSCRIPT, WmiModelTag.MATH_SUPERSCRIPT, WmiModelTag.MATH_UNDER, WmiModelTag.MATH_UNDER_OVER};

    public WmiInlineMathModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiInlineMathModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    private WmiInlineMathModel(WmiMathDocumentModel doc, WmiModel[] children, WmiMathContext context) {
        super(doc);
        this.children = children;
        this.length = children.length;
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public static WmiInlineMathModel createLinebreakingMathRow(WmiMathDocumentModel doc, WmiModel[] children, WmiMathContext context) {
        return new WmiInlineMathModel(doc, children, context);
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : IMPLIED_SEMANTICS.toDag(this);
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        boolean mutable = false;
        this.verifyUpdateLock();
        try {
            mutable = this.getDocument().isMutableModel(this);
            if (mutable && !this.isAFunction()) {
                this.guaranteeInsertPoints();
            }
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        super.update(undoName);
    }

    private boolean isInputMethodText(WmiModel model) throws WmiNoReadAccessException {
        WmiAttributeSet att;
        boolean composed = false;
        if (model != null && (att = model.getAttributesForRead()) instanceof WmiFontAttributeSet && ((WmiFontAttributeSet)att).isInputMethodText()) {
            composed = true;
        }
        return composed;
    }

    private boolean requiresInputPlaceholder(WmiModel model) throws WmiNoReadAccessException {
        boolean required = true;
        WmiModelTag tag = model.getTag();
        if (tag == WmiModelTag.MATH_SPACE) {
            boolean firstChild;
            WmiCompositeModel parent = model.getParent();
            boolean bl = parent != null && parent.getChildCount() > 0 ? parent.getChild(0) == model : (firstChild = false);
            if (firstChild && MathTokenizer.isLinebreakingMSpace(model)) {
                required = true;
            }
        } else {
            int i = 0;
            while (i < PLACEHOLDER_SKIP.length) {
                if (PLACEHOLDER_SKIP[i] == tag) {
                    required = false;
                    break;
                }
                ++i;
            }
        }
        return required;
    }

    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel child;
        String semanticsValue;
        if (this.attributes != null && (semanticsValue = (String)this.attributes.getAttribute("Typesetting:-msemantics")) != null && semanticsValue.length() > 0) {
            return;
        }
        boolean foundInputMethodText = false;
        int i = 0;
        while (i < this.getChildCount()) {
            child = this.getChild(i);
            if (this.isInputMethodText(child)) {
                foundInputMethodText = true;
                break;
            }
            ++i;
        }
        if (!foundInputMethodText) {
            i = 0;
            while (i < this.getChildCount()) {
                child = this.getChild(i);
                if (this.requiresInputPlaceholder(child)) {
                    if (i > 0) {
                        if (!(this.getChild(i - 1) instanceof WmiAbstractMathTokenModel)) {
                            this.addChild(this.getPlaceHolder(i), i);
                        }
                    } else {
                        this.addChild(this.getPlaceHolder(0), 0);
                    }
                }
                ++i;
            }
            if (this.getChildCount() == 0 || this.requiresInputPlaceholder(this.getChild(this.getChildCount() - 1))) {
                this.appendChild(this.getPlaceHolder(0));
            }
        }
    }

    public boolean isAFunction() throws WmiNoReadAccessException {
        return this.getChildCount() == 3 && this.getChild(1) instanceof WmiMathOperatorModel && "&ApplyFunction;".equals(((WmiMathOperatorModel)this.getChild(1)).getSemanticLabel()) && this.getChild(2) instanceof WmiMathFencedModel && this.getChild(0) instanceof WmiIdentifierModel;
    }

    private boolean isAFunctionRequiringWrapping() throws WmiNoReadAccessException {
        return this.isAFunction() && (!(this.getParent() instanceof WmiInlineMathModel) || this.getParent().getTag() == WmiModelTag.MATH_FENCED) && this.getDocument().isMutableModel(this);
    }

    private WmiModel getPlaceHolder(int attrIdx) throws WmiNoReadAccessException {
        WmiModel model;
        WmiAttributeSet attrs = this.getAttributesForRead();
        WmiMathDocumentModel docModel = this.getDocument();
        Object styleName = attrs.getAttribute(WmiFontAttributeSet.STYLE_KEY);
        if (styleName == null && (model = WmiModelUtil.findAncestorOfTag((WmiModel)this, WmiModelTag.MATH)) != null) {
            attrs = model.getAttributesForRead();
            styleName = attrs.getAttribute(WmiFontAttributeSet.STYLE_KEY);
        }
        if (styleName instanceof String) {
            attrs = docModel.getFontStyle((String)styleName);
        }
        if (attrs == null) {
            attrs = this.getAttributesForRead();
            if (attrIdx >= 0 && attrIdx < this.getChildCount()) {
                model = this.getChild(attrIdx);
                while (model instanceof WmiCompositeModel) {
                    WmiModel comp = model;
                    if (comp.getChildCount() <= 0) break;
                    model = comp.getChild(0);
                }
                if (model != null) {
                    attrs = model.getAttributesForRead();
                }
            }
        }
        attrs = attrs.copyAttributes();
        WmiFontAttributeSet active = docModel.getActiveEditAttributes();
        active.setStyle(4096, false);
        if (active != null) {
            attrs.addAttributes(active);
        }
        return WmiMathWrapperModel.createPlaceHolder(this.getDocument(), attrs);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ROW;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics == null ? IMPLIED_SEMANTICS : semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        return this.deleteHandler;
    }

    public static class WmiInlineMathDeleteHandler
    implements WmiDeleteHandler {
        private WmiInlineMathModel model;
        private static HashSet invisibleOperatorLabels = new HashSet();

        static {
            invisibleOperatorLabels.add("&ApplyFunction;");
            invisibleOperatorLabels.add("&af;");
            invisibleOperatorLabels.add("&InvisibleComma;");
            invisibleOperatorLabels.add("&ic;");
        }

        @Override
        public void processDelete(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel nextPos;
                WmiModel before;
                int index = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                boolean joinModels = false;
                if (index >= 1 && index + 1 < this.model.getChildCount()) {
                    before = this.model.getChild(index - 1);
                    WmiModel after = this.model.getChild(index + 1);
                    if ((before instanceof WmiIdentifierModel || before instanceof WmiNumericModel) && before.getClass().equals(after.getClass())) {
                        WmiAttributeSet attr1 = before.getAttributes();
                        WmiAttributeSet attr2 = after.getAttributes();
                        joinModels = attr1.equals(attr2);
                    }
                }
                this.model.removeChild(index);
                if (joinModels) {
                    before = (WmiTextModel)this.model.getChild(index - 1);
                    int targetLoc = ((WmiTextModel)before).getLength();
                    WmiTextModel after = (WmiTextModel)this.model.getChild(index);
                    ((WmiTextModel)before).appendText(after.getText());
                    this.model.removeChild(index);
                    manager.setModelToReposition(new WmiModelPosition(before, targetLoc));
                }
                if (index <= 1 || !(this.model.getChild(index - 1) instanceof WmiAbstractMathTokenModel)) continue;
                WmiAbstractMathTokenModel possibleTarget = (WmiAbstractMathTokenModel)this.model.getChild(index - 1);
                String semanticText = possibleTarget.getSemanticLabel();
                if (!(possibleTarget instanceof WmiMathOperatorModel) || !"&ApplyFunction;".equals(semanticText)) continue;
                this.model.removeChild(index - 1);
                int offSet = 0;
                if (this.model.getChild(index - 2) instanceof WmiIdentifierModel) {
                    nextPos = this.model.getChild(index - 2);
                    offSet = ((WmiIdentifierModel)nextPos).getLength();
                } else if (this.model.getChildCount() >= index && this.model.getChild(index - 1) instanceof WmiIdentifierModel) {
                    nextPos = this.model.getChild(index - 1);
                } else {
                    this.model.addChild(this.createEmptyIdentifier(), index - 1);
                    nextPos = this.model.getChild(index - 1);
                }
                manager.setModelToReposition(new WmiModelPosition(nextPos, offSet));
            }
            if (this.getVisibleModelCount() == 0) {
                WmiMathTokenModel emptyIdent;
                WmiCompositeModel parent = this.model.getParent();
                if (parent instanceof WmiMathWrapperModel) {
                    int childCount = this.model.getChildCount();
                    if (childCount > 0) {
                        this.model.removeChildren(0, childCount);
                        emptyIdent = this.createEmptyIdentifier();
                        this.model.appendChild(emptyIdent);
                        manager.setModelToReposition(new WmiModelPosition(emptyIdent, 0));
                    }
                } else {
                    int index = parent.indexOf(this.model);
                    if (index >= 0) {
                        emptyIdent = this.createEmptyIdentifier();
                        parent.replaceChild(emptyIdent, index);
                        manager.setModelToReposition(new WmiModelPosition(emptyIdent, 0));
                        if (parent.getClass().equals(WmiInlineMathModel.class)) {
                            manager.mark(parent);
                        }
                    }
                }
            }
        }

        private int getVisibleModelCount() throws WmiNoReadAccessException {
            int count = 0;
            int childCount = this.model.getChildCount();
            int i = 0;
            while (i < childCount) {
                if (!WmiModelUtil.isEmptyIdentifierModel(this.model.getChild(i)) && !WmiInlineMathDeleteHandler.isInvisibleOperator(this.model.getChild(i))) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        private static boolean isInvisibleOperator(WmiModel child) {
            WmiMathOperatorModel opModel;
            String semanticLabel;
            boolean invisible = false;
            if (child instanceof WmiMathOperatorModel && (semanticLabel = (opModel = (WmiMathOperatorModel)child).getSemanticLabel()) != null && invisibleOperatorLabels.contains(semanticLabel)) {
                invisible = true;
            }
            return invisible;
        }

        private WmiMathTokenModel createEmptyIdentifier() throws WmiNoReadAccessException, WmiNoWriteAccessException {
            WmiMathDocumentModel doc = this.model.getDocument();
            WmiFontAttributeSet attribs = null;
            WmiCompositeModel parentWrapper = WmiModelUtil.findAncestorOfTag((WmiModel)this.model, WmiModelTag.MATH);
            if (parentWrapper != null) {
                attribs = (WmiFontAttributeSet)parentWrapper.getAttributes();
            }
            if (attribs == null) {
                attribs = this.model.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)this.model.getAttributes() : new WmiMathAttributeSet();
            }
            WmiMathContext context = new WmiMathContext(attribs);
            return WmiMathFactory.createMathIdentifierToken(doc, "", context);
        }

        @Override
        public boolean forceDeleteHandling() {
            return false;
        }
    }
}

