/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.model.math.WmiBinaryOperatorBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathContext;

public abstract class WmiLogicalBuilder
extends WmiBinaryOperatorBuilder {
    public static final String AND_OPERATOR = "and";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_OPERATOR = "&DoubleRightArrow;";
    public static final String IMPLIES_IN_PROC = "implies";

    public static class WmiAndBuilder
    extends WmiLogicalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return WmiLogicalBuilder.AND_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 24;
        }

        @Override
        protected boolean addMSpacePadding(WmiMathContext context) {
            return true;
        }
    }

    public static class WmiImpliesBuilder
    extends WmiLogicalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return context.useProcRules() ? WmiLogicalBuilder.IMPLIES_IN_PROC : WmiLogicalBuilder.IMPLIES_OPERATOR;
        }

        @Override
        protected int getPrecedenceRule() {
            return 1;
        }

        @Override
        public int getDagType() {
            return 28;
        }

        @Override
        protected boolean addMSpacePadding(WmiMathContext context) {
            return context.isInProc();
        }
    }

    public static class WmiOrBuilder
    extends WmiLogicalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return WmiLogicalBuilder.OR_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 26;
        }

        @Override
        protected boolean addMSpacePadding(WmiMathContext context) {
            return true;
        }
    }

    public static class WmiXorBuilder
    extends WmiLogicalBuilder {
        @Override
        protected String getOperator(WmiMathContext context) {
            return WmiLogicalBuilder.XOR_OPERATOR;
        }

        @Override
        public int getDagType() {
            return 27;
        }

        @Override
        protected boolean addMSpacePadding(WmiMathContext context) {
            return true;
        }
    }
}

