/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiAssignmentBuilder;
import com.maplesoft.mathdoc.model.math.WmiCatenateBuilder;
import com.maplesoft.mathdoc.model.math.WmiCollectionBuilder;
import com.maplesoft.mathdoc.model.math.WmiDColonBuilder;
import com.maplesoft.mathdoc.model.math.WmiDefaultMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiForStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiFunctionBuilder;
import com.maplesoft.mathdoc.model.math.WmiHashTableBuilder;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiIfStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiKeyWordBuilder;
import com.maplesoft.mathdoc.model.math.WmiLPrintIdentifierBuilder;
import com.maplesoft.mathdoc.model.math.WmiLocalBuilder;
import com.maplesoft.mathdoc.model.math.WmiLogicalBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMemberBuilder;
import com.maplesoft.mathdoc.model.math.WmiNotBuilder;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiPowerBuilder;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;
import com.maplesoft.mathdoc.model.math.WmiProductBuilder;
import com.maplesoft.mathdoc.model.math.WmiRangeBuilder;
import com.maplesoft.mathdoc.model.math.WmiRelationalBuilder;
import com.maplesoft.mathdoc.model.math.WmiRenderContextAwareBuilder;
import com.maplesoft.mathdoc.model.math.WmiSeriesBuilder;
import com.maplesoft.mathdoc.model.math.WmiSubexpressionLabelUtil;
import com.maplesoft.mathdoc.model.math.WmiSumBuilder;
import com.maplesoft.mathdoc.model.math.WmiTablerefBuilder;
import com.maplesoft.mathdoc.model.math.WmiTryStatementBuilder;
import com.maplesoft.mathdoc.model.math.WmiUnevalBuilder;
import com.maplesoft.mathdoc.model.math.WmiUseBuilder;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class WmiMathFactory {
    public static final float SUPERSCRIPT_SCALE = 0.8f;
    public static final float LARGE_SYMBOL_SCALE = 2.0f;
    public static final float SUPERSCRIPT_LARGE_SYMBOL_SCALE = 1.6f;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static WmiMathSemantics BRACKET_SEMANTICS = new WmiMathSemantics(){
        private static final String LINEBREAK_CONTEXT_NAME = "bracketed";

        @Override
        public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
            WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
            WmiMathModel child = (WmiMathModel)composite.getChild(1);
            return child != null ? child.toDag() : null;
        }

        public int getLinebreakCost(WmiMathModel model) {
            return 0;
        }
    };
    private static WmiMathModelBuilder[] builders = null;
    private static WmiMathModelBuilder defaultBuilder = new WmiDefaultMathModelBuilder();
    private static ArrayList contextAwareBuilders = new ArrayList();
    private static Set numericEntities = new HashSet();
    private static boolean subexpressionLabellingOn = false;
    private static int labelWidth = 20;

    private static WmiMathModelBuilder getBuilder(int type) {
        if (builders == null) {
            builders = new WmiMathModelBuilder[60];
            try {
                WmiMathFactory.initializeFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return builders[type];
    }

    public static WmiMathModel createMathModel(WmiMathDocumentModel docModel, Dag dag, String styleName) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext context = new WmiMathContext(docModel.getFontStyle(styleName));
        return WmiMathFactory.createMathModel(docModel, dag, context);
    }

    public static WmiMathModel createMathModel(WmiMathDocumentModel docModel, Dag dag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (context.isSubexpressionLabellingActive()) {
            WmiSubexpressionLabelUtil.locateDuplicates(dag, context);
        }
        WmiMathModel model = WmiMathFactory.createMath(docModel, dag, context);
        if (context.needsAssumptionSummary()) {
            model = new WmiOverModel(docModel, context.reportAssumptions(docModel), model, context);
        }
        if (context.needsSubexpressionLabelDetails()) {
            model = new WmiOverModel(docModel, context.reportSubexpressions(docModel), model, context);
        }
        return model;
    }

    public static WmiMathModel createMath(WmiMathDocumentModel docModel, Dag dag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = null;
        int type = dag.getType();
        if (type == 3) {
            context.setInRational(true);
        }
        if (type > 0 && type < 60) {
            WmiMathModelBuilder b = WmiMathFactory.getBuilder(type);
            if (context.isApplyNumericFormattingOnBuild() && context.getFormatMask() != null && context.getFormatMask().length() > 0 && type <= 5 && (type <= 2 && context.isApplyInteger() && !context.isInRational() || type == 3 && context.isApplyRational() || type > 3)) {
                b = new WmiNumericModel.WmiMaskBuilder();
            }
            if (b != null) {
                model = b.createModel(dag, docModel, context);
            }
        }
        if (model == null) {
            model = defaultBuilder.createModel(dag, docModel, context);
        }
        if (type == 3) {
            context.setInRational(false);
        }
        return model;
    }

    public static WmiMathModel createMath(WmiMathDocumentModel docModel, Dag dag, String styleName) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext context = new WmiMathContext(docModel.getFontStyle(styleName));
        return WmiMathFactory.createMath(docModel, dag, context);
    }

    public static WmiMathTokenModel createMathIdentifierToken(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        return WmiMathFactory.createMathToken(doc, WmiModelTag.MATH_IDENTIFIER, contents, context);
    }

    public static WmiMathTokenModel createMathNumericToken(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        return WmiMathFactory.createMathToken(doc, WmiModelTag.MATH_NUMERIC, contents, context);
    }

    public static WmiMathTokenModel createMathTextToken(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        return WmiMathFactory.createMathToken(doc, WmiModelTag.MATH_TEXT, contents, context);
    }

    public static WmiMathTokenModel createMathOperatorToken(WmiMathDocumentModel doc, String contents, WmiMathContext context) {
        return WmiMathFactory.createMathToken(doc, WmiModelTag.MATH_OPERATOR, contents, context);
    }

    public static WmiMathTokenModel createMathToken(WmiMathDocumentModel doc, WmiModelTag type, String contents, WmiMathContext context) {
        WmiAbstractMathTokenModel token = null;
        if (type == WmiModelTag.MATH_TEXT) {
            token = !WmiMathEntityNameMapper.isNonMarkingEntity(contents) ? new WmiMathTextModel(doc, contents, context) : new WmiMathTextModel(doc, contents, context);
        } else if (type == WmiModelTag.MATH_IDENTIFIER || type == WmiModelTag.MATH_OPERATOR || type == WmiModelTag.MATH_NUMERIC) {
            if (type == WmiModelTag.MATH_OPERATOR) {
                token = new WmiMathOperatorModel(doc, contents, contents, context);
            } else if (type == WmiModelTag.MATH_IDENTIFIER) {
                token = new WmiIdentifierModel(doc, contents, contents, context, false);
            } else if (type == WmiModelTag.MATH_NUMERIC) {
                token = new WmiNumericModel(doc, contents, contents, context);
            }
        }
        return token;
    }

    public static WmiModelTag getTagForEntity(String entityName) {
        WmiModelTag tag = WmiModelTag.MATH_IDENTIFIER;
        if (WmiMathOperatorDictionary.isNameForOperator(entityName)) {
            tag = WmiModelTag.MATH_OPERATOR;
        } else if (numericEntities.contains(entityName)) {
            tag = WmiModelTag.MATH_NUMERIC;
        }
        return tag;
    }

    public static boolean isSubexpressionLabellingOn() {
        return subexpressionLabellingOn;
    }

    public static int getLabelWidth() {
        return labelWidth;
    }

    public static WmiMathModel addBrackets(WmiMathModel model, WmiMathContext context) throws WmiNoWriteAccessException {
        return WmiMathFactory.addBrackets(model, "(", ")", context);
    }

    public static WmiMathModel addBrackets(WmiMathModel model, String left, String right, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiMathFencedModel reply = null;
        WmiMathDocumentModel doc = model.getDocument();
        WmiModel[] kids = new WmiMathModel[]{model};
        try {
            reply = new WmiMathFencedModel(doc, kids, context);
            ((WmiAbstractModel)reply).addAttribute("open", left);
            ((WmiAbstractModel)reply).addAttribute("close", right);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return reply;
    }

    public static void setSuperscriptSize(WmiFontAttributeSet set) {
        int size = Math.round(0.8f * (float)set.getSize());
        set.setSize(size);
    }

    public static void setLargeSymbolSize(WmiFontAttributeSet set) {
        int size = Math.round(2.0f * (float)set.getSize());
        set.setSize(size);
    }

    public static void setSuperscriptLargeSymbolSize(WmiFontAttributeSet set) {
        int size = Math.round(1.6f * (float)set.getSize());
        set.setSize(size);
    }

    public static void updateContext(DagRenderContext cntxt) {
        if (builders == null) {
            builders = new WmiMathModelBuilder[60];
            try {
                WmiMathFactory.initializeFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numberAwareBuilders = contextAwareBuilders.size();
        int i = 0;
        while (i < numberAwareBuilders) {
            ((WmiRenderContextAwareBuilder)contextAwareBuilders.get(i)).updateContext(cntxt);
            ++i;
        }
        int prettyprintSetting = 3;
        boolean labelling = true;
        prettyprintSetting = cntxt.getInterfaceProperty("prettyprint", prettyprintSetting);
        boolean bl = subexpressionLabellingOn = (labelling = cntxt.getInterfaceProperty("labelling", labelling)) && (prettyprintSetting == 2 || prettyprintSetting == 1);
        if (subexpressionLabellingOn) {
            labelWidth = cntxt.getInterfaceProperty("labelwidth", labelWidth);
        }
    }

    private static void addBuilder(int tag, WmiMathModelBuilder builder) {
        assert (builders != null);
        WmiMathFactory.builders[tag] = builder;
        if (builder instanceof WmiRenderContextAwareBuilder) {
            contextAwareBuilders.add(builder);
        }
    }

    private static void initializeFactory() {
        WmiMathFactory.addBuilder(1, new WmiNumericModel.WmiIntNegBuilder());
        WmiMathFactory.addBuilder(2, new WmiNumericModel.WmiIntPosBuilder());
        WmiMathFactory.addBuilder(3, new WmiNumericModel.WmiRationalBuilder());
        WmiMathFactory.addBuilder(6, new WmiNumericModel.WmiComplexBuilder());
        WmiMathFactory.addBuilder(4, new WmiNumericModel.WmiFloatBuilder());
        WmiMathFactory.addBuilder(5, new WmiNumericModel.WmiHFloatBuilder());
        WmiMathFactory.addBuilder(8, new WmiIdentifierModel.WmiNameBuilder());
        WmiMathFactory.addBuilder(7, new WmiMathStringModel.WmiStringBuilder());
        WmiMathFactory.addBuilder(19, new WmiUnevalBuilder());
        WmiMathFactory.addBuilder(16, new WmiSumBuilder());
        WmiMathFactory.addBuilder(14, new WmiProductBuilder());
        WmiMathFactory.addBuilder(15, new WmiSeriesBuilder());
        WmiMathFactory.addBuilder(13, new WmiPowerBuilder());
        WmiMathFactory.addBuilder(10, new WmiTablerefBuilder());
        WmiMathFactory.addBuilder(41, new WmiAssignmentBuilder());
        WmiMathFactory.addBuilder(35, new WmiRangeBuilder());
        WmiMathFactory.addBuilder(12, new WmiCatenateBuilder());
        WmiMathFactory.addBuilder(11, new WmiDColonBuilder());
        WmiMathFactory.addBuilder(20, new WmiRelationalBuilder.WmiEquationBuilder());
        WmiMathFactory.addBuilder(21, new WmiRelationalBuilder.WmiInequalityBuilder());
        WmiMathFactory.addBuilder(22, new WmiRelationalBuilder.WmiLessThanEqualsBuilder());
        WmiMathFactory.addBuilder(23, new WmiRelationalBuilder.WmiLessThanBuilder());
        WmiMathFactory.addBuilder(24, new WmiLogicalBuilder.WmiAndBuilder());
        WmiMathFactory.addBuilder(26, new WmiLogicalBuilder.WmiOrBuilder());
        WmiMathFactory.addBuilder(27, new WmiLogicalBuilder.WmiXorBuilder());
        WmiMathFactory.addBuilder(28, new WmiLogicalBuilder.WmiImpliesBuilder());
        WmiMathFactory.addBuilder(25, new WmiNotBuilder());
        WmiMathFactory.addBuilder(29, new WmiCollectionBuilder.WmiExpSequenceModelBuilder());
        WmiMathFactory.addBuilder(30, new WmiCollectionBuilder.WmiListModelBuilder());
        WmiMathFactory.addBuilder(36, new WmiCollectionBuilder.WmiSetModelBuilder());
        WmiMathFactory.addBuilder(55, new WmiHashTableBuilder());
        WmiMathFactory.addBuilder(18, new WmiFunctionBuilder());
        WmiMathFactory.addBuilder(34, new WmiProcBuilder());
        WmiMathFactory.addBuilder(46, new WmiProcBuilder.WmiStatementSequenceBuilder());
        WmiMathFactory.addBuilder(43, new WmiIfStatementBuilder());
        WmiMathFactory.addBuilder(42, new WmiForStatementBuilder());
        WmiMathFactory.addBuilder(49, new WmiTryStatementBuilder());
        WmiMathFactory.addBuilder(53, new WmiUseBuilder());
        WmiMathFactory.addBuilder(45, new WmiKeyWordBuilder("save"));
        WmiMathFactory.addBuilder(44, new WmiKeyWordBuilder("read"));
        WmiMathFactory.addBuilder(47, new WmiKeyWordBuilder("stop"));
        WmiMathFactory.addBuilder(51, new WmiKeyWordBuilder("break"));
        WmiMathFactory.addBuilder(52, new WmiKeyWordBuilder("next"));
        WmiMathFactory.addBuilder(50, new WmiKeyWordBuilder("return"));
        WmiMathFactory.addBuilder(48, new WmiKeyWordBuilder("error"));
        WmiMathFactory.addBuilder(31, new WmiLocalBuilder());
        WmiMathFactory.addBuilder(39, new WmiProcBuilder());
        WmiMathFactory.addBuilder(40, new WmiProcBuilder());
        WmiMathFactory.addBuilder(9, new WmiMemberBuilder());
        WmiMathFactory.addBuilder(38, new WmiLPrintIdentifierBuilder());
        WmiMathFactory.addBuilder(37, new WmiLPrintIdentifierBuilder(2));
        numericEntities.add("ExponentialE");
        numericEntities.add("frac12");
        numericEntities.add("frac14");
        numericEntities.add("frac34");
        numericEntities.add("ImaginaryI");
        numericEntities.add("infin");
        numericEntities.add("half");
    }
}

